/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import org.apache.hadoop.hdds.StringUtils;

public final class MetadataKeyFilters {
    private MetadataKeyFilters() {
    }

    public static KeyPrefixFilter getUnprefixedKeyFilter() {
        return KeyPrefixFilter.newFilter("#", true);
    }

    public static final class KeyPrefixFilter {
        private static final KeyPrefixFilter NULL_FILTER = new KeyPrefixFilter(null, true);
        private final byte[] prefix;
        private final boolean isPositive;
        private int keysScanned = 0;
        private int keysHinted = 0;

        private KeyPrefixFilter(byte[] prefix, boolean isPositive) {
            this.prefix = prefix;
            this.isPositive = isPositive;
        }

        public boolean filterKey(byte[] currentKey) {
            ++this.keysScanned;
            if (currentKey == null) {
                return false;
            }
            if (this.prefix == null) {
                return true;
            }
            if (this.isPositive == KeyPrefixFilter.prefixMatch(this.prefix, currentKey)) {
                ++this.keysHinted;
                return true;
            }
            return false;
        }

        public int getKeysScannedNum() {
            return this.keysScanned;
        }

        public int getKeysHintedNum() {
            return this.keysHinted;
        }

        private static boolean prefixMatch(byte[] prefix, byte[] key) {
            if (key.length < prefix.length) {
                return false;
            }
            for (int i = 0; i < prefix.length; ++i) {
                if (key[i] == prefix[i]) continue;
                return false;
            }
            return true;
        }

        public static KeyPrefixFilter newFilter(String prefix) {
            return KeyPrefixFilter.newFilter(prefix, false);
        }

        public static KeyPrefixFilter newFilter(String prefix, boolean negative) {
            if (prefix == null) {
                if (negative) {
                    throw new IllegalArgumentException("The prefix of a negative filter cannot be null");
                }
                return NULL_FILTER;
            }
            return new KeyPrefixFilter(StringUtils.string2Bytes((String)prefix), !negative);
        }
    }
}

