/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server;

import com.google.common.collect.Sets;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;

public class OzoneAdmins {
    private volatile Set<String> adminUsernames;
    private final Set<String> adminGroups;

    public OzoneAdmins(Collection<String> adminUsernames) {
        this(adminUsernames, null);
    }

    public OzoneAdmins(Collection<String> adminUsernames, Collection<String> adminGroups) {
        this.setAdminUsernames(adminUsernames);
        this.adminGroups = adminGroups != null ? Collections.unmodifiableSet(new LinkedHashSet<String>(adminGroups)) : Collections.emptySet();
    }

    public static OzoneAdmins getOzoneAdmins(String starterUser, OzoneConfiguration configuration) {
        Collection<String> adminUserNames = OzoneAdmins.getOzoneAdminsFromConfig(configuration, starterUser);
        Collection<String> adminGroupNames = OzoneAdmins.getOzoneAdminsGroupsFromConfig(configuration);
        return new OzoneAdmins(adminUserNames, adminGroupNames);
    }

    public static OzoneAdmins getReadonlyAdmins(OzoneConfiguration configuration) {
        Collection<String> omReadOnlyAdmins = OzoneAdmins.getOzoneReadOnlyAdminsFromConfig(configuration);
        Collection<String> omReadOnlyAdminsGroups = OzoneAdmins.getOzoneReadOnlyAdminsGroupsFromConfig(configuration);
        return new OzoneAdmins(omReadOnlyAdmins, omReadOnlyAdminsGroups);
    }

    public void checkAdminUserPrivilege(UserGroupInformation ugi) throws AccessControlException {
        if (ugi != null && !this.isAdmin(ugi)) {
            throw new AccessControlException("Access denied for user " + ugi.getUserName() + ". Superuser privilege is required.");
        }
    }

    private boolean hasAdminGroup(Collection<String> userGroups) {
        return !Sets.intersection(this.adminGroups, new LinkedHashSet<String>(userGroups)).isEmpty();
    }

    public boolean isAdmin(UserGroupInformation user) {
        return user != null && (this.adminUsernames.contains("*") || this.adminUsernames.contains(user.getShortUserName()) || this.hasAdminGroup(user.getGroups()));
    }

    public Collection<String> getAdminGroups() {
        return this.adminGroups;
    }

    public Set<String> getAdminUsernames() {
        return this.adminUsernames;
    }

    public void setAdminUsernames(Collection<String> adminUsernames) {
        this.adminUsernames = adminUsernames != null ? Collections.unmodifiableSet(new LinkedHashSet<String>(adminUsernames)) : Collections.emptySet();
    }

    public static Collection<String> getOzoneAdminsFromConfig(OzoneConfiguration conf, String starterUser) {
        Collection ozAdmins = conf.getTrimmedStringCollection("ozone.administrators");
        if (!ozAdmins.contains(starterUser)) {
            ozAdmins.add(starterUser);
        }
        return ozAdmins;
    }

    public static Collection<String> getOzoneAdminsGroupsFromConfig(OzoneConfiguration configuration) {
        return configuration.getTrimmedStringCollection("ozone.administrators.groups");
    }

    public static Collection<String> getOzoneReadOnlyAdminsFromConfig(OzoneConfiguration conf) {
        return conf.getTrimmedStringCollection("ozone.readonly.administrators");
    }

    public static Collection<String> getOzoneReadOnlyAdminsGroupsFromConfig(OzoneConfiguration conf) {
        return conf.getTrimmedStringCollection("ozone.readonly.administrators.groups");
    }

    public static Set<String> getS3AdminsFromConfig(OzoneConfiguration conf) throws IOException {
        HashSet<String> ozoneAdmins = new HashSet<String>(conf.getTrimmedStringCollection("ozone.s3.administrators"));
        if (ozoneAdmins.isEmpty()) {
            ozoneAdmins = new HashSet(conf.getTrimmedStringCollection("ozone.administrators"));
        }
        String omSPN = UserGroupInformation.getCurrentUser().getShortUserName();
        ozoneAdmins.add(omSPN);
        return ozoneAdmins;
    }

    public static Set<String> getS3AdminsGroupsFromConfig(OzoneConfiguration conf) {
        HashSet<String> s3AdminsGroup = new HashSet<String>(conf.getTrimmedStringCollection("ozone.s3.administrators.groups"));
        if (s3AdminsGroup.isEmpty() && conf.getTrimmedStringCollection("ozone.s3.administrators").isEmpty()) {
            s3AdminsGroup = new HashSet(conf.getTrimmedStringCollection("ozone.administrators.groups"));
        }
        return s3AdminsGroup;
    }

    public static OzoneAdmins getS3Admins(OzoneConfiguration conf) {
        Set<String> s3Admins;
        try {
            s3Admins = OzoneAdmins.getS3AdminsFromConfig(conf);
        }
        catch (IOException ie) {
            s3Admins = Collections.emptySet();
        }
        Set<String> s3AdminGroups = OzoneAdmins.getS3AdminsGroupsFromConfig(conf);
        return new OzoneAdmins(s3Admins, s3AdminGroups);
    }

    public static boolean isS3Admin(@Nullable UserGroupInformation user, OzoneAdmins s3Admins) {
        return null != user && s3Admins.isAdmin(user);
    }

    public static boolean isS3Admin(@Nullable UserGroupInformation user, OzoneConfiguration conf) {
        OzoneAdmins s3Admins = OzoneAdmins.getS3Admins(conf);
        return OzoneAdmins.isS3Admin(user, s3Admins);
    }
}

