/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocolPB;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.server.OzoneProtocolMessageDispatcher;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.apache.hadoop.ipc.ProcessingDetails;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMPerformanceMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.exceptions.OMLeaderNotReadyException;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisServer;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.om.request.validation.RequestValidations;
import org.apache.hadoop.ozone.om.request.validation.ValidationContext;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.protocolPB.OzoneManagerRequestHandler;
import org.apache.hadoop.ozone.protocolPB.RequestHandler;
import org.apache.hadoop.ozone.security.S3SecurityUtil;
import org.apache.hadoop.ozone.upgrade.LayoutVersionManager;
import org.apache.hadoop.ozone.util.MetricUtil;
import org.apache.ratis.protocol.RaftPeerId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneManagerProtocolServerSideTranslatorPB
implements OzoneManagerProtocolPB {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerProtocolServerSideTranslatorPB.class);
    private static final String OM_REQUESTS_PACKAGE = "org.apache.hadoop.ozone";
    private final OzoneManagerRatisServer omRatisServer;
    private final RequestHandler handler;
    private final OzoneManager ozoneManager;
    private final OzoneProtocolMessageDispatcher<OzoneManagerProtocolProtos.OMRequest, OzoneManagerProtocolProtos.OMResponse, ProtocolMessageEnum> dispatcher;
    private final RequestValidations requestValidations;
    private final OMPerformanceMetrics perfMetrics;
    private OzoneManagerProtocolProtos.OMRequest lastRequestToSubmit;

    public OzoneManagerProtocolServerSideTranslatorPB(OzoneManager impl, OzoneManagerRatisServer ratisServer, ProtocolMessageMetrics<ProtocolMessageEnum> metrics) {
        this.ozoneManager = impl;
        this.perfMetrics = impl.getPerfMetrics();
        this.handler = new OzoneManagerRequestHandler(impl);
        this.omRatisServer = ratisServer;
        this.dispatcher = new OzoneProtocolMessageDispatcher("OzoneProtocol", metrics, LOG, OMPBHelper::processForDebug, OMPBHelper::processForDebug);
        this.requestValidations = new RequestValidations().fromPackage(OM_REQUESTS_PACKAGE).withinContext(ValidationContext.of((LayoutVersionManager)this.ozoneManager.getVersionManager(), this.ozoneManager.getMetadataManager())).load();
    }

    public OzoneManagerProtocolProtos.OMResponse submitRequest(RpcController controller, OzoneManagerProtocolProtos.OMRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.OMRequest validatedRequest;
        try {
            validatedRequest = (OzoneManagerProtocolProtos.OMRequest)MetricUtil.captureLatencyNs((MutableRate)this.perfMetrics.getValidateRequestLatencyNs(), () -> this.requestValidations.validateRequest(request));
        }
        catch (Exception e) {
            if (e instanceof OMException) {
                return OzoneManagerRatisUtils.createErrorResponse(request, (IOException)((Object)((OMException)((Object)e))));
            }
            throw new ServiceException((Throwable)e);
        }
        OzoneManagerProtocolProtos.OMResponse response = (OzoneManagerProtocolProtos.OMResponse)this.dispatcher.processRequest((Object)validatedRequest, this::processRequest, (Object)request.getCmdType(), request.getTraceID());
        return (OzoneManagerProtocolProtos.OMResponse)MetricUtil.captureLatencyNs((MutableRate)this.perfMetrics.getValidateResponseLatencyNs(), () -> this.requestValidations.validateResponse(request, response));
    }

    @VisibleForTesting
    public OzoneManagerProtocolProtos.OMResponse processRequest(OzoneManagerProtocolProtos.OMRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.OMResponse response = this.internalProcessRequest(request);
        if (response.hasOmLockDetails()) {
            OzoneManagerProtocolProtos.OMLockDetailsProto omLockDetailsProto = response.getOmLockDetails();
            Server.Call call = (Server.Call)Server.getCurCall().get();
            if (call != null) {
                call.getProcessingDetails().add(ProcessingDetails.Timing.LOCKWAIT, omLockDetailsProto.getWaitLockNanos(), TimeUnit.NANOSECONDS);
                call.getProcessingDetails().add(ProcessingDetails.Timing.LOCKSHARED, omLockDetailsProto.getReadLockNanos(), TimeUnit.NANOSECONDS);
                call.getProcessingDetails().add(ProcessingDetails.Timing.LOCKEXCLUSIVE, omLockDetailsProto.getWriteLockNanos(), TimeUnit.NANOSECONDS);
            }
        }
        return response;
    }

    private OzoneManagerProtocolProtos.OMResponse internalProcessRequest(OzoneManagerProtocolProtos.OMRequest request) throws ServiceException {
        boolean s3Auth = false;
        try {
            OzoneManagerProtocolProtos.OMResponse cached;
            if (request.hasS3Authentication()) {
                OzoneManager.setS3Auth(request.getS3Authentication());
                try {
                    s3Auth = true;
                    S3SecurityUtil.validateS3Credential(request, this.ozoneManager);
                }
                catch (IOException ex) {
                    OzoneManagerProtocolProtos.OMResponse oMResponse = OzoneManagerRatisUtils.createErrorResponse(request, ex);
                    OzoneManager.setS3Auth(null);
                    return oMResponse;
                }
            }
            if (OmUtils.isReadOnly((OzoneManagerProtocolProtos.OMRequest)request)) {
                OzoneManagerProtocolProtos.OMResponse oMResponse = this.submitReadRequestToOM(request);
                return oMResponse;
            }
            if (!s3Auth) {
                OzoneManagerRatisUtils.checkLeaderStatus(this.ozoneManager);
            }
            if ((cached = this.omRatisServer.checkRetryCache()) != null) {
                OzoneManagerProtocolProtos.OMResponse oMResponse = cached;
                return oMResponse;
            }
            this.lastRequestToSubmit = request;
            OzoneManagerProtocolProtos.OMResponse oMResponse = this.ozoneManager.getOmExecutionFlow().submit(request);
            return oMResponse;
        }
        finally {
            OzoneManager.setS3Auth(null);
        }
    }

    @VisibleForTesting
    public OzoneManagerProtocolProtos.OMRequest getLastRequestToSubmit() {
        return this.lastRequestToSubmit;
    }

    private OzoneManagerProtocolProtos.OMResponse submitReadRequestToOM(OzoneManagerProtocolProtos.OMRequest request) throws ServiceException {
        OzoneManagerRatisServer.RaftServerStatus raftServerStatus = this.omRatisServer.getLeaderStatus();
        if (raftServerStatus == OzoneManagerRatisServer.RaftServerStatus.LEADER_AND_READY || request.getCmdType().equals((Object)OzoneManagerProtocolProtos.Type.PrepareStatus)) {
            return this.handler.handleReadRequest(request);
        }
        throw this.createLeaderErrorException(raftServerStatus);
    }

    private ServiceException createLeaderErrorException(OzoneManagerRatisServer.RaftServerStatus raftServerStatus) {
        if (raftServerStatus == OzoneManagerRatisServer.RaftServerStatus.NOT_LEADER) {
            return new ServiceException((Throwable)this.omRatisServer.newOMNotLeaderException());
        }
        return this.createLeaderNotReadyException();
    }

    private ServiceException createLeaderNotReadyException() {
        RaftPeerId raftPeerId = this.omRatisServer.getRaftPeerId();
        OMLeaderNotReadyException leaderNotReadyException = new OMLeaderNotReadyException(String.valueOf(raftPeerId.toString()) + " is Leader " + "but not ready to process request yet.");
        LOG.debug(leaderNotReadyException.getMessage());
        return new ServiceException((Throwable)leaderNotReadyException);
    }

    public static Logger getLog() {
        return LOG;
    }
}

