/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.multipart;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3InitiateMultipartUploadResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"directoryTable", "openFileTable", "multipartInfoTable"})
public class S3InitiateMultipartUploadResponseWithFSO
extends S3InitiateMultipartUploadResponse {
    private List<OmDirectoryInfo> parentDirInfos;
    private String mpuDBKey;
    private long volumeId;
    private long bucketId;
    private OmBucketInfo omBucketInfo;

    public S3InitiateMultipartUploadResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmMultipartKeyInfo omMultipartKeyInfo, @Nonnull OmKeyInfo omKeyInfo, @Nonnull String mpuDBKey, @Nonnull List<OmDirectoryInfo> parentDirInfos, @Nonnull BucketLayout bucketLayout, @Nonnull long volumeId, @Nonnull long bucketId, @Nonnull OmBucketInfo omBucketInfo) {
        super(omResponse, omMultipartKeyInfo, omKeyInfo, bucketLayout);
        this.parentDirInfos = parentDirInfos;
        this.mpuDBKey = mpuDBKey;
        this.volumeId = volumeId;
        this.bucketId = bucketId;
        this.omBucketInfo = omBucketInfo;
    }

    public S3InitiateMultipartUploadResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.parentDirInfos != null) {
            for (OmDirectoryInfo parentDirInfo : this.parentDirInfos) {
                String parentKey = omMetadataManager.getOzonePathKey(this.volumeId, this.bucketId, parentDirInfo.getParentObjectID(), parentDirInfo.getName());
                omMetadataManager.getDirectoryTable().putWithBatch(batchOperation, (Object)parentKey, (Object)parentDirInfo);
            }
            String bucketKey = omMetadataManager.getBucketKey(this.omBucketInfo.getVolumeName(), this.omBucketInfo.getBucketName());
            omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)bucketKey, (Object)this.omBucketInfo);
        }
        OMFileRequest.addToOpenFileTableForMultipart(omMetadataManager, batchOperation, this.getOmKeyInfo(), this.getOmMultipartKeyInfo().getUploadID(), this.volumeId, this.bucketId);
        omMetadataManager.getMultipartInfoTable().putWithBatch(batchOperation, (Object)this.mpuDBKey, (Object)this.getOmMultipartKeyInfo());
    }
}

