/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.validation;

import java.io.IOException;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManagerUtils;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.upgrade.LayoutVersionManager;

@InterfaceStability.Evolving
public interface ValidationContext {
    public LayoutVersionManager versionManager();

    public BucketLayout getBucketLayout(String var1, String var2) throws IOException;

    public static ValidationContext of(final LayoutVersionManager versionManager, final OMMetadataManager omMetadataManager) {
        return new ValidationContext(){

            @Override
            public LayoutVersionManager versionManager() {
                return versionManager;
            }

            @Override
            public BucketLayout getBucketLayout(String volumeName, String bucketName) throws IOException {
                return OzoneManagerUtils.getBucketLayout(omMetadataManager, volumeName, bucketName);
            }
        };
    }
}

