/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.bucket;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.validation.RequestFeatureValidator;
import org.apache.hadoop.ozone.om.request.validation.ValidationCondition;
import org.apache.hadoop.ozone.om.request.validation.ValidationContext;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.bucket.OMBucketDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.request.validation.RequestProcessingPhase;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMBucketDeleteRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMBucketDeleteRequest.class);

    public OMBucketDeleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMClientResponse omClientResponse;
        boolean success;
        Exception exception;
        OzoneManagerProtocolProtos.UserInfo userInfo;
        Map<String, String> auditMap;
        AuditLogger auditLogger;
        String bucketName;
        String volumeName;
        OMMetrics omMetrics;
        block22: {
            long transactionLogIndex = context.getIndex();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumBucketDeletes();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            OzoneManagerProtocolProtos.OMRequest omRequest = this.getOmRequest();
            OzoneManagerProtocolProtos.DeleteBucketRequest deleteBucketRequest = omRequest.getDeleteBucketRequest();
            volumeName = deleteBucketRequest.getVolumeName();
            bucketName = deleteBucketRequest.getBucketName();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            auditLogger = ozoneManager.getAuditLogger();
            auditMap = this.buildVolumeAuditMap(volumeName);
            auditMap.put("bucket", bucketName);
            userInfo = this.getOmRequest().getUserInfo();
            exception = null;
            boolean acquiredBucketLock = false;
            boolean acquiredVolumeLock = false;
            success = true;
            omClientResponse = null;
            try {
                try {
                    if (ozoneManager.getAclsEnabled()) {
                        this.checkAcls(ozoneManager, OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.DELETE, volumeName, bucketName, null);
                    }
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volumeName}));
                    acquiredVolumeLock = this.getOmLockDetails().isLockAcquired();
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    acquiredBucketLock = this.getOmLockDetails().isLockAcquired();
                    String bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
                    OmBucketInfo omBucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)bucketKey);
                    if (omBucketInfo == null) {
                        LOG.debug("bucket: {} not found ", (Object)bucketName);
                        throw new OMException("Bucket not exists", OMException.ResultCodes.BUCKET_NOT_FOUND);
                    }
                    if (!omMetadataManager.isBucketEmpty(volumeName, bucketName)) {
                        LOG.debug("bucket: {} is not empty ", (Object)bucketName);
                        throw new OMException("Bucket is not empty", OMException.ResultCodes.BUCKET_NOT_EMPTY);
                    }
                    if (omMetadataManager.containsIncompleteMPUs(volumeName, bucketName)) {
                        LOG.debug("Volume '{}', Bucket '{}' can't be deleted when it has incomplete multipart uploads", (Object)volumeName, (Object)bucketName);
                        throw new OMException(String.format("Volume %s, Bucket %s can't be deleted when it has incomplete multipart uploads", volumeName, bucketName), OMException.ResultCodes.BUCKET_NOT_EMPTY);
                    }
                    String snapshotBucketKey = String.valueOf(bucketKey) + "/";
                    if (this.bucketContainsSnapshot(omMetadataManager, snapshotBucketKey)) {
                        LOG.debug("Bucket '{}' can't be deleted when it has snapshots", (Object)bucketName);
                        throw new OMException("Bucket " + bucketName + " can't be deleted when it has snapshots", OMException.ResultCodes.CONTAINS_SNAPSHOT);
                    }
                    if (omBucketInfo.getBucketLayout().isFileSystemOptimized()) {
                        omMetrics.incNumFSOBucketDeletes();
                    }
                    omMetrics.decNumBuckets();
                    omMetadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)bucketKey), CacheValue.get((long)transactionLogIndex));
                    omResponse.setDeleteBucketResponse(OzoneManagerProtocolProtos.DeleteBucketResponse.newBuilder().build());
                    String volumeKey = omMetadataManager.getVolumeKey(volumeName);
                    OmVolumeArgs omVolumeArgs = (OmVolumeArgs)omMetadataManager.getVolumeTable().getReadCopy((Object)volumeKey);
                    if (omVolumeArgs == null) {
                        throw new OMException("Volume " + volumeName + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
                    }
                    omVolumeArgs.incrUsedNamespace(-1L);
                    omMetadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)volumeKey), CacheValue.get((long)transactionLogIndex, (Object)omVolumeArgs));
                    omClientResponse = new OMBucketDeleteResponse(omResponse.build(), volumeName, bucketName, omVolumeArgs.copyObject());
                }
                catch (IOException | InvalidPathException ex) {
                    success = false;
                    exception = ex;
                    omClientResponse = new OMBucketDeleteResponse(this.createErrorOMResponse(omResponse, exception));
                    if (acquiredBucketLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (acquiredVolumeLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volumeName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (acquiredBucketLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (acquiredVolumeLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volumeName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredBucketLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (acquiredVolumeLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volumeName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.markForAudit(auditLogger, this.buildAuditMessage(OMAction.DELETE_BUCKET, auditMap, exception, userInfo));
        if (success) {
            LOG.debug("Deleted bucket:{} in volume:{}", (Object)bucketName, (Object)volumeName);
            return omClientResponse;
        }
        omMetrics.incNumBucketDeleteFails();
        LOG.error("Delete bucket failed for bucket:{} in volume:{}", new Object[]{bucketName, volumeName, exception});
        return omClientResponse;
    }

    private boolean bucketContainsSnapshot(OMMetadataManager omMetadataManager, String snapshotBucketKey) throws IOException {
        return this.bucketContainsSnapshotInCache(omMetadataManager, snapshotBucketKey) || this.bucketContainsSnapshotInTable(omMetadataManager, snapshotBucketKey);
    }

    private boolean bucketContainsSnapshotInTable(OMMetadataManager omMetadataManager, String snapshotBucketKey) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Table.KeyValueIterator snapshotIterator = omMetadataManager.getSnapshotInfoTable().iterator();){
            snapshotIterator.seek((Object)snapshotBucketKey);
            if (snapshotIterator.hasNext()) {
                return ((String)((Table.KeyValue)snapshotIterator.next()).getKey()).startsWith(snapshotBucketKey);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return false;
    }

    private boolean bucketContainsSnapshotInCache(OMMetadataManager omMetadataManager, String snapshotBucketKey) {
        Iterator cacheIter = omMetadataManager.getSnapshotInfoTable().cacheIterator();
        while (cacheIter.hasNext()) {
            Map.Entry cacheKeyValue = (Map.Entry)cacheIter.next();
            String key = (String)((CacheKey)cacheKeyValue.getKey()).getCacheKey();
            if (!key.startsWith(snapshotBucketKey)) continue;
            return true;
        }
        return false;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.DeleteBucket)
    public static OzoneManagerProtocolProtos.OMRequest blockBucketDeleteWithBucketLayoutFromOldClient(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws IOException {
        OzoneManagerProtocolProtos.DeleteBucketRequest request = req.getDeleteBucketRequest();
        if (request.hasBucketName() && request.hasVolumeName()) {
            BucketLayout bucketLayout = ctx.getBucketLayout(request.getVolumeName(), request.getBucketName());
            bucketLayout.validateSupportedOperation();
        }
        return req;
    }
}

