/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.utils.DBCheckpointMetrics;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.ozone.om.OmMetadataReaderMetrics;

@InterfaceAudience.Private
@Metrics(about="Ozone Manager Metrics", context="dfs")
public class OMMetrics
implements OmMetadataReaderMetrics {
    private static final String SOURCE_NAME = OMMetrics.class.getSimpleName();
    @Metric
    private MutableCounterLong numVolumeOps;
    @Metric
    private MutableCounterLong numBucketOps;
    @Metric
    private MutableCounterLong numKeyOps;
    @Metric
    private MutableCounterLong numFSOps;
    @Metric
    private MutableCounterLong numVolumeCreates;
    @Metric
    private MutableCounterLong numVolumeUpdates;
    @Metric
    private MutableCounterLong numVolumeInfos;
    @Metric
    private MutableCounterLong numVolumeCheckAccesses;
    @Metric
    private MutableCounterLong numBucketCreates;
    @Metric
    private MutableCounterLong numFSOBucketCreates;
    @Metric
    private MutableCounterLong numVolumeDeletes;
    @Metric
    private MutableCounterLong numBucketInfos;
    @Metric
    private MutableCounterLong numBucketUpdates;
    @Metric
    private MutableCounterLong numBucketDeletes;
    @Metric
    private MutableCounterLong numFSOBucketDeletes;
    @Metric
    private MutableCounterLong numKeyAllocate;
    @Metric
    private MutableCounterLong numKeyLookup;
    @Metric
    private MutableCounterLong numKeyRenames;
    @Metric
    private MutableCounterLong numKeyDeletes;
    @Metric
    private MutableCounterLong numBucketLists;
    @Metric
    private MutableCounterLong numKeyLists;
    @Metric
    private MutableCounterLong numVolumeLists;
    @Metric
    private MutableCounterLong numKeyCommits;
    @Metric
    private MutableCounterLong numKeyHSyncs;
    @Metric
    private MutableCounterLong numBlockAllocations;
    @Metric
    private MutableCounterLong numGetServiceLists;
    @Metric
    private MutableCounterLong numBucketS3Lists;
    @Metric
    private MutableCounterLong numInitiateMultipartUploads;
    @Metric
    private MutableCounterLong numCompleteMultipartUploads;
    @Metric
    private MutableCounterLong numSnapshotCreates;
    @Metric
    private MutableCounterLong numSnapshotDeletes;
    @Metric
    private MutableCounterLong numSnapshotLists;
    @Metric
    private MutableCounterLong numSnapshotRenames;
    @Metric
    private MutableCounterLong numSnapshotDiffJobs;
    @Metric
    private MutableCounterLong numSnapshotInfos;
    @Metric
    private MutableCounterLong numCancelSnapshotDiffs;
    @Metric
    private MutableCounterLong numListSnapshotDiffJobs;
    @Metric
    private MutableGaugeInt numSnapshotCacheSize;
    @Metric
    private MutableCounterLong numGetFileStatus;
    @Metric
    private MutableCounterLong numCreateDirectory;
    @Metric
    private MutableCounterLong numCreateFile;
    @Metric
    private MutableCounterLong numLookupFile;
    @Metric
    private MutableCounterLong numListStatus;
    @Metric
    private MutableCounterLong numListOpenFiles;
    @Metric
    private MutableCounterLong numOpenKeyDeleteRequests;
    @Metric
    private MutableCounterLong numOpenKeysSubmittedForDeletion;
    @Metric
    private MutableCounterLong numOpenKeysDeleted;
    @Metric
    private MutableCounterLong numOpenKeysCleaned;
    @Metric
    private MutableCounterLong numOpenKeysHSyncCleaned;
    @Metric
    private MutableCounterLong numExpiredMPUAbortRequests;
    @Metric
    private MutableCounterLong numExpiredMPUSubmittedForAbort;
    @Metric
    private MutableCounterLong numExpiredMPUAborted;
    @Metric
    private MutableCounterLong numExpiredMPUPartsAborted;
    @Metric
    private MutableCounterLong numAddAcl;
    @Metric
    private MutableCounterLong numSetAcl;
    @Metric
    private MutableCounterLong numGetAcl;
    @Metric
    private MutableCounterLong numRemoveAcl;
    @Metric
    private MutableCounterLong numSetTime;
    @Metric
    private MutableCounterLong numGetKeyInfo;
    @Metric
    private MutableCounterLong numGetObjectTagging;
    @Metric
    private MutableCounterLong numPutObjectTagging;
    @Metric
    private MutableCounterLong numDeleteObjectTagging;
    @Metric
    private MutableCounterLong numVolumeCreateFails;
    @Metric
    private MutableCounterLong numVolumeUpdateFails;
    @Metric
    private MutableCounterLong numVolumeInfoFails;
    @Metric
    private MutableCounterLong numVolumeDeleteFails;
    @Metric
    private MutableCounterLong numBucketCreateFails;
    @Metric
    private MutableCounterLong numVolumeCheckAccessFails;
    @Metric
    private MutableCounterLong numBucketInfoFails;
    @Metric
    private MutableCounterLong numBucketUpdateFails;
    @Metric
    private MutableCounterLong numBucketDeleteFails;
    @Metric
    private MutableCounterLong numKeyAllocateFails;
    @Metric
    private MutableCounterLong numKeyLookupFails;
    @Metric
    private MutableCounterLong numKeyRenameFails;
    @Metric
    private MutableCounterLong numKeyDeleteFails;
    @Metric
    private MutableCounterLong numBucketListFails;
    @Metric
    private MutableCounterLong numKeyListFails;
    @Metric
    private MutableCounterLong numVolumeListFails;
    @Metric
    private MutableCounterLong numKeyCommitFails;
    @Metric
    private MutableCounterLong numBlockAllocationFails;
    @Metric
    private MutableCounterLong numGetServiceListFails;
    @Metric
    private MutableCounterLong numBucketS3ListFails;
    @Metric
    private MutableCounterLong numInitiateMultipartUploadFails;
    @Metric
    private MutableCounterLong numCommitMultipartUploadParts;
    @Metric
    private MutableCounterLong numCommitMultipartUploadPartFails;
    @Metric
    private MutableCounterLong numCompleteMultipartUploadFails;
    @Metric
    private MutableCounterLong numAbortMultipartUploads;
    @Metric
    private MutableCounterLong numAbortMultipartUploadFails;
    @Metric
    private MutableCounterLong numListMultipartUploadParts;
    @Metric
    private MutableCounterLong numListMultipartUploadPartFails;
    @Metric
    private MutableCounterLong numOpenKeyDeleteRequestFails;
    @Metric
    private MutableCounterLong numExpiredMPUAbortRequestFails;
    @Metric
    private MutableCounterLong numSnapshotCreateFails;
    @Metric
    private MutableCounterLong numSnapshotRenameFails;
    @Metric
    private MutableCounterLong numSnapshotDeleteFails;
    @Metric
    private MutableCounterLong numSnapshotListFails;
    @Metric
    private MutableCounterLong numSnapshotDiffJobFails;
    @Metric
    private MutableCounterLong numSnapshotInfoFails;
    @Metric
    private MutableCounterLong numCancelSnapshotDiffFails;
    @Metric
    private MutableCounterLong numListSnapshotDiffJobFails;
    @Metric
    private MutableCounterLong numSnapshotActive;
    @Metric
    private MutableCounterLong numSnapshotDeleted;
    @Metric
    private MutableCounterLong numTenantOps;
    @Metric
    private MutableCounterLong numTenants;
    @Metric
    private MutableCounterLong numTenantCreates;
    @Metric
    private MutableCounterLong numTenantCreateFails;
    @Metric
    private MutableCounterLong numTenantDeletes;
    @Metric
    private MutableCounterLong numTenantDeleteFails;
    @Metric
    private MutableCounterLong numTenantAssignUsers;
    @Metric
    private MutableCounterLong numTenantAssignUserFails;
    @Metric
    private MutableCounterLong numTenantRevokeUsers;
    @Metric
    private MutableCounterLong numTenantRevokeUserFails;
    @Metric
    private MutableCounterLong numTenantAssignAdmins;
    @Metric
    private MutableCounterLong numTenantAssignAdminFails;
    @Metric
    private MutableCounterLong numTenantRevokeAdmins;
    @Metric
    private MutableCounterLong numTenantRevokeAdminFails;
    @Metric
    private MutableCounterLong numTenantLists;
    @Metric
    private MutableCounterLong numTenantGetUserInfos;
    @Metric
    private MutableCounterLong numTenantTenantUserLists;
    @Metric
    private MutableCounterLong numRecoverLease;
    @Metric
    private MutableCounterLong numGetFileStatusFails;
    @Metric
    private MutableCounterLong numCreateDirectoryFails;
    @Metric
    private MutableCounterLong numCreateFileFails;
    @Metric
    private MutableCounterLong numLookupFileFails;
    @Metric
    private MutableCounterLong numListStatusFails;
    @Metric
    private MutableCounterLong numListOpenFilesFails;
    @Metric
    private MutableCounterLong getNumGetKeyInfoFails;
    @Metric
    private MutableCounterLong numGetObjectTaggingFails;
    @Metric
    private MutableCounterLong numPutObjectTaggingFails;
    @Metric
    private MutableCounterLong numDeleteObjectTaggingFails;
    @Metric
    private MutableCounterLong numRecoverLeaseFails;
    @Metric
    private MutableCounterLong totalDataCommitted;
    @Metric
    private MutableCounterLong numVolumes;
    @Metric
    private MutableCounterLong numBuckets;
    @Metric
    private MutableCounterLong numS3Buckets;
    @Metric
    private MutableCounterLong numKeys;
    @Metric
    private MutableCounterLong numBucketS3Creates;
    @Metric
    private MutableCounterLong numBucketS3CreateFails;
    @Metric
    private MutableCounterLong numBucketS3Deletes;
    @Metric
    private MutableCounterLong numBucketS3DeleteFails;
    @Metric
    private MutableCounterLong numListMultipartUploadFails;
    @Metric
    private MutableCounterLong numListMultipartUploads;
    @Metric
    private MutableCounterLong numTrashRenames;
    @Metric
    private MutableCounterLong numTrashDeletes;
    @Metric
    private MutableCounterLong numTrashListStatus;
    @Metric
    private MutableCounterLong numTrashGetFileStatus;
    @Metric
    private MutableCounterLong numTrashGetTrashRoots;
    @Metric
    private MutableCounterLong numTrashExists;
    @Metric
    private MutableCounterLong numTrashWriteRequests;
    @Metric
    private MutableCounterLong numTrashFilesRenames;
    @Metric
    private MutableCounterLong numTrashFilesDeletes;
    @Metric
    private MutableCounterLong numTrashActiveCycles;
    @Metric
    private MutableCounterLong numTrashCheckpointsProcessed;
    @Metric
    private MutableCounterLong numTrashFails;
    @Metric
    private MutableCounterLong numTrashRootsEnqueued;
    @Metric
    private MutableCounterLong numTrashRootsProcessed;
    @Metric
    private MutableCounterLong numTrashAtomicDirRenames;
    @Metric
    private MutableCounterLong numTrashAtomicDirDeletes;
    @Metric
    private MutableCounterLong numDirs;
    @Metric
    private MutableCounterLong numFiles;
    @Metric
    private MutableCounterLong ecKeyCreateTotal;
    @Metric
    private MutableCounterLong ecKeyCreateFailsTotal;
    @Metric
    private MutableCounterLong ecBucketCreateTotal;
    @Metric
    private MutableCounterLong ecBucketCreateFailsTotal;
    private final DBCheckpointMetrics dbCheckpointMetrics = DBCheckpointMetrics.create((String)"OM Metrics");

    public static OMMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (OMMetrics)ms.register(SOURCE_NAME, "Ozone Manager Metrics", (Object)new OMMetrics());
    }

    public DBCheckpointMetrics getDBCheckpointMetrics() {
        return this.dbCheckpointMetrics;
    }

    public void incNumS3BucketCreates() {
        this.numBucketOps.incr();
        this.numBucketS3Creates.incr();
    }

    public void incNumS3BucketCreateFails() {
        this.numBucketS3CreateFails.incr();
    }

    public void incNumS3BucketDeletes() {
        this.numBucketOps.incr();
        this.numBucketS3Deletes.incr();
    }

    public void incNumS3BucketDeleteFails() {
        this.numBucketOps.incr();
        this.numBucketS3DeleteFails.incr();
    }

    public void incDataCommittedBytes(long bytesWritten) {
        this.totalDataCommitted.incr(bytesWritten);
    }

    public void incNumS3Buckets() {
        this.numS3Buckets.incr();
    }

    public void decNumS3Buckets() {
        this.numS3Buckets.incr();
    }

    public void incNumVolumes() {
        this.numVolumes.incr();
    }

    public void decNumVolumes() {
        this.numVolumes.incr(-1L);
    }

    public void incNumBuckets() {
        this.numBuckets.incr();
    }

    public void decNumBuckets() {
        this.numBuckets.incr(-1L);
    }

    public void incNumKeys() {
        this.numKeys.incr();
    }

    public void incNumKeys(int count) {
        this.numKeys.incr((long)count);
    }

    public void decNumKeys() {
        this.numKeys.incr(-1L);
    }

    public void setNumVolumes(long val) {
        long oldVal = this.numVolumes.value();
        this.numVolumes.incr(val - oldVal);
    }

    public void setNumBuckets(long val) {
        long oldVal = this.numBuckets.value();
        this.numBuckets.incr(val - oldVal);
    }

    public void setNumKeys(long val) {
        long oldVal = this.numKeys.value();
        this.numKeys.incr(val - oldVal);
    }

    public void setNumDirs(long val) {
        long oldVal = this.numDirs.value();
        this.numDirs.incr(val - oldVal);
    }

    public void setNumFiles(long val) {
        long oldVal = this.numDirs.value();
        this.numDirs.incr(val - oldVal);
    }

    public void decNumKeys(long val) {
        this.numKeys.incr(-val);
    }

    public long getNumVolumes() {
        return this.numVolumes.value();
    }

    public long getNumBuckets() {
        return this.numBuckets.value();
    }

    public long getNumKeys() {
        return this.numKeys.value();
    }

    public void incNumVolumeCreates() {
        this.numVolumeOps.incr();
        this.numVolumeCreates.incr();
    }

    public void incNumVolumeUpdates() {
        this.numVolumeOps.incr();
        this.numVolumeUpdates.incr();
    }

    public void incNumVolumeInfos() {
        this.numVolumeOps.incr();
        this.numVolumeInfos.incr();
    }

    public void incNumVolumeDeletes() {
        this.numVolumeOps.incr();
        this.numVolumeDeletes.incr();
    }

    public void incNumVolumeCheckAccesses() {
        this.numVolumeOps.incr();
        this.numVolumeCheckAccesses.incr();
    }

    public void incNumBucketCreates() {
        this.numBucketOps.incr();
        this.numBucketCreates.incr();
    }

    public void incNumFSOBucketCreates() {
        this.numFSOBucketCreates.incr();
    }

    public void incNumBucketInfos() {
        this.numBucketOps.incr();
        this.numBucketInfos.incr();
    }

    public void incNumBucketUpdates() {
        this.numBucketOps.incr();
        this.numBucketUpdates.incr();
    }

    public void incNumBucketDeletes() {
        this.numBucketOps.incr();
        this.numBucketDeletes.incr();
    }

    public void incNumFSOBucketDeletes() {
        this.numFSOBucketDeletes.incr();
    }

    public void incNumBucketLists() {
        this.numBucketOps.incr();
        this.numBucketLists.incr();
    }

    @Override
    public void incNumKeyLists() {
        this.numKeyOps.incr();
        this.numKeyLists.incr();
    }

    public void incNumVolumeLists() {
        this.numVolumeOps.incr();
        this.numVolumeLists.incr();
    }

    public void incNumListS3Buckets() {
        this.numBucketOps.incr();
        this.numBucketS3Lists.incr();
    }

    public void incNumListS3BucketsFails() {
        this.numBucketS3ListFails.incr();
    }

    public void incNumListOpenFiles() {
        this.numKeyOps.incr();
        this.numListOpenFiles.incr();
    }

    public void incNumListOpenFilesFails() {
        this.numListOpenFilesFails.incr();
    }

    public void incNumInitiateMultipartUploads() {
        this.numKeyOps.incr();
        this.numInitiateMultipartUploads.incr();
    }

    public void incNumInitiateMultipartUploadFails() {
        this.numInitiateMultipartUploadFails.incr();
    }

    public void incNumCommitMultipartUploadParts() {
        this.numKeyOps.incr();
        this.numCommitMultipartUploadParts.incr();
    }

    public void incNumCommitMultipartUploadPartFails() {
        this.numCommitMultipartUploadPartFails.incr();
    }

    public void incNumCompleteMultipartUploads() {
        this.numKeyOps.incr();
        this.numCompleteMultipartUploads.incr();
    }

    public void incNumSnapshotCreates() {
        this.numSnapshotCreates.incr();
    }

    public void incNumSnapshotCreateFails() {
        this.numSnapshotCreateFails.incr();
    }

    public void incNumSnapshotRenames() {
        this.numSnapshotRenames.incr();
    }

    public void incNumSnapshotRenameFails() {
        this.numSnapshotRenameFails.incr();
    }

    public void incNumSnapshotDeletes() {
        this.numSnapshotDeletes.incr();
    }

    public void incNumSnapshotDeleteFails() {
        this.numSnapshotDeleteFails.incr();
    }

    public void incNumSnapshotLists() {
        this.numSnapshotLists.incr();
    }

    public void incNumSnapshotInfos() {
        this.numSnapshotInfos.incr();
    }

    public void incNumSnapshotDiffJobs() {
        this.numSnapshotDiffJobs.incr();
    }

    public void incNumCancelSnapshotDiffs() {
        this.numCancelSnapshotDiffs.incr();
    }

    public void incNumCancelSnapshotDiffJobFails() {
        this.numCancelSnapshotDiffFails.incr();
    }

    public void incNumListSnapshotDiffJobs() {
        this.numListSnapshotDiffJobs.incr();
    }

    public void incNumListSnapshotDiffJobFails() {
        this.numListSnapshotDiffJobFails.incr();
    }

    public void incNumSnapshotListFails() {
        this.numSnapshotListFails.incr();
    }

    public void incNumSnapshotDiffJobFails() {
        this.numSnapshotDiffJobFails.incr();
    }

    public void incNumSnapshotInfoFails() {
        this.numSnapshotInfoFails.incr();
    }

    public void setNumSnapshotActive(long num) {
        long currVal = this.numSnapshotActive.value();
        this.numSnapshotActive.incr(num - currVal);
    }

    public void incNumSnapshotActive() {
        this.numSnapshotActive.incr();
    }

    public void decNumSnapshotActive() {
        this.numSnapshotActive.incr(-1L);
    }

    public void setNumSnapshotDeleted(long num) {
        long currVal = this.numSnapshotDeleted.value();
        this.numSnapshotDeleted.incr(num - currVal);
    }

    public void incNumSnapshotDeleted() {
        this.numSnapshotDeleted.incr();
    }

    public void decNumSnapshotDeleted() {
        this.numSnapshotDeleted.incr(-1L);
    }

    public int getNumSnapshotCacheSize() {
        return this.numSnapshotCacheSize.value();
    }

    public void incNumSnapshotCacheSize() {
        this.numSnapshotCacheSize.incr();
    }

    public void decNumSnapshotCacheSize() {
        this.numSnapshotCacheSize.decr();
    }

    public void incNumCompleteMultipartUploadFails() {
        this.numCompleteMultipartUploadFails.incr();
    }

    public void incNumAbortMultipartUploads() {
        this.numKeyOps.incr();
        this.numAbortMultipartUploads.incr();
    }

    public void incNumListMultipartUploadFails() {
        this.numListMultipartUploadFails.incr();
    }

    public void incNumListMultipartUploads() {
        this.numKeyOps.incr();
        this.numListMultipartUploads.incr();
    }

    public void incNumAbortMultipartUploadFails() {
        this.numAbortMultipartUploadFails.incr();
    }

    public void incNumListMultipartUploadParts() {
        this.numKeyOps.incr();
        this.numListMultipartUploadParts.incr();
    }

    public void incNumTenants() {
        this.numTenants.incr();
    }

    public void decNumTenants() {
        this.numTenants.incr(-1L);
    }

    public void incNumTenantCreates() {
        this.numTenantOps.incr();
        this.numTenantCreates.incr();
    }

    public void incNumTenantCreateFails() {
        this.numTenantCreateFails.incr();
    }

    public void incNumTenantDeletes() {
        this.numTenantOps.incr();
        this.numTenantDeletes.incr();
    }

    public void incNumTenantDeleteFails() {
        this.numTenantDeleteFails.incr();
    }

    public void incNumTenantAssignUsers() {
        this.numTenantOps.incr();
        this.numTenantAssignUsers.incr();
    }

    public void incNumTenantAssignUserFails() {
        this.numTenantAssignUserFails.incr();
    }

    public void incNumTenantRevokeUsers() {
        this.numTenantOps.incr();
        this.numTenantRevokeUsers.incr();
    }

    public void incNumTenantRevokeUserFails() {
        this.numTenantRevokeUserFails.incr();
    }

    public void incNumTenantAssignAdmins() {
        this.numTenantOps.incr();
        this.numTenantAssignAdmins.incr();
    }

    public void incNumTenantAssignAdminFails() {
        this.numTenantAssignAdminFails.incr();
    }

    public void incNumTenantRevokeAdmins() {
        this.numTenantOps.incr();
        this.numTenantRevokeAdmins.incr();
    }

    public void incNumTenantRevokeAdminFails() {
        this.numTenantRevokeAdminFails.incr();
    }

    public void incNumTenantLists() {
        this.numTenantOps.incr();
        this.numTenantLists.incr();
    }

    public void incNumTenantGetUserInfos() {
        this.numTenantOps.incr();
        this.numTenantGetUserInfos.incr();
    }

    public void incNumTenantUserLists() {
        this.numTenantOps.incr();
        this.numTenantTenantUserLists.incr();
    }

    @Override
    public void incNumGetFileStatus() {
        this.numKeyOps.incr();
        this.numFSOps.incr();
        this.numGetFileStatus.incr();
    }

    @Override
    public void incNumGetFileStatusFails() {
        this.numGetFileStatusFails.incr();
    }

    public void incNumCreateDirectory() {
        this.numKeyOps.incr();
        this.numFSOps.incr();
        this.numCreateDirectory.incr();
    }

    public void incNumCreateDirectoryFails() {
        this.numCreateDirectoryFails.incr();
    }

    public void incNumCreateFile() {
        this.numKeyOps.incr();
        this.numFSOps.incr();
        this.numCreateFile.incr();
    }

    public void incNumCreateFileFails() {
        this.numCreateFileFails.incr();
    }

    @Override
    public void incNumLookupFile() {
        this.numKeyOps.incr();
        this.numFSOps.incr();
        this.numLookupFile.incr();
    }

    @Override
    public void incNumLookupFileFails() {
        this.numLookupFileFails.incr();
    }

    @Override
    public void incNumListStatus() {
        this.numKeyOps.incr();
        this.numFSOps.incr();
        this.numListStatus.incr();
    }

    @Override
    public void incNumListStatusFails() {
        this.numListStatusFails.incr();
    }

    public void incNumListMultipartUploadPartFails() {
        this.numListMultipartUploadPartFails.incr();
    }

    public void incNumGetServiceLists() {
        this.numGetServiceLists.incr();
    }

    public void incNumVolumeCreateFails() {
        this.numVolumeCreateFails.incr();
    }

    public void incNumVolumeUpdateFails() {
        this.numVolumeUpdateFails.incr();
    }

    public void incNumVolumeInfoFails() {
        this.numVolumeInfoFails.incr();
    }

    public void incNumVolumeDeleteFails() {
        this.numVolumeDeleteFails.incr();
    }

    public void incNumVolumeCheckAccessFails() {
        this.numVolumeCheckAccessFails.incr();
    }

    public void incNumBucketCreateFails() {
        this.numBucketCreateFails.incr();
    }

    public void incNumBucketInfoFails() {
        this.numBucketInfoFails.incr();
    }

    public void incNumBucketUpdateFails() {
        this.numBucketUpdateFails.incr();
    }

    public void incNumBucketDeleteFails() {
        this.numBucketDeleteFails.incr();
    }

    public void incNumKeyAllocates() {
        this.numKeyOps.incr();
        this.numKeyAllocate.incr();
    }

    public void incNumKeyAllocateFails() {
        this.numKeyAllocateFails.incr();
    }

    @Override
    public void incNumKeyLookups() {
        this.numKeyOps.incr();
        this.numKeyLookup.incr();
    }

    @Override
    public void incNumKeyLookupFails() {
        this.numKeyLookupFails.incr();
    }

    public void incNumKeyRenames() {
        this.numKeyOps.incr();
        this.numKeyRenames.incr();
    }

    public void incNumKeyRenameFails() {
        this.numKeyRenameFails.incr();
    }

    public void incNumKeyDeleteFails() {
        this.numKeyDeleteFails.incr();
    }

    public void incNumKeyDeletes() {
        this.numKeyOps.incr();
        this.numKeyDeletes.incr();
    }

    public void incNumKeyCommits() {
        this.numKeyOps.incr();
        this.numKeyCommits.incr();
    }

    public void incNumKeyHSyncs() {
        this.numKeyOps.incr();
        this.numKeyHSyncs.incr();
    }

    public void incNumKeyCommitFails() {
        this.numKeyCommitFails.incr();
    }

    public void incNumBlockAllocateCalls() {
        this.numBlockAllocations.incr();
    }

    public void incNumBlockAllocateCallFails() {
        this.numBlockAllocationFails.incr();
    }

    public void incNumBucketListFails() {
        this.numBucketListFails.incr();
    }

    @Override
    public void incNumKeyListFails() {
        this.numKeyListFails.incr();
    }

    public void incNumVolumeListFails() {
        this.numVolumeListFails.incr();
    }

    public void incNumGetServiceListFails() {
        this.numGetServiceListFails.incr();
    }

    public void incNumOpenKeyDeleteRequests() {
        this.numOpenKeyDeleteRequests.incr();
    }

    public void incNumOpenKeysSubmittedForDeletion(long amount) {
        this.numOpenKeysSubmittedForDeletion.incr(amount);
    }

    public void incNumOpenKeysDeleted() {
        this.numOpenKeysDeleted.incr();
    }

    public void incNumOpenKeysCleaned(int delta) {
        this.numOpenKeysCleaned.incr((long)delta);
    }

    public void incNumOpenKeysHSyncCleaned() {
        this.numOpenKeysHSyncCleaned.incr();
    }

    public void incNumOpenKeyDeleteRequestFails() {
        this.numOpenKeyDeleteRequestFails.incr();
    }

    public void incNumExpiredMPUAbortRequests() {
        this.numExpiredMPUAbortRequests.incr();
    }

    public void incNumExpiredMPUSubmittedForAbort(long amount) {
        this.numExpiredMPUSubmittedForAbort.incr(amount);
    }

    public void incNumExpiredMPUAborted() {
        this.numExpiredMPUAborted.incr();
    }

    public void incNumExpiredMPUPartsAborted(long amount) {
        this.numExpiredMPUPartsAborted.incr(amount);
    }

    public void incNumExpiredMpuAbortRequestFails() {
        this.numExpiredMPUAbortRequestFails.incr();
    }

    public void incNumAddAcl() {
        this.numAddAcl.incr();
    }

    public void incNumSetAcl() {
        this.numSetAcl.incr();
    }

    @Override
    public void incNumGetAcl() {
        this.numGetAcl.incr();
    }

    public void incNumRemoveAcl() {
        this.numRemoveAcl.incr();
    }

    public void incNumSetTime() {
        this.numSetTime.incr();
    }

    @Override
    public void incNumGetKeyInfo() {
        this.numGetKeyInfo.incr();
        this.numKeyOps.incr();
    }

    @Override
    public void incNumGetKeyInfoFails() {
        this.getNumGetKeyInfoFails.incr();
    }

    @Override
    public void incNumGetObjectTagging() {
        this.numGetObjectTagging.incr();
        this.numKeyOps.incr();
    }

    @Override
    public void incNumGetObjectTaggingFails() {
        this.numGetObjectTaggingFails.incr();
    }

    public void incNumPutObjectTagging() {
        this.numPutObjectTagging.incr();
        this.numKeyOps.incr();
    }

    public void incNumPutObjectTaggingFails() {
        this.numPutObjectTaggingFails.incr();
    }

    public void incNumDeleteObjectTagging() {
        this.numDeleteObjectTagging.incr();
        this.numKeyOps.incr();
    }

    public void incNumDeleteObjectTaggingFails() {
        this.numDeleteObjectTaggingFails.incr();
    }

    @VisibleForTesting
    public long getNumVolumeCreates() {
        return this.numVolumeCreates.value();
    }

    @VisibleForTesting
    public long getNumVolumeUpdates() {
        return this.numVolumeUpdates.value();
    }

    @VisibleForTesting
    public long getNumVolumeInfos() {
        return this.numVolumeInfos.value();
    }

    @VisibleForTesting
    public long getNumVolumeDeletes() {
        return this.numVolumeDeletes.value();
    }

    @VisibleForTesting
    public long getNumVolumeCheckAccesses() {
        return this.numVolumeCheckAccesses.value();
    }

    @VisibleForTesting
    public long getNumBucketCreates() {
        return this.numBucketCreates.value();
    }

    @VisibleForTesting
    public long getNumFSOBucketCreates() {
        return this.numFSOBucketCreates.value();
    }

    @VisibleForTesting
    public long getNumBucketInfos() {
        return this.numBucketInfos.value();
    }

    @VisibleForTesting
    public long getNumBucketUpdates() {
        return this.numBucketUpdates.value();
    }

    @VisibleForTesting
    public long getNumBucketDeletes() {
        return this.numBucketDeletes.value();
    }

    @VisibleForTesting
    public long getNumFSOBucketDeletes() {
        return this.numFSOBucketDeletes.value();
    }

    @VisibleForTesting
    public long getNumBucketLists() {
        return this.numBucketLists.value();
    }

    @VisibleForTesting
    public long getNumVolumeLists() {
        return this.numVolumeLists.value();
    }

    @VisibleForTesting
    public long getNumKeyLists() {
        return this.numKeyLists.value();
    }

    @VisibleForTesting
    public long getNumGetServiceLists() {
        return this.numGetServiceLists.value();
    }

    @VisibleForTesting
    public long getNumVolumeCreateFails() {
        return this.numVolumeCreateFails.value();
    }

    @VisibleForTesting
    public long getNumVolumeUpdateFails() {
        return this.numVolumeUpdateFails.value();
    }

    @VisibleForTesting
    public long getNumVolumeInfoFails() {
        return this.numVolumeInfoFails.value();
    }

    @VisibleForTesting
    public long getNumVolumeDeleteFails() {
        return this.numVolumeDeleteFails.value();
    }

    @VisibleForTesting
    public long getNumVolumeCheckAccessFails() {
        return this.numVolumeCheckAccessFails.value();
    }

    @VisibleForTesting
    public long getNumBucketCreateFails() {
        return this.numBucketCreateFails.value();
    }

    @VisibleForTesting
    public long getNumBucketInfoFails() {
        return this.numBucketInfoFails.value();
    }

    @VisibleForTesting
    public long getNumBucketUpdateFails() {
        return this.numBucketUpdateFails.value();
    }

    @VisibleForTesting
    public long getNumBucketDeleteFails() {
        return this.numBucketDeleteFails.value();
    }

    @VisibleForTesting
    public long getNumKeyAllocates() {
        return this.numKeyAllocate.value();
    }

    @VisibleForTesting
    public long getNumKeyAllocateFails() {
        return this.numKeyAllocateFails.value();
    }

    @VisibleForTesting
    public long getNumKeyLookups() {
        return this.numKeyLookup.value();
    }

    @VisibleForTesting
    public long getNumKeyLookupFails() {
        return this.numKeyLookupFails.value();
    }

    @VisibleForTesting
    public long getNumKeyRenames() {
        return this.numKeyRenames.value();
    }

    @VisibleForTesting
    public long getNumKeyRenameFails() {
        return this.numKeyRenameFails.value();
    }

    @VisibleForTesting
    public long getNumKeyDeletes() {
        return this.numKeyDeletes.value();
    }

    @VisibleForTesting
    public long getNumKeyDeletesFails() {
        return this.numKeyDeleteFails.value();
    }

    @VisibleForTesting
    public long getNumBucketListFails() {
        return this.numBucketListFails.value();
    }

    @VisibleForTesting
    public long getNumKeyListFails() {
        return this.numKeyListFails.value();
    }

    @VisibleForTesting
    public long getNumFSOps() {
        return this.numFSOps.value();
    }

    @VisibleForTesting
    public long getNumGetFileStatus() {
        return this.numGetFileStatus.value();
    }

    @VisibleForTesting
    public long getNumListStatus() {
        return this.numListStatus.value();
    }

    @VisibleForTesting
    public long getNumVolumeListFails() {
        return this.numVolumeListFails.value();
    }

    @VisibleForTesting
    public long getNumKeyCommits() {
        return this.numKeyCommits.value();
    }

    @VisibleForTesting
    public long getNumKeyHSyncs() {
        return this.numKeyHSyncs.value();
    }

    @VisibleForTesting
    public void resetNumKeyHSyncs() {
        this.numKeyHSyncs.incr(-this.numKeyHSyncs.value());
    }

    @VisibleForTesting
    public long getNumKeyCommitFails() {
        return this.numKeyCommitFails.value();
    }

    @VisibleForTesting
    public long getNumBlockAllocates() {
        return this.numBlockAllocations.value();
    }

    @VisibleForTesting
    public long getNumBlockAllocateFails() {
        return this.numBlockAllocationFails.value();
    }

    @VisibleForTesting
    public long getNumGetServiceListFails() {
        return this.numGetServiceListFails.value();
    }

    @VisibleForTesting
    public long getNumListS3Buckets() {
        return this.numBucketS3Lists.value();
    }

    @VisibleForTesting
    public long getNumListS3BucketsFails() {
        return this.numBucketS3ListFails.value();
    }

    @VisibleForTesting
    public long getDataCommittedBytes() {
        return this.totalDataCommitted.value();
    }

    public long getNumInitiateMultipartUploads() {
        return this.numInitiateMultipartUploads.value();
    }

    public long getNumInitiateMultipartUploadFails() {
        return this.numInitiateMultipartUploadFails.value();
    }

    public long getNumAbortMultipartUploads() {
        return this.numAbortMultipartUploads.value();
    }

    public long getNumAbortMultipartUploadFails() {
        return this.numAbortMultipartUploadFails.value();
    }

    public long getNumOpenKeyDeleteRequests() {
        return this.numOpenKeyDeleteRequests.value();
    }

    public long getNumOpenKeysSubmittedForDeletion() {
        return this.numOpenKeysSubmittedForDeletion.value();
    }

    public long getNumOpenKeysDeleted() {
        return this.numOpenKeysDeleted.value();
    }

    public long getNumOpenKeysCleaned() {
        return this.numOpenKeysCleaned.value();
    }

    public long getNumOpenKeysHSyncCleaned() {
        return this.numOpenKeysHSyncCleaned.value();
    }

    public long getNumOpenKeyDeleteRequestFails() {
        return this.numOpenKeyDeleteRequestFails.value();
    }

    @VisibleForTesting
    public long getNumExpiredMPUAbortRequests() {
        return this.numExpiredMPUAbortRequests.value();
    }

    @VisibleForTesting
    public long getNumExpiredMPUSubmittedForAbort() {
        return this.numExpiredMPUSubmittedForAbort.value();
    }

    @VisibleForTesting
    public long getNumExpiredMPUAborted() {
        return this.numExpiredMPUAborted.value();
    }

    @VisibleForTesting
    public long getNumExpiredMPUAbortRequestFails() {
        return this.numExpiredMPUAbortRequestFails.value();
    }

    @VisibleForTesting
    public long getNumExpiredMPUPartsAborted() {
        return this.numExpiredMPUPartsAborted.value();
    }

    public long getNumAddAcl() {
        return this.numAddAcl.value();
    }

    public long getNumSetAcl() {
        return this.numSetAcl.value();
    }

    public long getNumGetAcl() {
        return this.numGetAcl.value();
    }

    public long getNumRemoveAcl() {
        return this.numRemoveAcl.value();
    }

    public long getNumTenantOps() {
        return this.numTenantOps.value();
    }

    public long getNumTenants() {
        return this.numTenants.value();
    }

    public long getNumTenantCreates() {
        return this.numTenantCreates.value();
    }

    public long getNumTenantCreateFails() {
        return this.numTenantCreateFails.value();
    }

    public long getNumTenantDeletes() {
        return this.numTenantDeletes.value();
    }

    public long getNumTenantDeleteFails() {
        return this.numTenantDeleteFails.value();
    }

    public long getNumTenantAssignUsers() {
        return this.numTenantAssignUsers.value();
    }

    public long getNumTenantAssignUserFails() {
        return this.numTenantAssignUserFails.value();
    }

    public long getNumTenantRevokeUsers() {
        return this.numTenantRevokeUsers.value();
    }

    public long getNumTenantRevokeUserFails() {
        return this.numTenantRevokeUserFails.value();
    }

    public long getNumTenantAssignAdmins() {
        return this.numTenantAssignAdmins.value();
    }

    public long getNumTenantAssignAdminFails() {
        return this.numTenantAssignAdminFails.value();
    }

    public long getNumTenantRevokeAdmins() {
        return this.numTenantRevokeAdmins.value();
    }

    public long getNumTenantRevokeAdminFails() {
        return this.numTenantRevokeAdminFails.value();
    }

    public long getNumTenantLists() {
        return this.numTenantLists.value();
    }

    public long getNumTenantGetUserInfos() {
        return this.numTenantGetUserInfos.value();
    }

    public long getNumTenantTenantUserLists() {
        return this.numTenantTenantUserLists.value();
    }

    public long getNumSnapshotCreates() {
        return this.numSnapshotCreates.value();
    }

    public long getNumSnapshotDeletes() {
        return this.numSnapshotDeletes.value();
    }

    public long getNumSnapshotLists() {
        return this.numSnapshotLists.value();
    }

    public long getNumSnapshotDiffJobs() {
        return this.numSnapshotDiffJobs.value();
    }

    public long getNumSnapshotCreateFails() {
        return this.numSnapshotCreateFails.value();
    }

    public long getNumSnapshotDeleteFails() {
        return this.numSnapshotDeleteFails.value();
    }

    public long getNumSnapshotListFails() {
        return this.numSnapshotListFails.value();
    }

    public long getNumSnapshotDiffJobFails() {
        return this.numSnapshotDiffJobFails.value();
    }

    public long getNumSnapshotActive() {
        return this.numSnapshotActive.value();
    }

    public long getNumSnapshotDeleted() {
        return this.numSnapshotDeleted.value();
    }

    public void incNumTrashRenames() {
        this.numTrashRenames.incr();
    }

    public long getNumTrashRenames() {
        return this.numTrashRenames.value();
    }

    public void incNumTrashDeletes() {
        this.numTrashDeletes.incr();
    }

    public long getNumTrashDeletes() {
        return this.numTrashDeletes.value();
    }

    public void incNumTrashListStatus() {
        this.numTrashListStatus.incr();
    }

    public void incNumTrashGetFileStatus() {
        this.numTrashGetFileStatus.incr();
    }

    public void incNumTrashGetTrashRoots() {
        this.numTrashGetTrashRoots.incr();
    }

    public void incNumTrashExists() {
        this.numTrashExists.incr();
    }

    public void incNumTrashWriteRequests() {
        this.numTrashWriteRequests.incr();
    }

    public void incNumTrashFilesRenames() {
        this.numTrashFilesRenames.incr();
    }

    public long getNumTrashFilesRenames() {
        return this.numTrashFilesRenames.value();
    }

    public void incNumTrashFilesDeletes() {
        this.numTrashFilesDeletes.incr();
    }

    public long getNumTrashFilesDeletes() {
        return this.numTrashFilesDeletes.value();
    }

    public long getNumTrashAtomicDirRenames() {
        return this.numTrashAtomicDirRenames.value();
    }

    public long getNumTrashAtomicDirDeletes() {
        return this.numTrashAtomicDirDeletes.value();
    }

    public void incNumTrashActiveCycles() {
        this.numTrashActiveCycles.incr();
    }

    public void incNumTrashRootsEnqueued() {
        this.numTrashRootsEnqueued.incr();
    }

    public void incNumTrashRootsProcessed() {
        this.numTrashRootsProcessed.incr();
    }

    public void incNumTrashFails() {
        this.numTrashFails.incr();
    }

    public void incNumTrashAtomicDirRenames() {
        this.numTrashAtomicDirRenames.incr();
    }

    public void incNumTrashAtomicDirDeletes() {
        this.numTrashAtomicDirDeletes.incr();
    }

    public void incEcKeysTotal() {
        this.ecKeyCreateTotal.incr();
    }

    public void incEcBucketsTotal() {
        this.ecBucketCreateTotal.incr();
    }

    public void incEcKeyCreateFailsTotal() {
        this.ecKeyCreateFailsTotal.incr();
    }

    public void incEcBucketCreateFailsTotal() {
        this.ecBucketCreateFailsTotal.incr();
    }

    public void incNumRecoverLease() {
        this.numKeyOps.incr();
        this.numFSOps.incr();
        this.numRecoverLease.incr();
    }

    public void incNumRecoverLeaseFails() {
        this.numRecoverLeaseFails.incr();
    }

    public void unRegister() {
        if (this.dbCheckpointMetrics != null) {
            this.dbCheckpointMetrics.unRegister();
        }
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }
}

