/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import com.google.common.base.Supplier;
import com.google.common.util.concurrent.Striped;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class SimpleStriped {
    private SimpleStriped() {
    }

    public static <L> Striped<L> custom(int stripes, Supplier<L> supplier) {
        try {
            Method custom = Striped.class.getDeclaredMethod("custom", Integer.TYPE, Supplier.class);
            custom.setAccessible(true);
            return (Striped)custom.invoke(null, stripes, supplier);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error creating custom Striped.", e);
        }
    }

    public static Striped<ReadWriteLock> readWriteLock(int stripes, boolean fair) {
        return SimpleStriped.custom(stripes, () -> new ReentrantReadWriteLock(fair));
    }
}

