/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.ssl;

import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ReloadingX509KeyManager
extends X509ExtendedKeyManager
implements CertificateNotification {
    private static final Logger LOG = LoggerFactory.getLogger(ReloadingX509KeyManager.class);
    private final String type;
    static final char[] EMPTY_PASSWORD = new char[0];
    private final AtomicReference<X509ExtendedKeyManager> keyManagerRef;
    private PrivateKey currentPrivateKey;
    private List<X509Certificate> currentTrustChain;
    private final String alias;

    public ReloadingX509KeyManager(String type, String componentName, PrivateKey privateKey, List<X509Certificate> trustChain) throws GeneralSecurityException, IOException {
        this.type = type;
        this.alias = componentName + "_key";
        this.keyManagerRef = new AtomicReference();
        this.keyManagerRef.set(this.init(privateKey, trustChain));
    }

    @Override
    public String chooseEngineClientAlias(String[] strings, Principal[] principals, SSLEngine sslEngine) {
        String ret = this.keyManagerRef.get().chooseEngineClientAlias(strings, principals, sslEngine);
        if (ret == null) {
            ret = this.alias;
            LOG.info("Engine client aliases for {}, {}, {} is returned as {}", new Object[]{strings == null ? "" : Arrays.toString(strings), principals == null ? "" : Arrays.toString(principals), sslEngine == null ? "" : sslEngine, ret});
        }
        return ret;
    }

    @Override
    public String chooseEngineServerAlias(String s, Principal[] principals, SSLEngine sslEngine) {
        String ret = this.keyManagerRef.get().chooseEngineServerAlias(s, principals, sslEngine);
        if (ret == null && LOG.isDebugEnabled()) {
            LOG.debug("Engine server aliases for {}, {}, {} is null", new Object[]{s, principals == null ? "" : Arrays.toString(principals), sslEngine == null ? "" : sslEngine});
        }
        return ret;
    }

    @Override
    public String[] getClientAliases(String s, Principal[] principals) {
        return this.keyManagerRef.get().getClientAliases(s, principals);
    }

    @Override
    public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
        return this.keyManagerRef.get().chooseClientAlias(strings, principals, socket);
    }

    @Override
    public String[] getServerAliases(String s, Principal[] principals) {
        return this.keyManagerRef.get().getServerAliases(s, principals);
    }

    @Override
    public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
        return this.keyManagerRef.get().chooseServerAlias(s, principals, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String s) {
        return this.keyManagerRef.get().getCertificateChain(s.toLowerCase(Locale.ROOT));
    }

    @Override
    public PrivateKey getPrivateKey(String s) {
        return this.keyManagerRef.get().getPrivateKey(s.toLowerCase(Locale.ROOT));
    }

    private X509ExtendedKeyManager init(PrivateKey newPrivateKey, List<X509Certificate> newTrustChain) throws GeneralSecurityException, IOException {
        if (this.isAlreadyUsing(newPrivateKey, newTrustChain)) {
            return null;
        }
        X509ExtendedKeyManager keyManager = null;
        KeyStore keystore = KeyStore.getInstance(this.type);
        keystore.load(null, null);
        keystore.setKeyEntry(this.alias, newPrivateKey, EMPTY_PASSWORD, newTrustChain.toArray(new X509Certificate[0]));
        LOG.info("Key manager is loaded with certificate chain");
        for (X509Certificate x509Certificate : newTrustChain) {
            LOG.info(x509Certificate.toString());
        }
        KeyManagerFactory keyMgrFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyMgrFactory.init(keystore, EMPTY_PASSWORD);
        for (KeyManager candidate : keyMgrFactory.getKeyManagers()) {
            if (!(candidate instanceof X509ExtendedKeyManager)) continue;
            keyManager = (X509ExtendedKeyManager)candidate;
            break;
        }
        this.currentPrivateKey = newPrivateKey;
        this.currentTrustChain = newTrustChain;
        return keyManager;
    }

    private boolean isAlreadyUsing(PrivateKey privateKey, List<X509Certificate> newTrustChain) {
        return this.currentPrivateKey != null && this.currentPrivateKey.equals(privateKey) && !this.currentTrustChain.isEmpty() && newTrustChain.size() == this.currentTrustChain.size() && newTrustChain.stream().allMatch(newCertificate -> this.currentTrustChain.stream().anyMatch(oldCert -> oldCert.getSerialNumber().equals(newCertificate.getSerialNumber())));
    }

    @Override
    public synchronized void notifyCertificateRenewed(CertificateClient certClient, String oldCertId, String newCertId) {
        LOG.info("{} notify certificate renewed", (Object)certClient.getComponentName());
        try {
            X509ExtendedKeyManager manager = this.init(certClient.getPrivateKey(), certClient.getTrustChain());
            if (manager != null) {
                this.keyManagerRef.set(manager);
                LOG.info("ReloadingX509KeyManager is reloaded");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

