/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Clock;
import java.time.Instant;
import java.util.Comparator;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.ratis.util.Preconditions;

public final class ContainerInfo
implements Comparable<ContainerInfo> {
    private static final Comparator<ContainerInfo> COMPARATOR = Comparator.comparingLong(info -> info.getLastUsed().toEpochMilli());
    private static final Codec<ContainerInfo> CODEC = new DelegatedCodec<ContainerInfo, HddsProtos.ContainerInfoProto>(Proto2Codec.get(HddsProtos.ContainerInfoProto.getDefaultInstance()), ContainerInfo::fromProtobuf, ContainerInfo::getProtobuf, ContainerInfo.class);
    private HddsProtos.LifeCycleState state;
    private Instant stateEnterTime;
    @JsonIgnore
    private HddsProtos.LifeCycleState previousState;
    @JsonIgnore
    private Instant previousStateEnterTime;
    @JsonIgnore
    private final PipelineID pipelineID;
    private final ReplicationConfig replicationConfig;
    @JsonIgnore
    private final Clock clock;
    private volatile long usedBytes;
    private long numberOfKeys;
    private Instant lastUsed;
    private String owner;
    @JsonIgnore
    private final ContainerID containerID;
    private long deleteTransactionId;
    private long sequenceId;

    private ContainerInfo(Builder b) {
        this.containerID = ContainerID.valueOf(b.containerID);
        this.pipelineID = b.pipelineID;
        this.usedBytes = b.used;
        this.numberOfKeys = b.keys;
        this.lastUsed = b.clock.instant();
        this.state = b.state;
        this.stateEnterTime = Instant.ofEpochMilli(b.stateEnterTime);
        this.owner = b.owner;
        this.deleteTransactionId = b.deleteTransactionId;
        this.sequenceId = b.sequenceId;
        this.replicationConfig = b.replicationConfig;
        this.clock = b.clock;
    }

    public static Codec<ContainerInfo> getCodec() {
        return CODEC;
    }

    public static ContainerInfo fromProtobuf(HddsProtos.ContainerInfoProto info) {
        Builder builder = new Builder();
        ReplicationConfig config = ReplicationConfig.fromProto(info.getReplicationType(), info.getReplicationFactor(), info.getEcReplicationConfig());
        builder.setUsedBytes(info.getUsedBytes()).setNumberOfKeys(info.getNumberOfKeys()).setState(info.getState()).setStateEnterTime(info.getStateEnterTime()).setOwner(info.getOwner()).setContainerID(info.getContainerID()).setDeleteTransactionId(info.getDeleteTransactionId()).setReplicationConfig(config).setSequenceId(info.getSequenceId()).build();
        if (info.hasPipelineID()) {
            builder.setPipelineID(PipelineID.getFromProtobuf(info.getPipelineID()));
        }
        return builder.build();
    }

    @JsonProperty
    public long getContainerID() {
        return this.containerID.getId();
    }

    public HddsProtos.LifeCycleState getState() {
        return this.state;
    }

    public void setState(HddsProtos.LifeCycleState state) {
        this.previousState = this.state;
        this.previousStateEnterTime = this.stateEnterTime;
        this.state = state;
        this.stateEnterTime = this.clock.instant();
    }

    public Instant getStateEnterTime() {
        return this.stateEnterTime;
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    @JsonIgnore
    public HddsProtos.ReplicationType getReplicationType() {
        return this.replicationConfig.getReplicationType();
    }

    @JsonIgnore
    public HddsProtos.ReplicationFactor getReplicationFactor() {
        return ReplicationConfig.getLegacyFactor(this.replicationConfig);
    }

    public PipelineID getPipelineID() {
        return this.pipelineID;
    }

    public long getUsedBytes() {
        return this.usedBytes;
    }

    public void setUsedBytes(long value) {
        this.usedBytes = value;
    }

    public long getNumberOfKeys() {
        return this.numberOfKeys;
    }

    public void setNumberOfKeys(long value) {
        this.numberOfKeys = value;
    }

    public long getDeleteTransactionId() {
        return this.deleteTransactionId;
    }

    public long getSequenceId() {
        return this.sequenceId;
    }

    public void updateDeleteTransactionId(long transactionId) {
        this.deleteTransactionId = Math.max(transactionId, this.deleteTransactionId);
    }

    public void updateSequenceId(long sequenceID) {
        assert (this.isOpen() || this.state == HddsProtos.LifeCycleState.QUASI_CLOSED);
        this.sequenceId = Math.max(sequenceID, this.sequenceId);
    }

    public ContainerID containerID() {
        return this.containerID;
    }

    public Instant getLastUsed() {
        return this.lastUsed;
    }

    public void updateLastUsedTime() {
        this.lastUsed = this.clock.instant();
    }

    @JsonIgnore
    public HddsProtos.ContainerInfoProto getProtobuf() {
        HddsProtos.ContainerInfoProto.Builder builder = HddsProtos.ContainerInfoProto.newBuilder();
        builder.setContainerID(this.getContainerID()).setUsedBytes(this.getUsedBytes()).setNumberOfKeys(this.getNumberOfKeys()).setState(this.getState()).setStateEnterTime(this.getStateEnterTime().toEpochMilli()).setContainerID(this.getContainerID()).setDeleteTransactionId(this.getDeleteTransactionId()).setOwner(this.getOwner()).setSequenceId(this.getSequenceId()).setReplicationType(this.getReplicationType());
        if (this.replicationConfig instanceof ECReplicationConfig) {
            builder.setEcReplicationConfig(((ECReplicationConfig)this.replicationConfig).toProto());
        } else {
            builder.setReplicationFactor(ReplicationConfig.getLegacyFactor(this.replicationConfig));
        }
        builder.setReplicationType(this.replicationConfig.getReplicationType());
        if (this.getPipelineID() != null) {
            builder.setPipelineID(this.getPipelineID().getProtobuf());
        }
        return builder.build();
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String toString() {
        return "ContainerInfo{id=" + this.containerID + ", state=" + this.state + ", stateEnterTime=" + this.stateEnterTime + ", pipelineID=" + this.pipelineID + ", owner=" + this.owner + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerInfo that = (ContainerInfo)o;
        return new EqualsBuilder().append(this.getContainerID(), that.getContainerID()).append((Object)this.owner, (Object)that.owner).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(11, 811).append(this.getContainerID()).append((Object)this.getOwner()).toHashCode();
    }

    @Override
    public int compareTo(ContainerInfo o) {
        return COMPARATOR.compare(this, o);
    }

    public void revertState() {
        if (this.previousState == null || this.previousStateEnterTime == null) {
            throw new IllegalStateException("previous state unknown");
        }
        this.state = this.previousState;
        this.stateEnterTime = this.previousStateEnterTime;
        this.previousState = null;
        this.previousStateEnterTime = null;
    }

    public boolean isOpen() {
        return this.state == HddsProtos.LifeCycleState.OPEN || this.state == HddsProtos.LifeCycleState.CLOSING;
    }

    public boolean isDeleted() {
        return this.state == HddsProtos.LifeCycleState.DELETED;
    }

    public static class Builder {
        private HddsProtos.LifeCycleState state;
        private long used;
        private long keys;
        private Clock clock = Clock.systemUTC();
        private long stateEnterTime = this.clock.millis();
        private String owner;
        private long containerID;
        private long deleteTransactionId;
        private long sequenceId;
        private PipelineID pipelineID;
        private ReplicationConfig replicationConfig;

        public Builder setPipelineID(PipelineID pipelineId) {
            this.pipelineID = pipelineId;
            return this;
        }

        public Builder setReplicationConfig(ReplicationConfig repConfig) {
            this.replicationConfig = repConfig;
            return this;
        }

        public Builder setContainerID(long id) {
            Preconditions.assertTrue((id >= 0L ? 1 : 0) != 0, () -> id + " < 0");
            this.containerID = id;
            return this;
        }

        public Builder setState(HddsProtos.LifeCycleState lifeCycleState) {
            this.state = lifeCycleState;
            return this;
        }

        public Builder setUsedBytes(long bytesUsed) {
            this.used = bytesUsed;
            return this;
        }

        public Builder setNumberOfKeys(long keyCount) {
            this.keys = keyCount;
            return this;
        }

        public Builder setStateEnterTime(long time) {
            this.stateEnterTime = time;
            return this;
        }

        public Builder setOwner(String containerOwner) {
            this.owner = containerOwner;
            return this;
        }

        public Builder setDeleteTransactionId(long deleteTransactionID) {
            this.deleteTransactionId = deleteTransactionID;
            return this;
        }

        public Builder setSequenceId(long sequenceID) {
            this.sequenceId = sequenceID;
            return this;
        }

        public Builder setClock(Clock clock) {
            this.clock = clock;
            this.stateEnterTime = clock.millis();
            return this;
        }

        public ContainerInfo build() {
            return new ContainerInfo(this);
        }
    }
}

