/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import org.apache.hadoop.hdds.client.ContainerBlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public class BlockID {
    private final ContainerBlockID containerBlockID;
    private long blockCommitSequenceId;
    private final Integer replicaIndex;

    public BlockID(long containerID, long localID) {
        this(containerID, localID, 0L, null);
    }

    private BlockID(long containerID, long localID, long bcsID, Integer repIndex) {
        this.containerBlockID = new ContainerBlockID(containerID, localID);
        this.blockCommitSequenceId = bcsID;
        this.replicaIndex = repIndex;
    }

    public BlockID(BlockID blockID) {
        this(blockID.getContainerID(), blockID.getLocalID(), blockID.getBlockCommitSequenceId(), blockID.getReplicaIndex());
    }

    public BlockID(ContainerBlockID containerBlockID) {
        this(containerBlockID, 0L, null);
    }

    private BlockID(ContainerBlockID containerBlockID, long bcsId, Integer repIndex) {
        this.containerBlockID = containerBlockID;
        this.blockCommitSequenceId = bcsId;
        this.replicaIndex = repIndex;
    }

    public long getContainerID() {
        return this.containerBlockID.getContainerID();
    }

    public long getLocalID() {
        return this.containerBlockID.getLocalID();
    }

    public long getBlockCommitSequenceId() {
        return this.blockCommitSequenceId;
    }

    public void setBlockCommitSequenceId(long blockCommitSequenceId) {
        this.blockCommitSequenceId = blockCommitSequenceId;
    }

    public Integer getReplicaIndex() {
        return this.replicaIndex;
    }

    public ContainerBlockID getContainerBlockID() {
        return this.containerBlockID;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        this.appendTo(sb);
        return sb.toString();
    }

    public void appendTo(StringBuilder sb) {
        this.containerBlockID.appendTo(sb);
        sb.append(" bcsId: ").append(this.blockCommitSequenceId);
        sb.append(" replicaIndex: ").append(this.replicaIndex);
    }

    @JsonIgnore
    public ContainerProtos.DatanodeBlockID getDatanodeBlockIDProtobuf() {
        ContainerProtos.DatanodeBlockID.Builder blockID = this.getDatanodeBlockIDProtobufBuilder();
        if (this.replicaIndex != null) {
            blockID.setReplicaIndex(this.replicaIndex.intValue());
        }
        return blockID.build();
    }

    @JsonIgnore
    public ContainerProtos.DatanodeBlockID.Builder getDatanodeBlockIDProtobufBuilder() {
        return ContainerProtos.DatanodeBlockID.newBuilder().setContainerID(this.containerBlockID.getContainerID()).setLocalID(this.containerBlockID.getLocalID()).setBlockCommitSequenceId(this.blockCommitSequenceId);
    }

    @JsonIgnore
    public static BlockID getFromProtobuf(ContainerProtos.DatanodeBlockID blockID) {
        return new BlockID(blockID.getContainerID(), blockID.getLocalID(), blockID.getBlockCommitSequenceId(), blockID.hasReplicaIndex() ? Integer.valueOf(blockID.getReplicaIndex()) : null);
    }

    @JsonIgnore
    public HddsProtos.BlockID getProtobuf() {
        return HddsProtos.BlockID.newBuilder().setContainerBlockID(this.containerBlockID.getProtobuf()).setBlockCommitSequenceId(this.blockCommitSequenceId).build();
    }

    @JsonIgnore
    public static BlockID getFromProtobuf(HddsProtos.BlockID blockID) {
        return new BlockID(ContainerBlockID.getFromProtobuf(blockID.getContainerBlockID()), blockID.getBlockCommitSequenceId(), null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockID blockID = (BlockID)o;
        return this.getContainerBlockID().equals(blockID.getContainerBlockID()) && this.getBlockCommitSequenceId() == blockID.getBlockCommitSequenceId() && Objects.equals(this.getReplicaIndex(), blockID.getReplicaIndex());
    }

    public int hashCode() {
        return Objects.hash(this.containerBlockID.getContainerID(), this.containerBlockID.getLocalID(), this.blockCommitSequenceId, this.replicaIndex);
    }
}

