/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.DatanodeID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.node.DatanodeInfo;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.node.SCMNodeManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.protocol.VersionResponse;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.RegisteredCommand;
import org.apache.hadoop.ozone.protocol.commands.ReregisterCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.ozone.recon.ReconContext;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconNodeManager
extends SCMNodeManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReconNodeManager.class);
    private Table<DatanodeID, DatanodeDetails> nodeDB;
    private ReconContext reconContext;
    private static final Set<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type> ALLOWED_COMMANDS = ImmutableSet.of((Object)StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.reregisterCommand);
    private Map<DatanodeID, Long> datanodeHeartbeatMap = new HashMap<DatanodeID, Long>();
    private final long reconDatanodeOutdatedTime;

    public ReconNodeManager(OzoneConfiguration conf, SCMStorageConfig scmStorageConfig, EventPublisher eventPublisher, NetworkTopology networkTopology, Table<DatanodeID, DatanodeDetails> nodeDB, HDDSLayoutVersionManager scmLayoutVersionManager) {
        super(conf, scmStorageConfig, eventPublisher, networkTopology, SCMContext.emptyContext(), scmLayoutVersionManager);
        int reconStaleDatanodeMultiplier = 3;
        this.reconDatanodeOutdatedTime = 3L * HddsServerUtil.getReconHeartbeatInterval((ConfigurationSource)conf);
        this.nodeDB = nodeDB;
    }

    public ReconNodeManager(OzoneConfiguration conf, SCMStorageConfig scmStorageConfig, EventQueue eventQueue, NetworkTopology clusterMap, Table<DatanodeID, DatanodeDetails> table, HDDSLayoutVersionManager scmLayoutVersionManager, ReconContext reconContext) {
        this(conf, scmStorageConfig, (EventPublisher)eventQueue, clusterMap, table, scmLayoutVersionManager);
        this.reconContext = reconContext;
        this.loadExistingNodes();
    }

    private void loadExistingNodes() {
        try (Table.KeyValueIterator iterator = this.nodeDB.iterator();){
            int nodeCount = 0;
            while (iterator.hasNext()) {
                DatanodeDetails datanodeDetails = (DatanodeDetails)((Table.KeyValue)iterator.next()).getValue();
                this.register(datanodeDetails, null, null, StorageContainerDatanodeProtocolProtos.LayoutVersionProto.newBuilder().setMetadataLayoutVersion(HDDSLayoutVersionManager.maxLayoutVersion()).setSoftwareLayoutVersion(HDDSLayoutVersionManager.maxLayoutVersion()).build());
                ++nodeCount;
            }
            LOG.info("Loaded {} nodes from node DB.", (Object)nodeCount);
        }
        catch (IOException ioEx) {
            LOG.error("Exception while loading existing nodes.", (Throwable)ioEx);
        }
    }

    public VersionResponse getVersion(StorageContainerDatanodeProtocolProtos.SCMVersionRequestProto versionRequest) {
        return VersionResponse.newBuilder().setVersion(0).build();
    }

    public void addNodeToDB(DatanodeDetails datanodeDetails) throws IOException {
        this.nodeDB.put((Object)datanodeDetails.getID(), (Object)datanodeDetails);
        LOG.info("Added a new node to db: {}", (Object)datanodeDetails);
    }

    public long getLastHeartbeat(DatanodeDetails datanodeDetails) {
        return this.datanodeHeartbeatMap.getOrDefault(datanodeDetails.getID(), 0L);
    }

    public void onMessage(CommandForDatanode commandForDatanode, EventPublisher ignored) {
        StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type cmdType = commandForDatanode.getCommand().getType();
        if (ALLOWED_COMMANDS.contains(cmdType)) {
            super.onMessage(commandForDatanode, ignored);
        } else {
            LOG.debug("Ignoring unsupported command {} for Datanode {}.", (Object)commandForDatanode.getCommand().getType(), (Object)commandForDatanode);
        }
    }

    public List<SCMCommand<?>> processHeartbeat(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.CommandQueueReportProto queueReport) {
        boolean needUpdate;
        long currentTime = Time.now();
        Long lastHeartbeat = this.datanodeHeartbeatMap.put(datanodeDetails.getID(), currentTime);
        boolean bl = needUpdate = lastHeartbeat == null || currentTime - lastHeartbeat >= this.reconDatanodeOutdatedTime;
        if (needUpdate) {
            LOG.info("Sending ReregisterCommand() for {}", (Object)datanodeDetails);
            return Collections.singletonList(new ReregisterCommand());
        }
        return super.processHeartbeat(datanodeDetails, queueReport).stream().filter(c -> ALLOWED_COMMANDS.contains(c.getType())).collect(Collectors.toList());
    }

    protected void updateDatanodeOpState(DatanodeDetails reportedDn) throws NodeNotFoundException {
        super.updateDatanodeOpState(reportedDn);
        super.getNodeStateManager().setNodeOperationalState(reportedDn, reportedDn.getPersistedOpState(), reportedDn.getPersistedOpStateExpiryEpochSec());
    }

    public void refreshAllHealthyDnUsageInfo() {
    }

    public RegisteredCommand register(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.NodeReportProto nodeReport, StorageContainerDatanodeProtocolProtos.PipelineReportsProto pipelineReportsProto, StorageContainerDatanodeProtocolProtos.LayoutVersionProto layoutInfo) {
        if (this.isNodeRegistered(datanodeDetails).booleanValue()) {
            try {
                this.nodeDB.put((Object)datanodeDetails.getID(), (Object)datanodeDetails);
                LOG.info("Updated {} db table for {}", (Object)this.nodeDB.getName(), (Object)datanodeDetails);
            }
            catch (IOException e) {
                LOG.error("Failed to update {} db table for {}", new Object[]{this.nodeDB.getName(), datanodeDetails, e});
            }
        }
        try {
            RegisteredCommand registeredCommand = super.register(datanodeDetails, nodeReport, pipelineReportsProto, layoutInfo);
            this.reconContext.updateHealthStatus(new AtomicBoolean(true));
            this.reconContext.getErrors().remove((Object)ReconContext.ErrorCode.INVALID_NETWORK_TOPOLOGY);
            return registeredCommand;
        }
        catch (NetworkTopology.InvalidTopologyException invalidTopologyException) {
            LOG.error("InvalidTopologyException error occurred : {}", (Object)invalidTopologyException.getMessage());
            this.reconContext.updateHealthStatus(new AtomicBoolean(false));
            this.reconContext.getErrors().add(ReconContext.ErrorCode.INVALID_NETWORK_TOPOLOGY);
            return RegisteredCommand.newBuilder().setErrorCode(StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.ErrorCode.errorNodeNotPermitted).setDatanode(datanodeDetails).setClusterID(this.reconContext.getClusterId()).build();
        }
    }

    public void updateNodeOperationalStateFromScm(HddsProtos.Node scmNode, DatanodeDetails dnDetails) throws NodeNotFoundException {
        NodeStatus nodeStatus = this.getNodeStatus(dnDetails);
        HddsProtos.NodeOperationalState nodeOperationalStateFromScm = scmNode.getNodeOperationalStates(0);
        if (nodeOperationalStateFromScm != nodeStatus.getOperationalState()) {
            LOG.info("Updating Node operational state for {}, in SCM = {}, in Recon = {}", new Object[]{dnDetails.getHostName(), nodeOperationalStateFromScm, nodeStatus.getOperationalState()});
            this.setNodeOperationalState(dnDetails, nodeOperationalStateFromScm);
            DatanodeInfo scmDnd = this.getNode(dnDetails.getID());
            scmDnd.setPersistedOpState(nodeOperationalStateFromScm);
        }
    }

    public void reinitialize(Table<DatanodeID, DatanodeDetails> nodeTable) {
        this.nodeDB = nodeTable;
        this.loadExistingNodes();
    }

    @VisibleForTesting
    public long getNodeDBKeyCount() throws IOException {
        long nodeCount = 0L;
        try (Table.KeyValueIterator iterator = this.nodeDB.iterator();){
            while (iterator.hasNext()) {
                iterator.next();
                ++nodeCount;
            }
            long l = nodeCount;
            return l;
        }
    }

    public void removeNode(DatanodeDetails datanodeDetails) throws NodeNotFoundException, IOException {
        try {
            super.removeNode(datanodeDetails);
            this.nodeDB.delete((Object)datanodeDetails.getID());
        }
        catch (IOException e) {
            throw new IOException("Failed to delete from nodeDB for " + datanodeDetails, e);
        }
        this.datanodeHeartbeatMap.remove(datanodeDetails.getID());
        LOG.info("Removed existing node {} from Node DB and NodeManager data structures in memory ", (Object)datanodeDetails);
    }

    protected void sendFinalizeToDatanodeIfNeeded(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.LayoutVersionProto layoutVersionReport) {
        int scmSlv = this.getLayoutVersionManager().getSoftwareLayoutVersion();
        int scmMlv = this.getLayoutVersionManager().getMetadataLayoutVersion();
        int dnSlv = layoutVersionReport.getSoftwareLayoutVersion();
        int dnMlv = layoutVersionReport.getMetadataLayoutVersion();
        if (dnSlv > scmSlv) {
            LOG.error("Invalid data node reporting to Recon : {}. DataNode SoftwareLayoutVersion = {}, Recon/SCM SoftwareLayoutVersion = {}", new Object[]{datanodeDetails.getHostName(), dnSlv, scmSlv});
        }
        if (scmMlv == scmSlv && dnMlv < scmMlv && LOG.isDebugEnabled()) {
            LOG.debug("Data node {} reports a lower MLV than Recon DataNode MetadataLayoutVersion = {}, Recon/SCM MetadataLayoutVersion = {}. SCM needs to finalize this DN", new Object[]{datanodeDetails.getHostName(), dnMlv, scmMlv});
        }
    }
}

