/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class ReconContext {
    private static final Logger LOG = LoggerFactory.getLogger(ReconContext.class);
    private final String threadNamePrefix;
    private String clusterId;
    private OzoneConfiguration ozoneConfiguration;
    private ReconUtils reconUtils;
    private AtomicBoolean isHealthy = new AtomicBoolean(true);
    private Map<ErrorCode, String> errCodeMsgMap = new HashMap<ErrorCode, String>();
    private Map<ErrorCode, List<String>> errCodeImpactMap = new HashMap<ErrorCode, List<String>>();
    private List<ErrorCode> errors = Collections.synchronizedList(new ArrayList());

    @Inject
    public ReconContext(OzoneConfiguration configuration, ReconUtils reconUtils) {
        this.reconUtils = reconUtils;
        this.ozoneConfiguration = configuration;
        this.threadNamePrefix = reconUtils.getReconNodeDetails(configuration).threadNamePrefix();
        this.initializeErrCodeMetaData();
    }

    private void initializeErrCodeMetaData() {
        for (ErrorCode errorCode : ErrorCode.values()) {
            this.errCodeMsgMap.put(errorCode, errorCode.getMessage());
            this.errCodeImpactMap.put(errorCode, errorCode.getImpacts());
        }
    }

    public void updateHealthStatus(AtomicBoolean healthStatus) {
        boolean oldHealthStatus = this.isHealthy.getAndSet(healthStatus.get());
        LOG.info("Update healthStatus of Recon from {} to {}.", (Object)oldHealthStatus, (Object)this.isHealthy.get());
    }

    public AtomicBoolean isHealthy() {
        return this.isHealthy;
    }

    public String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    public Map<ErrorCode, String> getErrCodeMsgMap() {
        return this.errCodeMsgMap;
    }

    public Map<ErrorCode, List<String>> getErrCodeImpactMap() {
        return this.errCodeImpactMap;
    }

    public List<ErrorCode> getErrors() {
        return this.errors;
    }

    public void updateErrors(ErrorCode errorCode) {
        this.errors.add(errorCode);
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public static enum ErrorCode {
        OK("Recon is healthy !!!", Collections.emptyList()),
        INVALID_NETWORK_TOPOLOGY("Invalid network topology of datanodes. Failed to register and load datanodes. Pipelines may not be healthy !!!", Arrays.asList("Datanodes", "Pipelines")),
        CERTIFICATE_INIT_FAILED("Error during initializing Recon certificate !!!", Arrays.asList("Initializing secure Recon")),
        INTERNAL_ERROR("Unexpected internal error. Kindly refer ozone-recon.log file for details !!!", Arrays.asList("Recon health")),
        GET_OM_DB_SNAPSHOT_FAILED("OM DB Snapshot sync failed !!!", Arrays.asList("Overview (OM Data)", "OM DB Insights")),
        GET_SCM_DB_SNAPSHOT_FAILED("SCM DB Snapshot sync failed !!!", Arrays.asList("Containers", "Pipelines")),
        UPGRADE_FAILURE("Schema upgrade failed. Recon encountered an issue while finalizing the layout upgrade.", Arrays.asList("Recon startup", "Metadata Layout Version"));

        private final String message;
        private final List<String> impacts;

        private ErrorCode(String message, List<String> impacts) {
            this.message = message;
            this.impacts = impacts;
        }

        public String getMessage() {
            return this.message;
        }

        public List<String> getImpacts() {
            return this.impacts;
        }
    }
}

