/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.tenant;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.tenant.TenantHandler;
import picocli.CommandLine;

@CommandLine.Command(name="assign", description={"Assign user accessId to tenant"})
public class TenantAssignUserAccessIdHandler
extends TenantHandler {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Parameters(description={"User name"}, arity="1..1")
    private String userPrincipal;
    @CommandLine.Option(names={"-t", "--tenant"}, description={"Tenant name"}, required=true)
    private String tenantId;
    @CommandLine.Option(names={"-a", "--access-id", "--accessId"}, description={"(Optional) Specify the accessId for user in this tenant. If unspecified, accessId would be in the form of TenantName$Principal."}, hidden=true)
    private String accessId;

    private String getDefaultAccessId(String userPrinc) {
        return this.tenantId + "$" + userPrinc;
    }

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        if (StringUtils.isEmpty((CharSequence)this.accessId)) {
            this.accessId = this.getDefaultAccessId(this.userPrincipal);
        }
        S3SecretValue resp = client.getObjectStore().tenantAssignUserAccessId(this.userPrincipal, this.tenantId, this.accessId);
        this.out().println("export AWS_ACCESS_KEY_ID='" + resp.getAwsAccessKey() + "'");
        this.out().println("export AWS_SECRET_ACCESS_KEY='" + resp.getAwsSecret() + "'");
        if (this.isVerbose()) {
            this.err().println("Assigned '" + this.userPrincipal + "' to '" + this.tenantId + "' with accessId '" + this.accessId + "'.");
        }
    }
}

