/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.keys;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import java.io.IOException;
import javax.xml.bind.DatatypeConverter;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientUtils;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.keys.KeyHandler;
import picocli.CommandLine;

@CommandLine.Command(name="checksum", description={"returns checksum information about an existing key"})
public class ChecksumKeyHandler
extends KeyHandler {
    @CommandLine.Option(names={"-c", "--combine-mode"}, description={"Method of combining the chunk checksums. Valid values are COMPOSITE_CRC and MD5MD5CRC. Defaults to COMPOSITE_CRC."})
    private OzoneClientConfig.ChecksumCombineMode mode = OzoneClientConfig.ChecksumCombineMode.COMPOSITE_CRC;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        ChecksumInfo checksumInfo = new ChecksumInfo(address, client, this.mode);
        this.printObjectAsJson(checksumInfo);
    }

    protected FileChecksum getFileChecksum(OzoneVolume vol, OzoneBucket bucket, String keyName, long dataSize, ClientProtocol clientProxy) throws IOException {
        return OzoneClientUtils.getFileChecksumWithCombineMode((OzoneVolume)vol, (OzoneBucket)bucket, (String)keyName, (long)dataSize, (OzoneClientConfig.ChecksumCombineMode)this.mode, (ClientProtocol)clientProxy);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    private class ChecksumInfo {
        private final String volumeName;
        private final String bucketName;
        private final String name;
        private final long dataSize;
        private final String algorithm;
        private final String checksum;

        ChecksumInfo(OzoneAddress address, OzoneClient client, OzoneClientConfig.ChecksumCombineMode mode) throws IOException {
            this.volumeName = address.getVolumeName();
            this.bucketName = address.getBucketName();
            this.name = address.getKeyName();
            OzoneVolume vol = client.getObjectStore().getVolume(this.volumeName);
            OzoneBucket bucket = vol.getBucket(this.bucketName);
            OzoneKeyDetails key = bucket.getKey(this.name);
            this.dataSize = key.getDataSize();
            FileChecksum fileChecksum = ChecksumKeyHandler.this.getFileChecksum(vol, bucket, this.name, this.dataSize, client.getObjectStore().getClientProxy());
            this.algorithm = fileChecksum.getAlgorithmName();
            this.checksum = DatatypeConverter.printHexBinary((byte[])fileChecksum.getBytes());
        }
    }
}

