/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.security;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.protocol.proto.SCMRatisProtocol;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.hadoop.hdds.scm.security.RootCARotationHandler;
import org.apache.hadoop.hdds.scm.security.RootCARotationManager;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.SCMCertificateClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootCARotationHandlerImpl
implements RootCARotationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RootCARotationHandlerImpl.class);
    private final StorageContainerManager scm;
    private final SCMCertificateClient scmCertClient;
    private final SecurityConfig secConfig;
    private Set<String> newScmCertIdSet = new HashSet<String>();
    private final String newSubCAPath;
    private final RootCARotationManager rotationManager;
    private AtomicReference<String> newSubCACertId = new AtomicReference();
    private AtomicReference<String> newRootCACertId = new AtomicReference();

    public RootCARotationHandlerImpl(StorageContainerManager scm, RootCARotationManager manager) {
        this.scm = scm;
        this.rotationManager = manager;
        this.scmCertClient = (SCMCertificateClient)scm.getScmCertificateClient();
        this.secConfig = this.scmCertClient.getSecurityConfig();
        this.newSubCAPath = this.secConfig.getLocation(this.scmCertClient.getComponentName()).toString() + "-next";
    }

    @Override
    public void rotationPrepare(String rootCertId) throws IOException {
        LOG.info("Received rotation prepare command of root certificate {}", (Object)rootCertId);
        if (this.rotationManager.shouldSkipRootCert(rootCertId)) {
            return;
        }
        this.newRootCACertId.set(rootCertId);
        this.newScmCertIdSet.clear();
        this.newSubCACertId.set(null);
        this.rotationManager.scheduleSubCaRotationPrepareTask(rootCertId);
    }

    @Override
    public void rotationPrepareAck(String rootCertId, String scmCertId, String scmId) throws IOException {
        LOG.info("Received rotation prepare ack of root certificate {} from scm {}", (Object)rootCertId, (Object)scmId);
        if (this.rotationManager.isRunning()) {
            if (this.rotationManager.shouldSkipRootCert(rootCertId)) {
                return;
            }
            if (rootCertId.equals(this.newRootCACertId.get())) {
                this.newScmCertIdSet.add(scmCertId);
            }
        }
    }

    @Override
    public void rotationCommit(String rootCertId) throws IOException {
        String message;
        LOG.info("Received rotation commit command of root certificate {}", (Object)rootCertId);
        if (this.rotationManager.shouldSkipRootCert(rootCertId)) {
            return;
        }
        File currentSubCaDir = new File(this.secConfig.getLocation(this.scmCertClient.getComponentName()).toString());
        File backupSubCaDir = new File(this.secConfig.getLocation(this.scmCertClient.getComponentName() + "-previous").toString());
        File newSubCaDir = new File(this.newSubCAPath);
        try {
            Files.move(currentSubCaDir.toPath(), backupSubCaDir.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOG.error("Failed to move {} to {}", new Object[]{currentSubCaDir, backupSubCaDir, e});
            message = "Terminate SCM, encounter IO exception(" + e.getMessage() + ") when move " + currentSubCaDir + " to " + backupSubCaDir;
            this.scm.shutDown(message);
        }
        try {
            Files.move(newSubCaDir.toPath(), currentSubCaDir.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOG.error("Failed to move {} to {}", new Object[]{newSubCaDir, currentSubCaDir, e});
            message = "Terminate SCM, encounter IO exception(" + e.getMessage() + ") when move " + newSubCaDir + " to " + currentSubCaDir;
            this.scm.shutDown(message);
        }
        try {
            String certId = this.newSubCACertId.get();
            LOG.info("Persistent new scm certificate {}", (Object)certId);
            this.scm.getScmStorageConfig().setScmCertSerialId(certId);
            this.scm.getScmStorageConfig().persistCurrentState();
        }
        catch (IOException e) {
            LOG.error("Failed to persist new SCM certificate ID", (Throwable)e);
            message = "Terminate SCM, encounter IO exception(" + e.getMessage() + ") when persist new SCM certificate ID";
            this.scm.shutDown(message);
        }
    }

    @Override
    public void rotationCommitted(String rootCertId) throws IOException {
        LOG.info("Received rotation committed command of root certificate {}", (Object)rootCertId);
        if (this.rotationManager.shouldSkipRootCert(rootCertId)) {
            return;
        }
        this.scmCertClient.reloadKeyAndCertificate(this.newSubCACertId.get());
        File backupSubCaDir = new File(this.secConfig.getLocation(this.scmCertClient.getComponentName() + "-previous").toString());
        try {
            FileUtils.deleteDirectory((File)backupSubCaDir);
        }
        catch (IOException e) {
            LOG.error("Failed to delete backup dir {}", (Object)backupSubCaDir, (Object)e);
        }
        this.newSubCACertId.set(null);
    }

    @Override
    public int rotationPrepareAcks() {
        return this.newScmCertIdSet.size();
    }

    @Override
    public void resetRotationPrepareAcks() {
        this.newScmCertIdSet.clear();
    }

    @Override
    public void setSubCACertId(String subCACertId) {
        this.newSubCACertId.set(subCACertId);
        LOG.info("Scm sub CA new certificate is {}", (Object)subCACertId);
    }

    public static class Builder {
        private StorageContainerManager scm;
        private SCMRatisServer ratisServer;
        private RootCARotationManager rootCARotationManager;

        public Builder setRatisServer(SCMRatisServer scmRatisServer) {
            this.ratisServer = scmRatisServer;
            return this;
        }

        public Builder setStorageContainerManager(StorageContainerManager storageContainerManager) {
            this.scm = storageContainerManager;
            return this;
        }

        public Builder setRootCARotationManager(RootCARotationManager manager) {
            this.rootCARotationManager = manager;
            return this;
        }

        public RootCARotationHandler build() {
            RootCARotationHandlerImpl impl = new RootCARotationHandlerImpl(this.scm, this.rootCARotationManager);
            return this.ratisServer.getProxyHandler(SCMRatisProtocol.RequestType.CERT_ROTATE, RootCARotationHandler.class, impl);
        }
    }
}

