/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.safemode.AbstractContainerSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.ratis.util.Preconditions;

public class RatisContainerSafeModeRule
extends AbstractContainerSafeModeRule {
    public RatisContainerSafeModeRule(EventQueue eventQueue, ConfigurationSource conf, ContainerManager containerManager, SCMSafeModeManager manager) {
        super(conf, manager, containerManager, eventQueue);
    }

    @Override
    protected HddsProtos.ReplicationType getContainerType() {
        return HddsProtos.ReplicationType.RATIS;
    }

    @Override
    protected void handleReportedContainer(ContainerID containerID, DatanodeID datanodeID) {
        int minReplica = this.getMinReplica(containerID);
        if (this.getContainers().remove(containerID) != null) {
            Preconditions.assertSame((int)1, (int)minReplica, (String)"minReplica");
            this.incrementContainersWithMinReplicas();
            this.getSafeModeMetrics().incCurrentContainersWithOneReplicaReportedCount();
        }
    }
}

