/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerActionsHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.ContainerActionsFromDatanode> {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerActionsHandler.class);

    public void onMessage(SCMDatanodeHeartbeatDispatcher.ContainerActionsFromDatanode containerReportFromDatanode, EventPublisher publisher) {
        DatanodeDetails dd = containerReportFromDatanode.getDatanodeDetails();
        block3: for (StorageContainerDatanodeProtocolProtos.ContainerAction action : ((StorageContainerDatanodeProtocolProtos.ContainerActionsProto)containerReportFromDatanode.getReport()).getContainerActionsList()) {
            ContainerID containerId = ContainerID.valueOf((long)action.getContainerID());
            switch (action.getAction()) {
                case CLOSE: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Closing container {} in datanode {} because the container is {}.", new Object[]{containerId, dd, action.getReason()});
                    }
                    publisher.fireEvent(SCMEvents.CLOSE_CONTAINER, (Object)containerId);
                    continue block3;
                }
            }
            LOG.warn("Invalid action {} with reason {}, from datanode {}. ", new Object[]{action.getAction(), action.getReason(), dd});
        }
    }
}

