/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.block;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.SCMRatisProtocol;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLogStateManager;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.hadoop.hdds.scm.metadata.DBTransactionBuffer;
import org.apache.hadoop.hdds.utils.db.CodecException;
import org.apache.hadoop.hdds.utils.db.RocksDatabaseException;
import org.apache.hadoop.hdds.utils.db.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletedBlockLogStateManagerImpl
implements DeletedBlockLogStateManager {
    private static final Logger LOG = LoggerFactory.getLogger(DeletedBlockLogStateManagerImpl.class);
    private Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> deletedTable;
    private ContainerManager containerManager;
    private final DBTransactionBuffer transactionBuffer;
    private final Set<Long> deletingTxIDs;

    public DeletedBlockLogStateManagerImpl(ConfigurationSource conf, Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> deletedTable, ContainerManager containerManager, DBTransactionBuffer txBuffer) {
        this.deletedTable = deletedTable;
        this.containerManager = containerManager;
        this.transactionBuffer = txBuffer;
        this.deletingTxIDs = ConcurrentHashMap.newKeySet();
    }

    @Override
    public Table.KeyValueIterator<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> getReadOnlyIterator() throws IOException {
        return new Table.KeyValueIterator<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>(){
            private final Table.KeyValueIterator<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> iter;
            private Table.KeyValue<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> nextTx;
            {
                this.iter = DeletedBlockLogStateManagerImpl.this.deletedTable.iterator();
                this.findNext();
            }

            private void findNext() {
                while (this.iter.hasNext()) {
                    Table.KeyValue next = (Table.KeyValue)this.iter.next();
                    long txID = (Long)next.getKey();
                    if (DeletedBlockLogStateManagerImpl.this.deletingTxIDs.contains(txID)) continue;
                    this.nextTx = next;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("DeletedBlocksTransaction matching txID:{}", (Object)txID);
                    }
                    return;
                }
                this.nextTx = null;
            }

            public boolean hasNext() {
                return this.nextTx != null;
            }

            public Table.KeyValue<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> next() {
                if (this.nextTx == null) {
                    throw new NoSuchElementException("DeletedBlocksTransaction Iterator reached end");
                }
                Table.KeyValue<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> returnTx = this.nextTx;
                this.findNext();
                return returnTx;
            }

            public void close() throws RocksDatabaseException {
                this.iter.close();
            }

            public void seekToFirst() {
                this.iter.seekToFirst();
                this.findNext();
            }

            public void seekToLast() {
                throw new UnsupportedOperationException("seekToLast");
            }

            public Table.KeyValue<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> seek(Long key) throws RocksDatabaseException, CodecException {
                this.iter.seek((Object)key);
                this.findNext();
                return this.nextTx;
            }

            public void removeFromDB() {
                throw new UnsupportedOperationException("read-only");
            }
        };
    }

    @Override
    public void addTransactionsToDB(ArrayList<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> txs) throws IOException {
        HashMap<ContainerID, Long> containerIdToTxnIdMap = new HashMap<ContainerID, Long>();
        for (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction tx : txs) {
            long tid = tx.getTxID();
            containerIdToTxnIdMap.compute(ContainerID.valueOf((long)tx.getContainerID()), (k, v) -> v != null && v > tid ? v : tid);
            this.transactionBuffer.addToBuffer(this.deletedTable, (Object)tx.getTxID(), (Object)tx);
        }
        this.containerManager.updateDeleteTransactionId(containerIdToTxnIdMap);
    }

    @Override
    public void removeTransactionsFromDB(ArrayList<Long> txIDs) throws IOException {
        if (this.deletingTxIDs != null) {
            this.deletingTxIDs.addAll(txIDs);
        }
        for (Long txID : txIDs) {
            this.transactionBuffer.removeFromBuffer(this.deletedTable, (Object)txID);
        }
    }

    @Override
    @Deprecated
    public void increaseRetryCountOfTransactionInDB(ArrayList<Long> txIDs) throws IOException {
    }

    @Override
    @Deprecated
    public int resetRetryCountOfTransactionInDB(ArrayList<Long> txIDs) throws IOException {
        return 0;
    }

    @Override
    public void onFlush() {
        Preconditions.checkNotNull(this.deletingTxIDs);
        this.deletingTxIDs.clear();
    }

    @Override
    public void reinitialize(Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> deletedBlocksTXTable) {
        Preconditions.checkArgument((boolean)this.deletingTxIDs.isEmpty());
        this.deletedTable = deletedBlocksTXTable;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private ConfigurationSource conf;
        private SCMRatisServer scmRatisServer;
        private Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> table;
        private DBTransactionBuffer transactionBuffer;
        private ContainerManager containerManager;

        public Builder setConfiguration(ConfigurationSource config) {
            this.conf = config;
            return this;
        }

        public Builder setRatisServer(SCMRatisServer ratisServer) {
            this.scmRatisServer = ratisServer;
            return this;
        }

        public Builder setDeletedBlocksTable(Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> deletedBlocksTable) {
            this.table = deletedBlocksTable;
            return this;
        }

        public Builder setSCMDBTransactionBuffer(DBTransactionBuffer buffer) {
            this.transactionBuffer = buffer;
            return this;
        }

        public Builder setContainerManager(ContainerManager contManager) {
            this.containerManager = contManager;
            return this;
        }

        public DeletedBlockLogStateManager build() {
            Preconditions.checkNotNull((Object)this.conf);
            Preconditions.checkNotNull(this.table);
            DeletedBlockLogStateManagerImpl impl = new DeletedBlockLogStateManagerImpl(this.conf, this.table, this.containerManager, this.transactionBuffer);
            return this.scmRatisServer.getProxyHandler(SCMRatisProtocol.RequestType.BLOCK, DeletedBlockLogStateManager.class, impl);
        }
    }
}

