/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.rocksdiff;

import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;

public class DifferSnapshotInfo {
    private final String dbPath;
    private final UUID snapshotId;
    private final long snapshotGeneration;
    private final Map<String, String> tablePrefixes;
    private final ManagedRocksDB rocksDB;

    public DifferSnapshotInfo(String db, UUID id, long gen, Map<String, String> prefixes, ManagedRocksDB rocksDB) {
        this.dbPath = db;
        this.snapshotId = id;
        this.snapshotGeneration = gen;
        this.tablePrefixes = prefixes;
        this.rocksDB = rocksDB;
    }

    public String getDbPath() {
        return this.dbPath;
    }

    public UUID getSnapshotId() {
        return this.snapshotId;
    }

    public long getSnapshotGeneration() {
        return this.snapshotGeneration;
    }

    public Map<String, String> getTablePrefixes() {
        return this.tablePrefixes;
    }

    public String toString() {
        return String.format("DifferSnapshotInfo{dbPath='%s', snapshotID='%s', snapshotGeneration=%d, tablePrefixes size=%s}", this.dbPath, this.snapshotId, this.snapshotGeneration, this.tablePrefixes.size());
    }

    public ManagedRocksDB getRocksDB() {
        return this.rocksDB;
    }
}

