/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;

@Metrics(about="Ozone Volume Health Metrics", context="ozone")
public final class VolumeHealthMetrics
implements MetricsSource {
    private static final String SOURCE_BASENAME = VolumeHealthMetrics.class.getSimpleName();
    private static final MetricsInfo TOTAL_VOLUMES = Interns.info((String)"TotalVolumes", (String)"Total number of volumes");
    private static final MetricsInfo HEALTHY_VOLUMES = Interns.info((String)"NumHealthyVolumes", (String)"Number of healthy volumes");
    private static final MetricsInfo FAILED_VOLUMES = Interns.info((String)"NumFailedVolumes", (String)"Number of failed volumes");
    private final MetricsRegistry registry;
    private final String metricsSourceName;
    private final AtomicInteger healthyVolumes = new AtomicInteger(0);
    private final AtomicInteger failedVolumes = new AtomicInteger(0);

    private VolumeHealthMetrics(StorageVolume.VolumeType volumeType) {
        this.metricsSourceName = SOURCE_BASENAME + '-' + volumeType.name();
        this.registry = new MetricsRegistry(this.metricsSourceName);
    }

    public static VolumeHealthMetrics create(StorageVolume.VolumeType volumeType) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        VolumeHealthMetrics metrics = new VolumeHealthMetrics(volumeType);
        return (VolumeHealthMetrics)ms.register(metrics.metricsSourceName, "Volume Health Statistics", (Object)metrics);
    }

    public void unregister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(this.metricsSourceName);
    }

    public void incrementHealthyVolumes() {
        this.healthyVolumes.incrementAndGet();
    }

    public void incrementFailedVolumes() {
        this.failedVolumes.incrementAndGet();
    }

    public void decrementHealthyVolumes() {
        this.healthyVolumes.decrementAndGet();
    }

    public void decrementFailedVolumes() {
        this.failedVolumes.decrementAndGet();
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder builder = collector.addRecord(this.metricsSourceName);
        this.registry.snapshot(builder, all);
        builder.addGauge(TOTAL_VOLUMES, this.healthyVolumes.get() + this.failedVolumes.get()).addGauge(HEALTHY_VOLUMES, this.healthyVolumes.get()).addGauge(FAILED_VOLUMES, this.failedVolumes.get());
    }
}

