/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.ObjectName;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.LegacyHadoopConfigurationSource;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.container.common.statemachine.EndpointStateMachine;
import org.apache.hadoop.ozone.container.common.statemachine.EndpointStateMachineMBean;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManagerMXBean;
import org.apache.hadoop.ozone.protocolPB.ReconDatanodeProtocolPB;
import org.apache.hadoop.ozone.protocolPB.StorageContainerDatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.ozone.protocolPB.StorageContainerDatanodeProtocolPB;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMConnectionManager
implements Closeable,
SCMConnectionManagerMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(SCMConnectionManager.class);
    private final ReadWriteLock mapLock = new ReentrantReadWriteLock();
    private final Map<InetSocketAddress, EndpointStateMachine> scmMachines;
    private final int rpcTimeout;
    private final ConfigurationSource conf;
    private ObjectName jmxBean;

    public SCMConnectionManager(ConfigurationSource conf) {
        Long timeOut = HddsServerUtil.getScmRpcTimeOutInMilliseconds((ConfigurationSource)conf);
        this.rpcTimeout = timeOut.intValue();
        this.scmMachines = new HashMap<InetSocketAddress, EndpointStateMachine>();
        this.conf = conf;
        this.jmxBean = MBeans.register((String)"HddsDatanode", (String)"SCMConnectionManager", (Object)this);
    }

    public ConfigurationSource getConf() {
        return this.conf;
    }

    public int getRpcTimeout() {
        return this.rpcTimeout;
    }

    public void readLock() {
        this.mapLock.readLock().lock();
    }

    public void readUnlock() {
        this.mapLock.readLock().unlock();
    }

    public void writeLock() {
        this.mapLock.writeLock().lock();
    }

    public void writeUnlock() {
        this.mapLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSCMServer(InetSocketAddress address, String threadNamePrefix) throws IOException {
        this.writeLock();
        try {
            if (this.scmMachines.containsKey(address)) {
                LOG.warn("Trying to add an existing SCM Machine to Machines group. Ignoring the request.");
                return;
            }
            Configuration hadoopConfig = LegacyHadoopConfigurationSource.asHadoopConfiguration((ConfigurationSource)this.conf);
            RPC.setProtocolEngine((Configuration)hadoopConfig, StorageContainerDatanodeProtocolPB.class, ProtobufRpcEngine.class);
            long version = RPC.getProtocolVersion(StorageContainerDatanodeProtocolPB.class);
            RetryPolicy retryPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)HddsServerUtil.getScmRpcRetryCount((ConfigurationSource)this.conf), (long)HddsServerUtil.getScmRpcRetryInterval((ConfigurationSource)this.conf), (TimeUnit)TimeUnit.MILLISECONDS);
            StorageContainerDatanodeProtocolPB rpcProxy = (StorageContainerDatanodeProtocolPB)RPC.getProtocolProxy(StorageContainerDatanodeProtocolPB.class, (long)version, (InetSocketAddress)address, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)hadoopConfig, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)hadoopConfig), (int)this.getRpcTimeout(), (RetryPolicy)retryPolicy).getProxy();
            StorageContainerDatanodeProtocolClientSideTranslatorPB rpcClient = new StorageContainerDatanodeProtocolClientSideTranslatorPB(rpcProxy);
            EndpointStateMachine endPoint = new EndpointStateMachine(address, rpcClient, this.conf, threadNamePrefix);
            endPoint.setPassive(false);
            this.scmMachines.put(address, endPoint);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReconServer(InetSocketAddress address, String threadNamePrefix) throws IOException {
        LOG.info("Adding Recon Server : {}", (Object)address.toString());
        this.writeLock();
        try {
            if (this.scmMachines.containsKey(address)) {
                LOG.warn("Trying to add an existing SCM Machine to Machines group. Ignoring the request.");
                return;
            }
            Configuration hadoopConfig = LegacyHadoopConfigurationSource.asHadoopConfiguration((ConfigurationSource)this.conf);
            RPC.setProtocolEngine((Configuration)hadoopConfig, ReconDatanodeProtocolPB.class, ProtobufRpcEngine.class);
            long version = RPC.getProtocolVersion(ReconDatanodeProtocolPB.class);
            RetryPolicy retryPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)HddsServerUtil.getScmRpcRetryCount((ConfigurationSource)this.conf), (long)HddsServerUtil.getScmRpcRetryInterval((ConfigurationSource)this.conf), (TimeUnit)TimeUnit.MILLISECONDS);
            ReconDatanodeProtocolPB rpcProxy = (ReconDatanodeProtocolPB)RPC.getProtocolProxy(ReconDatanodeProtocolPB.class, (long)version, (InetSocketAddress)address, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)hadoopConfig, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)hadoopConfig), (int)this.getRpcTimeout(), (RetryPolicy)retryPolicy).getProxy();
            StorageContainerDatanodeProtocolClientSideTranslatorPB rpcClient = new StorageContainerDatanodeProtocolClientSideTranslatorPB(rpcProxy);
            EndpointStateMachine endPoint = new EndpointStateMachine(address, rpcClient, this.conf, threadNamePrefix);
            endPoint.setPassive(true);
            this.scmMachines.put(address, endPoint);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void removeSCMServer(InetSocketAddress address) throws IOException {
        this.writeLock();
        try {
            if (!this.scmMachines.containsKey(address)) {
                LOG.warn("Trying to remove a non-existent SCM machine. Ignoring the request.");
                return;
            }
            EndpointStateMachine endPoint = this.scmMachines.get(address);
            endPoint.close();
            this.scmMachines.remove(address);
        }
        finally {
            this.writeUnlock();
        }
    }

    public Collection<EndpointStateMachine> getValues() {
        this.readLock();
        try {
            List<EndpointStateMachine> list = Collections.unmodifiableList(new ArrayList<EndpointStateMachine>(this.scmMachines.values()));
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.getValues().forEach(endpointStateMachine -> IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{endpointStateMachine}));
        if (this.jmxBean != null) {
            MBeans.unregister((ObjectName)this.jmxBean);
            this.jmxBean = null;
        }
    }

    @Override
    public List<EndpointStateMachineMBean> getSCMServers() {
        this.readLock();
        try {
            List<EndpointStateMachineMBean> list = Collections.unmodifiableList(new ArrayList<EndpointStateMachine>(this.scmMachines.values()));
            return list;
        }
        finally {
            this.readUnlock();
        }
    }
}

