/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.helpers;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.hdds.utils.IOUtils;

public class DatanodeVersionFile {
    private final String storageId;
    private final String clusterId;
    private final String datanodeUuid;
    private final long cTime;
    private final int layoutVersion;

    public DatanodeVersionFile(String storageId, String clusterId, String datanodeUuid, long cTime, int layoutVersion) {
        this.storageId = storageId;
        this.clusterId = clusterId;
        this.datanodeUuid = datanodeUuid;
        this.cTime = cTime;
        this.layoutVersion = layoutVersion;
    }

    private Properties createProperties() {
        Properties properties = new Properties();
        properties.setProperty("storageID", this.storageId);
        properties.setProperty("clusterID", this.clusterId);
        properties.setProperty("datanodeUuid", this.datanodeUuid);
        properties.setProperty("ctime", String.valueOf(this.cTime));
        properties.setProperty("layOutVersion", String.valueOf(this.layoutVersion));
        return properties;
    }

    public void createVersionFile(File path) throws IOException {
        IOUtils.writePropertiesToFile((File)path, (Properties)this.createProperties());
    }

    public static Properties readFrom(File versionFile) throws IOException {
        return IOUtils.readPropertiesFromFile((File)versionFile);
    }
}

