/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class DefaultAnnotation
implements InvocationHandler,
Annotation {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final Class<? extends Annotation> annotationClass;

    public static Annotation of(Class<? extends Annotation> annotation) {
        return (Annotation)Proxy.newProxyInstance(annotation.getClassLoader(), new Class[]{annotation}, (InvocationHandler)new DefaultAnnotation(annotation));
    }

    private DefaultAnnotation(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("hashCode".equals(method.getName())) {
            return this.hashCode();
        }
        if ("equals".equals(method.getName())) {
            return this.equals(args[0]);
        }
        if ("annotationType".equals(method.getName())) {
            return this.annotationType();
        }
        if ("toString".equals(method.getName())) {
            return this.toString();
        }
        return method.getDefaultValue();
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationClass;
    }

    @Override
    public String toString() {
        Method[] methods = this.annotationClass.getDeclaredMethods();
        StringBuilder sb = new StringBuilder("@" + this.annotationType().getName() + "(");
        int lenght = methods.length;
        for (int i = 0; i < lenght; ++i) {
            Object memberValue;
            sb.append(methods[i].getName()).append("=");
            try {
                memberValue = this.invoke(this, methods[i], EMPTY_OBJECT_ARRAY);
            }
            catch (Throwable throwable) {
                memberValue = "";
            }
            sb.append(memberValue);
            if (i >= lenght - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

