/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.corespi.scanner;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.corespi.scanner.xbean.CdiArchive;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.UrlSet;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.archive.Archive;

public abstract class AbstractMetaDataDiscovery
implements ScannerService {
    protected static final Logger logger = WebBeansLoggerFacade.getLogger(AbstractMetaDataDiscovery.class);
    public static final String META_INF_BEANS_XML = "META-INF/beans.xml";
    private final UrlSet webBeansXmlLocations = new UrlSet();
    protected ClassLoader loader;
    protected CdiArchive archive;
    protected AnnotationFinder finder;
    protected boolean isBDAScannerEnabled = false;
    protected BDABeansXmlScanner bdaBeansXmlScanner;

    protected AnnotationFinder initFinder() {
        if (this.finder != null) {
            return this.finder;
        }
        ArrayList<URL> trimmedUrls = new ArrayList<URL>();
        for (URL url : this.getUrls()) {
            try {
                String file = url.getFile();
                if (file.endsWith(META_INF_BEANS_XML)) {
                    file = file.substring(0, file.length() - META_INF_BEANS_XML.length());
                } else if (file.endsWith("WEB-INF/beans.xml")) {
                    file = file.substring(0, file.length() - "WEB-INF/beans.xml".length());
                }
                trimmedUrls.add(new URL(url.getProtocol(), url.getHost(), url.getPort(), file));
            }
            catch (MalformedURLException e) {
                throw new WebBeansConfigurationException("Can't trim url " + url.toExternalForm());
            }
        }
        this.archive = new CdiArchive(WebBeansUtil.getCurrentClassLoader(), trimmedUrls);
        this.finder = new AnnotationFinder((Archive)this.archive);
        return this.finder;
    }

    protected Iterable<URL> getUrls() {
        return this.webBeansXmlLocations;
    }

    public void scan() throws WebBeansDeploymentException {
        try {
            this.configure();
            this.initFinder();
        }
        catch (Exception e) {
            throw new WebBeansDeploymentException(e);
        }
    }

    public void release() {
        this.finder = null;
        this.archive = null;
        this.loader = null;
    }

    protected abstract void configure();

    protected String[] findBeansXmlBases(String resourceName, ClassLoader loader) {
        this.loader = loader;
        ArrayList<String> list = new ArrayList<String>();
        try {
            Enumeration<URL> urls = loader.getResources(resourceName);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                this.addWebBeansXmlLocation(url);
                String urlString = url.toString();
                int idx = urlString.lastIndexOf(resourceName);
                urlString = urlString.substring(0, idx);
                list.add(urlString);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return list.toArray(new String[list.size()]);
    }

    public void init(Object object) {
        String usage = WebBeansContext.currentInstance().getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.useBDABeansXMLScanner");
        this.isBDAScannerEnabled = Boolean.parseBoolean(usage);
    }

    public Set<String> getAllAnnotations(String className) {
        throw new UnsupportedOperationException();
    }

    protected void addWebBeansXmlLocation(URL beansXmlUrl) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("added beans.xml marker: " + beansXmlUrl.toExternalForm());
        }
        this.webBeansXmlLocations.add(beansXmlUrl);
    }

    public Set<Class<?>> getBeanClasses() {
        HashSet classSet = new HashSet();
        for (String str : this.archive.getClasses()) {
            try {
                Class<?> clazz = ClassUtil.getClassFromName(str);
                if (clazz == null) continue;
                clazz.getDeclaredFields();
                clazz.getDeclaredMethods();
                classSet.add(clazz);
            }
            catch (NoClassDefFoundError e) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "WARN_0018", new Object[]{str, e.toString()});
            }
        }
        return classSet;
    }

    public Set<URL> getBeanXmls() {
        return Collections.unmodifiableSet(this.webBeansXmlLocations);
    }

    public BDABeansXmlScanner getBDABeansXmlScanner() {
        return this.bdaBeansXmlScanner;
    }

    public boolean isBDABeansXmlScanningEnabled() {
        return this.isBDAScannerEnabled;
    }
}

