/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.models;

import java.io.IOException;
import opennlp.tools.models.ClassPathModelFinder;
import opennlp.tools.models.ClassPathModelLoader;
import opennlp.tools.models.ClassPathModelProvider;
import opennlp.tools.models.ModelType;
import opennlp.tools.models.simple.SimpleClassPathModelFinder;
import opennlp.tools.util.model.BaseModel;

public class DefaultClassPathModelProvider
implements ClassPathModelProvider {
    private final ClassPathModelFinder finder;
    private final ClassPathModelLoader loader;

    public DefaultClassPathModelProvider() {
        this(new SimpleClassPathModelFinder(), new ClassPathModelLoader());
    }

    public DefaultClassPathModelProvider(ClassPathModelFinder finder, ClassPathModelLoader loader) {
        if (finder == null) {
            throw new IllegalArgumentException("ClassPathModelFinder cannot be null.");
        }
        if (loader == null) {
            throw new IllegalArgumentException("ClassPathModelLoader cannot be null.");
        }
        this.finder = finder;
        this.loader = loader;
    }

    @Override
    public <T extends BaseModel> T load(String lang, ModelType type, Class<T> modelType) throws IOException {
        return this.load(lang, type, modelType, false);
    }

    @Override
    public <T extends BaseModel> T load(String lang, ModelType type, Class<T> modelType, boolean reloadCache) throws IOException {
        return this.loader.load(this.finder.findModels(reloadCache), lang, type, modelType);
    }
}

