/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.DataConnectionConfig;
import com.hazelcast.spi.annotation.PrivateApi;
import java.util.ArrayList;

@PrivateApi
public final class DataConnectionConfigValidator {
    private DataConnectionConfigValidator() {
    }

    @PrivateApi
    public static void validate(DataConnectionConfig conf) {
        ArrayList<String> errors = new ArrayList<String>();
        if (conf.getName() == null || conf.getName().isEmpty()) {
            errors.add("Data connection name must be non-null and contain text");
        }
        if (conf.getType() == null || conf.getType().isEmpty()) {
            errors.add("Data connection type must be non-null and contain text");
        }
        if (conf.getProperties() == null) {
            errors.add("Data connection properties cannot be null, they can be empty");
        }
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(String.join((CharSequence)", ", errors));
        }
    }
}

