/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.core.converter;

import jakarta.inject.Inject;
import java.io.File;
import java.util.Optional;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.openmeetings.core.converter.ImageConverter;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.entity.file.FileItem;
import org.apache.openmeetings.util.StoredFile;
import org.apache.openmeetings.util.process.ProcessResult;
import org.apache.openmeetings.util.process.ProcessResultList;
import org.apache.wicket.util.string.Strings;
import org.jodconverter.core.job.ConversionJob;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.local.LocalConverter;
import org.jodconverter.local.office.LocalOfficeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DocumentConverter {
    private static final Logger log = LoggerFactory.getLogger(DocumentConverter.class);
    private static final String JOD_JOD_NAME = "doJodConvert";
    @Inject
    protected ConfigurationDao cfgDao;
    @Inject
    private ImageConverter imageConverter;

    public ProcessResultList convertPDF(FileItem f, StoredFile sf) throws Exception {
        return this.convertPDF(f, sf, new ProcessResultList(), Optional.empty());
    }

    public ProcessResultList convertPDF(FileItem f, StoredFile sf, ProcessResultList logs, Optional<DoubleConsumer> progress) throws Exception {
        boolean fullProcessing = !sf.isPdf();
        File original = f.getFile(sf.getExt());
        File pdf = f.getFile("pdf");
        log.debug("fullProcessing: {}", (Object)fullProcessing);
        if (fullProcessing) {
            log.debug("-- running JOD --");
            logs.add(this.doJodConvert(original, pdf));
        } else if (!"pdf".equals(sf.getExt())) {
            FileUtils.copyFile((File)original, (File)pdf);
        }
        progress.ifPresent(theProgress -> theProgress.accept(0.5));
        log.debug("-- generate page images --");
        return this.imageConverter.convertDocument(f, pdf, logs, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createOfficeManager(String officePath, Function<OfficeManager, ConversionJob> job) throws OfficeException {
        LocalOfficeManager manager = null;
        try {
            LocalOfficeManager.Builder builder = LocalOfficeManager.builder();
            if (!Strings.isEmpty((String)officePath)) {
                builder.officeHome(officePath);
            }
            manager = builder.build();
            manager.start();
            if (job != null) {
                job.apply((OfficeManager)manager).execute();
            }
        }
        finally {
            if (manager != null) {
                manager.stop();
            }
        }
    }

    public ProcessResult doJodConvert(File in, File out) {
        try {
            DocumentConverter.createOfficeManager(this.cfgDao.getString("path.office", null), man -> LocalConverter.make((OfficeManager)man).convert(in).to(out));
        }
        catch (Exception ex) {
            log.error(JOD_JOD_NAME, (Throwable)ex);
            return new ProcessResult(JOD_JOD_NAME, ex.getMessage(), ex);
        }
        return new ProcessResult(JOD_JOD_NAME, "Document converted successfully", null).setExitCode(Integer.valueOf(0));
    }
}

