/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.namespace.impl;

import com.hazelcast.internal.namespace.impl.NamespaceThreadLocalContext;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;

public class NamespaceAwareClassLoader
extends ClassLoader {
    private final ClassLoader parent;

    public NamespaceAwareClassLoader(ClassLoader parent) {
        super(parent);
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            ClassLoader candidate = this.pickClassLoader();
            Class<?> klass = candidate.loadClass(name);
            if (resolve) {
                this.resolveClass(klass);
            }
            return klass;
        }
    }

    ClassLoader pickClassLoader() {
        ClassLoader classLoader = NamespaceThreadLocalContext.getClassLoader();
        if (classLoader != null) {
            return classLoader;
        }
        return this.parent;
    }

    @Override
    public URL getResource(String name) {
        return this.pickClassLoader().getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.pickClassLoader().getResources(name);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

