/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.jdbc.sql.AbstractSQLServerDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.lib.jdbc.DelegatingConnection;
import org.apache.openjpa.lib.util.ConcreteClassGenerator;
import org.apache.openjpa.lib.util.Localizer;

public class SybaseDictionary
extends AbstractSQLServerDictionary {
    private static Localizer _loc = Localizer.forPackage(SybaseDictionary.class);
    private static Constructor<SybaseConnection> sybaseConnectionImpl;
    public static String RIGHT_TRUNCATION_ON_SQL;
    public static String NUMERIC_TRUNCATION_OFF_SQL;
    public boolean createIdentityColumn = true;
    public String identityColumnName = "UNQ_INDEX";
    public boolean ignoreNumericTruncation = false;

    public SybaseDictionary() {
        this.platform = "Sybase";
        this.schemaCase = "preserve";
        this.forUpdateClause = "FOR UPDATE AT ISOLATION SERIALIZABLE";
        this.supportsLockingWithDistinctClause = false;
        this.supportsNullTableForGetColumns = false;
        this.requiresAliasForSubselect = true;
        this.requiresAutoCommitForMetaData = true;
        this.maxTableNameLength = 30;
        this.maxColumnNameLength = 30;
        this.maxIndexNameLength = 30;
        this.maxConstraintNameLength = 30;
        this.bigintTypeName = "NUMERIC(38)";
        this.bitTypeName = "TINYINT";
        this.crossJoinClause = "JOIN";
        this.requiresConditionForCrossJoin = true;
        this.systemTableSet.addAll(Arrays.asList("IJDBC_FUNCTION_ESCAPES", "JDBC_FUNCTION_ESCAPES", "SPT_IJDBC_CONVERSION", "SPT_IJDBC_MDA", "SPT_IJDBC_TABLE_TYPES", "SPT_JDBC_CONVERSION", "SPT_JDBC_TABLE_TYPES", "SPT_JTEXT", "SPT_LIMIT_TYPES", "SPT_MDA", "SPT_MONITOR", "SPT_VALUES", "SYBLICENSESLOG"));
        this.reservedWordSet.addAll(Arrays.asList("ARITH_OVERFLOW", "BREAK", "BROWSE", "BULK", "CHAR_CONVERT", "CHECKPOINT", "CLUSTERED", "COMPUTE", "CONFIRM", "CONTROLROW", "DATABASE", "DBCC", "DETERMINISTIC", "DISK DISTINCT", "DUMMY", "DUMP", "ENDTRAN", "ERRLVL", "ERRORDATA", "ERROREXIT", "EXCLUSIVE", "EXIT", "EXP_ROW_SIZE", "FILLFACTOR", "FUNC", "FUNCTION", "HOLDLOCK", "IDENTITY_GAP", "IDENTITY_INSERT", "IDENTITY_START", "IF", "INDEX", "INOUT", "INSTALL", "INTERSECT", "JAR", "KILL", "LINENO", "LOAD", "LOCK", "MAX_ROWS_PER_PAGE", "MIRROR", "MIRROREXIT", "MODIFY", "NEW", "NOHOLDLOCK", "NONCLUSTERED", "NUMERIC_TRUNCATION", "OFF", "OFFSETS", "ONCE", "ONLINE", "OUT", "OVER", "PARTITION", "PERM", "PERMANENT", "PLAN", "PRINT", "PROC", "PROCESSEXIT", "PROXY_TABLE", "QUIESCE", "RAISERROR", "READ", "READPAST", "READTEXT", "RECONFIGURE", "REFERENCES REMOVE", "REORG", "REPLACE", "REPLICATION", "RESERVEPAGEGAP", "RETURN", "RETURNS", "ROLE", "ROWCOUNT", "RULE", "SAVE", "SETUSER", "SHARED", "SHUTDOWN", "SOME", "STATISTICS", "STRINGSIZE", "STRIPE", "SYB_IDENTITY", "SYB_RESTREE", "SYB_TERMINATE", "TEMP", "TEXTSIZE", "TRAN", "TRIGGER", "TRUNCATE", "TSEQUAL", "UNPARTITION", "USE", "USER_OPTION", "WAITFOR", "WHILE", "WRITETEXT"));
        this.invalidColumnWordSet.addAll(this.reservedWordSet);
        this.supportsNullDeleteAction = false;
        this.supportsDefaultDeleteAction = false;
        this.supportsCascadeDeleteAction = false;
        this.supportsNullUpdateAction = false;
        this.supportsDefaultUpdateAction = false;
        this.supportsCascadeUpdateAction = false;
        this.fixedSizeTypeNameSet.remove("NUMERIC");
    }

    @Override
    public int getJDBCType(int metaTypeCode, boolean lob) {
        switch (metaTypeCode) {
            case 1: 
            case 17: {
                return this.getPreferredType(5);
            }
        }
        return super.getJDBCType(metaTypeCode, lob);
    }

    @Override
    public void setBigInteger(PreparedStatement stmnt, int idx, BigInteger val, Column col) throws SQLException {
        this.setObject(stmnt, idx, new BigDecimal(val), -5, col);
    }

    @Override
    public String[] getCreateTableSQL(Table table) {
        PrimaryKey pk;
        if (!this.createIdentityColumn) {
            return super.getCreateTableSQL(table);
        }
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE TABLE ").append(this.getFullName(table, false)).append(" (");
        Column[] cols = table.getColumns();
        boolean hasIdentity = false;
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i].isAutoAssigned()) {
                hasIdentity = true;
            }
            if (cols[i].getIdentifier().getName().equals(this.identityColumnName)) {
                hasIdentity = true;
                if (cols[i].getType() != 2) {
                    cols[i].setType(2);
                }
            }
            buf.append(i == 0 ? "" : ", ");
            buf.append(this.getDeclareColumnSQL(cols[i], false));
        }
        if (!hasIdentity) {
            buf.append(", ").append(this.identityColumnName).append(" NUMERIC IDENTITY UNIQUE");
        }
        if ((pk = table.getPrimaryKey()) != null) {
            buf.append(", ").append(this.getPrimaryKeyConstraintSQL(pk));
        }
        Unique[] unqs = table.getUniques();
        for (int i = 0; i < unqs.length; ++i) {
            String unqStr = this.getUniqueConstraintSQL(unqs[i]);
            if (unqStr == null) continue;
            buf.append(", ").append(unqStr);
        }
        buf.append(")");
        return new String[]{buf.toString()};
    }

    @Override
    protected String getDeclareColumnSQL(Column col, boolean alter) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getColumnDBName(col)).append(" ");
        buf.append(this.getTypeName(col));
        if (!alter) {
            if (col.getDefaultString() != null && !col.isAutoAssigned()) {
                buf.append(" DEFAULT ").append(col.getDefaultString());
            }
            if (col.isAutoAssigned()) {
                buf.append(" IDENTITY");
            }
        }
        if (col.isNotNull()) {
            buf.append(" NOT NULL");
        } else if (!col.isPrimaryKey()) {
            buf.append(" NULL");
        }
        return buf.toString();
    }

    @Override
    public String[] getDropColumnSQL(Column column) {
        return new String[]{"ALTER TABLE " + this.getFullName(column.getTable(), false) + " DROP " + this.getColumnDBName(column)};
    }

    @Override
    public void refSchemaComponents(Table table) {
        Column[] cols = table.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (!this.identityColumnName.equalsIgnoreCase(cols[i].getIdentifier().getName())) continue;
            cols[i].ref();
        }
    }

    @Override
    public void endConfiguration() {
        super.endConfiguration();
        String url = this.conf.getConnectionURL();
        if (!StringUtils.isEmpty(url) && url.toLowerCase(Locale.ENGLISH).indexOf("jdbc:sybase:tds") != -1 && url.toLowerCase(Locale.ENGLISH).indexOf("be_as_jdbc_compliant_as_possible=") == -1) {
            this.log.warn(_loc.get("sybase-compliance", url));
        }
    }

    @Override
    public Connection decorate(Connection conn) throws SQLException {
        PreparedStatement stmnt;
        Connection savedConn = conn = super.decorate(conn);
        if (this.setStringRightTruncationOn) {
            stmnt = this.prepareStatement(conn, RIGHT_TRUNCATION_ON_SQL);
            stmnt.execute();
            stmnt.close();
        }
        if (this.ignoreNumericTruncation) {
            stmnt = this.prepareStatement(conn, NUMERIC_TRUNCATION_OFF_SQL);
            stmnt.execute();
            stmnt.close();
        }
        return ConcreteClassGenerator.newInstance(sybaseConnectionImpl, savedConn);
    }

    protected String getStringFromResultSet(ResultSet rs, String jdbcName, String sybaseName) throws SQLException {
        try {
            return rs.getString(jdbcName);
        }
        catch (SQLException sqle) {
            return rs.getString(sybaseName);
        }
    }

    protected boolean getBooleanFromResultSet(ResultSet rs, String jdbcName, String sybaseName) throws SQLException {
        try {
            return rs.getBoolean(jdbcName);
        }
        catch (SQLException sqle) {
            return rs.getBoolean(sybaseName);
        }
    }

    @Override
    protected PrimaryKey newPrimaryKey(ResultSet pkMeta) throws SQLException {
        PrimaryKey pk = new PrimaryKey();
        pk.setSchemaIdentifier(this.fromDBName(this.getStringFromResultSet(pkMeta, "TABLE_SCHEM", "table_owner"), DBIdentifier.DBIdentifierType.SCHEMA));
        pk.setTableIdentifier(this.fromDBName(this.getStringFromResultSet(pkMeta, "TABLE_NAME", "table_name"), DBIdentifier.DBIdentifierType.TABLE));
        pk.setColumnIdentifier(this.fromDBName(this.getStringFromResultSet(pkMeta, "COLUMN_NAME", "column_name"), DBIdentifier.DBIdentifierType.COLUMN));
        pk.setIdentifier(this.fromDBName(this.getStringFromResultSet(pkMeta, "PK_NAME", "index_name"), DBIdentifier.DBIdentifierType.CONSTRAINT));
        return pk;
    }

    @Override
    protected Index newIndex(ResultSet idxMeta) throws SQLException {
        Index idx = new Index();
        idx.setSchemaIdentifier(this.fromDBName(this.getStringFromResultSet(idxMeta, "TABLE_SCHEM", "table_owner"), DBIdentifier.DBIdentifierType.SCHEMA));
        idx.setTableIdentifier(this.fromDBName(this.getStringFromResultSet(idxMeta, "TABLE_NAME", "table_name"), DBIdentifier.DBIdentifierType.TABLE));
        idx.setColumnIdentifier(this.fromDBName(this.getStringFromResultSet(idxMeta, "COLUMN_NAME", "column_name"), DBIdentifier.DBIdentifierType.COLUMN));
        idx.setIdentifier(this.fromDBName(this.getStringFromResultSet(idxMeta, "INDEX_NAME", "index_name"), DBIdentifier.DBIdentifierType.INDEX));
        idx.setUnique(!this.getBooleanFromResultSet(idxMeta, "NON_UNIQUE", "non_unique"));
        return idx;
    }

    @Override
    public boolean isFatalException(int subtype, SQLException ex) {
        SQLException next;
        if (subtype == 1 && "JZ0TO".equals((next = ex.getNextException()).getSQLState())) {
            return false;
        }
        return super.isFatalException(subtype, ex);
    }

    @Override
    public String getIsNullSQL(String colAlias, int colType) {
        switch (colType) {
            case 2004: 
            case 2005: {
                return String.format("datalength(%s) = 0", colAlias);
            }
        }
        return super.getIsNullSQL(colAlias, colType);
    }

    @Override
    public String getIsNotNullSQL(String colAlias, int colType) {
        switch (colType) {
            case 2004: 
            case 2005: {
                return String.format("datalength(%s) != 0", colAlias);
            }
        }
        return super.getIsNotNullSQL(colAlias, colType);
    }

    @Override
    public String getIdentityColumnName() {
        return this.identityColumnName;
    }

    @Override
    public void indexOf(SQLBuffer buf, FilterValue str, FilterValue find, FilterValue start) {
        buf.append("(CHARINDEX(");
        find.appendTo(buf);
        buf.append(", ");
        if (start != null) {
            this.substring(buf, str, start, null);
        } else {
            str.appendTo(buf);
        }
        buf.append(")");
        if (start != null) {
            buf.append(" - 1 + ");
            start.appendTo(buf);
        }
        buf.append(")");
    }

    static {
        RIGHT_TRUNCATION_ON_SQL = "set string_rtruncation on";
        NUMERIC_TRUNCATION_OFF_SQL = "set arithabort numeric_truncation off";
        try {
            sybaseConnectionImpl = ConcreteClassGenerator.getConcreteConstructor(SybaseConnection.class, Connection.class);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    protected static abstract class SybaseConnection
    extends DelegatingConnection {
        private String _catalog = null;

        public SybaseConnection(Connection conn) {
            super(conn);
        }

        @Override
        public String getCatalog() throws SQLException {
            if (this._catalog == null) {
                this._catalog = super.getCatalog();
            }
            return this._catalog;
        }

        @Override
        public void setAutoCommit(boolean autocommit) throws SQLException {
            try {
                super.setAutoCommit(autocommit);
            }
            catch (SQLException e) {
                if (autocommit) {
                    super.commit();
                } else {
                    super.rollback();
                }
                super.setAutoCommit(autocommit);
            }
        }
    }
}

