/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.edm.geo;

import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.geo.SRID;

public abstract class Geospatial {
    protected final Dimension dimension;
    protected final Type type;
    protected final SRID srid;

    protected Geospatial(Dimension dimension, Type type, SRID srid) {
        this.dimension = dimension;
        this.type = type;
        this.srid = srid == null ? new SRID() : srid;
        this.srid.setDimension(dimension);
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Type getGeoType() {
        return this.type;
    }

    public SRID getSrid() {
        return this.srid;
    }

    public abstract EdmPrimitiveTypeKind getEdmPrimitiveTypeKind();

    public static enum Type {
        POINT,
        LINESTRING,
        POLYGON,
        MULTIPOINT,
        MULTILINESTRING,
        MULTIPOLYGON,
        GEOSPATIALCOLLECTION;

    }

    public static enum Dimension {
        GEOMETRY,
        GEOGRAPHY;

    }
}

