/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.api.exception;

import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.rt.RuntimeDelegate;

public abstract class ODataMessageException
extends ODataException {
    private static final long serialVersionUID = 42L;
    protected final MessageReference messageReference;
    protected final String errorCode;
    public static final MessageReference COMMON = ODataMessageException.createMessageReference(ODataMessageException.class, "COMMON");

    public ODataMessageException(MessageReference messageReference) {
        this(messageReference, null, null);
    }

    public ODataMessageException(MessageReference messageReference, Throwable cause) {
        this(messageReference, cause, null);
    }

    public ODataMessageException(MessageReference messageReference, Throwable cause, String errorCode) {
        super(cause);
        this.messageReference = messageReference;
        this.errorCode = errorCode;
    }

    public ODataMessageException(MessageReference messageReference, String errorCode) {
        this(messageReference, null, errorCode);
    }

    protected static final MessageReference createMessageReference(Class<? extends ODataMessageException> clazz, String messageReferenceKey) {
        return MessageReference.create(clazz, messageReferenceKey);
    }

    public MessageReference getMessageReference() {
        return this.messageReference;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        if (this.messageReference == null) {
            return "No message reference given. Inherit message is = '" + super.getMessage() + "'";
        }
        String message = RuntimeDelegate.extractExceptionMessage(this);
        if (message == null) {
            return "Message Reference key = '" + this.messageReference.getKey() + "' and inherit message = '" + super.getMessage() + "'";
        }
        return message;
    }
}

