/****************************************************************************
 * arch/arm/src/imx9/hardware/imx95/imx95_clock.h
 *
 * SPDX-License-Identifier: Apache-2.0
 * SPDX-FileCopyrightText: 2024 NXP
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_ARM_SRC_IMX9_HARDWARE_IMX95_IMX95_CLOCK_H
#define __ARCH_ARM_SRC_IMX9_HARDWARE_IMX95_IMX95_CLOCK_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>

#include <stdbool.h>
#include <stdint.h>

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

typedef enum
{
    EXT_CLK  = 0,
    OSC_32K_CLK  = 1,
    OSC_24M_CLK  = 2,
    FRO_CLK  = 3,
    SYS_PLL1_CTL  = 4,
    SYS_PLL1_DFS0_CTL  = 5,
    SYS_PLL1_DFS0_CLK  = 6,
    SYS_PLL1_DFS0_DIV2_CLK  = 7,
    SYS_PLL1_DFS1_CTL  = 8,
    SYS_PLL1_DFS1_CLK  = 9,
    SYS_PLL1_DFS1_DIV2_CLK  = 10,
    SYS_PLL1_DFS2_CTL  = 11,
    SYS_PLL1_DFS2_CLK  = 12,
    SYS_PLL1_DFS2_DIV2_CLK  = 13,
    AUDIO_PLL1_CTL  = 14,
    AUDIO_PLL1_CLK  = 15,
    AUDIO_PLL2_CTL  = 16,
    AUDIO_PLL2_CLK  = 17,
    VIDEO_PLL1_CTL  = 18,
    VIDEO_PLL1_CLK  = 19,
    VIDEO_PLL2_CTL  = 20,
    VIDEO_PLL2_CLK  = 21,
    VIDEO_PLL3_CTL  = 22,
    VIDEO_PLL3_CLK  = 23,
    ARM_PLL_CTL  = 24,
    ARM_PLL_DFS0_CTL  = 25,
    ARM_PLL_DFS0_CLK  = 26,
    ARM_PLL_DFS1_CTL  = 27,
    ARM_PLL_DFS1_CLK  = 28,
    ARM_PLL_DFS2_CTL  = 29,
    ARM_PLL_DFS2_CLK  = 30,
    ARM_PLL_DFS3_CTL  = 31,
    ARM_PLL_DFS3_CLK  = 32,
    DRAM_PLL_CTL  = 33,
    DRAM_PLL_CLK  = 34,
    HSIO_PLL_CTL  = 35,
    HSIO_PLL_CLK  = 36,
    LDB_PLL_CTL  = 37,
    LDB_PLL_CLK  = 38,
} clock_id_e;

#define CCM_CR_COUNT 122

typedef uint32_t clock_config_t;

#define CLOCK_DIV_SHIFT      (16)
#define CLOCK_DIV_MASK       (0xff << CLOCK_DIV_SHIFT)
#define CLOCK_DIV(n)         (((n) << CLOCK_DIV_SHIFT) & CLOCK_DIV_MASK)
#define GET_CLOCK_DIV(n)     (((n) & CLOCK_DIV_MASK) >> CLOCK_DIV_SHIFT)

#define CLOCK_ROOT_SHIFT     (8)
#define CLOCK_ROOT_MASK      (0x7f << CLOCK_ROOT_SHIFT)
#define CLOCK_ROOT(n)        (((n) << CLOCK_ROOT_SHIFT) & CLOCK_ROOT_MASK)
#define GET_CLOCK_ROOT(n)    (((n) & CLOCK_ROOT_MASK) >> CLOCK_ROOT_SHIFT)

#define CLOCK_ID_SHIFT     (3)
#define CLOCK_ID_MASK      (0x1f << CLOCK_ID_SHIFT)
#define CLOCK_ID(n)        (((n) << CLOCK_ID_SHIFT) & CLOCK_ID_MASK)
#define GET_CLOCK_ID(n)    (((n) & CLOCK_ID_MASK) >> CLOCK_ID_SHIFT)

#define ROOT_MUX_SHIFT       (0)
#define ROOT_MUX_MASK        (0x07 << ROOT_MUX_SHIFT)
#define ROOT_MUX(n)          (((n) << ROOT_MUX_SHIFT) & ROOT_MUX_MASK)

/* ADC_CLK_ROOT */
#define ADC_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(0U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define ADC_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(0U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define ADC_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(0U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define ADC_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(0U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* TMU_CLK_ROOT */
#define TMU_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(1U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define TMU_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(1U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define TMU_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(1U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define TMU_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(1U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* BUS_AON_CLK_ROOT */
#define BUS_AON_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(2U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define BUS_AON_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(2U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define BUS_AON_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(2U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define BUS_AON_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(2U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* CAN1_CLK_ROOT */
#define CAN1_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(3U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define CAN1_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(3U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define CAN1_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(3U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define CAN1_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(3U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* I3C1_CLK_ROOT */
#define I3C1_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(4U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define I3C1_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(4U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define I3C1_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(4U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define I3C1_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(4U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* I3C1_SLOW_CLK_ROOT */
#define I3C1_SLOW_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(5U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define I3C1_SLOW_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(5U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define I3C1_SLOW_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(5U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define I3C1_SLOW_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(5U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPI2C1_CLK_ROOT */
#define LPI2C1_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(6U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPI2C1_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(6U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPI2C1_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(6U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPI2C1_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(6U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPI2C2_CLK_ROOT */
#define LPI2C2_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(7U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPI2C2_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(7U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPI2C2_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(7U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPI2C2_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(7U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPSPI1_CLK_ROOT */
#define LPSPI1_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(8U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPSPI1_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(8U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPSPI1_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(8U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPSPI1_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(8U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPSPI2_CLK_ROOT */
#define LPSPI2_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(9U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPSPI2_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(9U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPSPI2_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(9U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPSPI2_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(9U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPTMR1_CLK_ROOT */
#define LPTMR1_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(10U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPTMR1_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(10U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPTMR1_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(10U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPTMR1_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(10U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPUART1_CLK_ROOT */
#define LPUART1_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(11U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPUART1_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(11U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPUART1_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(11U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPUART1_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(11U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPUART2_CLK_ROOT */
#define LPUART2_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(12U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPUART2_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(12U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPUART2_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(12U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPUART2_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(12U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* M33_CLK_ROOT */
#define M33_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(13U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define M33_CLK_ROOT_SYS_PLL1_DFS0_CLK       CLOCK_ROOT(13U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define M33_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(13U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define M33_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(13U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* M33_SYSTICK_CLK_ROOT */
#define M33_SYSTICK_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(14U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define M33_SYSTICK_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(14U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define M33_SYSTICK_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(14U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define M33_SYSTICK_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(14U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* MQS1_CLK_ROOT */
#define MQS1_CLK_ROOT_OSC_24M_CLK     CLOCK_ROOT(15U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define MQS1_CLK_ROOT_AUDIO_PLL1_CLK  CLOCK_ROOT(15U) | ROOT_MUX(1U) | CLOCK_ID(AUDIO_PLL1_CLK)
#define MQS1_CLK_ROOT_AUDIO_PLL2_CLK  CLOCK_ROOT(15U) | ROOT_MUX(2U) | CLOCK_ID(AUDIO_PLL2_CLK)
#define MQS1_CLK_ROOT_EXT_CLK         CLOCK_ROOT(15U) | ROOT_MUX(3U) | CLOCK_ID(EXT_CLK)

/* PDM_CLK_ROOT */
#define PDM_CLK_ROOT_OSC_24M_CLK     CLOCK_ROOT(16U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define PDM_CLK_ROOT_AUDIO_PLL1_CLK  CLOCK_ROOT(16U) | ROOT_MUX(1U) | CLOCK_ID(AUDIO_PLL1_CLK)
#define PDM_CLK_ROOT_AUDIO_PLL2_CLK  CLOCK_ROOT(16U) | ROOT_MUX(2U) | CLOCK_ID(AUDIO_PLL2_CLK)
#define PDM_CLK_ROOT_EXT_CLK         CLOCK_ROOT(16U) | ROOT_MUX(3U) | CLOCK_ID(EXT_CLK)

/* SAI1_CLK_ROOT */
#define SAI1_CLK_ROOT_OSC_24M_CLK     CLOCK_ROOT(17U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define SAI1_CLK_ROOT_AUDIO_PLL1_CLK  CLOCK_ROOT(17U) | ROOT_MUX(1U) | CLOCK_ID(AUDIO_PLL1_CLK)
#define SAI1_CLK_ROOT_AUDIO_PLL2_CLK  CLOCK_ROOT(17U) | ROOT_MUX(2U) | CLOCK_ID(AUDIO_PLL2_CLK)
#define SAI1_CLK_ROOT_EXT_CLK         CLOCK_ROOT(17U) | ROOT_MUX(3U) | CLOCK_ID(EXT_CLK)

/* SENTINEL_CLK_ROOT */
#define SENTINEL_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(18U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define SENTINEL_CLK_ROOT_SYS_PLL1_DFS0_CLK       CLOCK_ROOT(18U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define SENTINEL_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(18U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define SENTINEL_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(18U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* TPM2_CLK_ROOT */
#define TPM2_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(19U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define TPM2_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(19U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define TPM2_CLK_ROOT_AUDIO_PLL1_CLK     CLOCK_ROOT(19U) | ROOT_MUX(2U) | CLOCK_ID(AUDIO_PLL1_CLK)
#define TPM2_CLK_ROOT_EXT_CLK            CLOCK_ROOT(19U) | ROOT_MUX(3U) | CLOCK_ID(EXT_CLK)

/* TSTMR1_CLK_ROOT */
#define TSTMR1_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(20U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define TSTMR1_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(20U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define TSTMR1_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(20U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define TSTMR1_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(20U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* CAM_APB_CLK_ROOT */
#define CAM_APB_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(21U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define CAM_APB_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(21U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define CAM_APB_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(21U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define CAM_APB_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(21U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* CAM_AXI_CLK_ROOT */
#define CAM_AXI_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(22U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define CAM_AXI_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(22U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define CAM_AXI_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(22U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define CAM_AXI_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(22U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* CAM_CM0_CLK_ROOT */
#define CAM_CM0_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(23U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define CAM_CM0_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(23U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define CAM_CM0_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(23U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define CAM_CM0_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(23U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* CAM_ISI_CLK_ROOT */
#define CAM_ISI_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(24U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define CAM_ISI_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(24U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define CAM_ISI_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(24U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define CAM_ISI_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(24U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* MIPI_PHY_CFG_CLK_ROOT */
#define MIPI_PHY_CFG_CLK_ROOT_OSC_24M_CLK     CLOCK_ROOT(25U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define MIPI_PHY_CFG_CLK_ROOT_AUDIO_PLL1_CLK  CLOCK_ROOT(25U) | ROOT_MUX(1U) | CLOCK_ID(AUDIO_PLL1_CLK)
#define MIPI_PHY_CFG_CLK_ROOT_VIDEO_PLL1_CLK  CLOCK_ROOT(25U) | ROOT_MUX(2U) | CLOCK_ID(VIDEO_PLL1_CLK)

/* MIPI_PHY_PLL_BYPASS_CLK_ROOT */
#define MIPI_PHY_PLL_BYPASS_CLK_ROOT_OSC_24M_CLK     CLOCK_ROOT(26U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define MIPI_PHY_PLL_BYPASS_CLK_ROOT_AUDIO_PLL1_CLK  CLOCK_ROOT(26U) | ROOT_MUX(1U) | CLOCK_ID(AUDIO_PLL1_CLK)
#define MIPI_PHY_PLL_BYPASS_CLK_ROOT_VIDEO_PLL1_CLK  CLOCK_ROOT(26U) | ROOT_MUX(2U) | CLOCK_ID(VIDEO_PLL1_CLK)

/* MIPI_PHY_PLL_REF_CLK_ROOT */
#define MIPI_PHY_PLL_REF_CLK_ROOT_OSC_24M_CLK     CLOCK_ROOT(27U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define MIPI_PHY_PLL_REF_CLK_ROOT_AUDIO_PLL1_CLK  CLOCK_ROOT(27U) | ROOT_MUX(1U) | CLOCK_ID(AUDIO_PLL1_CLK)
#define MIPI_PHY_PLL_REF_CLK_ROOT_VIDEO_PLL1_CLK  CLOCK_ROOT(27U) | ROOT_MUX(2U) | CLOCK_ID(VIDEO_PLL1_CLK)

/* MIPI_TEST_BYTE_CLK_ROOT */
#define MIPI_TEST_BYTE_CLK_ROOT_OSC_24M_CLK     CLOCK_ROOT(28U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define MIPI_TEST_BYTE_CLK_ROOT_AUDIO_PLL1_CLK  CLOCK_ROOT(28U) | ROOT_MUX(1U) | CLOCK_ID(AUDIO_PLL1_CLK)
#define MIPI_TEST_BYTE_CLK_ROOT_VIDEO_PLL1_CLK  CLOCK_ROOT(28U) | ROOT_MUX(2U) | CLOCK_ID(VIDEO_PLL1_CLK)

/* ARM_A55_CLK_ROOT */
#define ARM_A55_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(29U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define ARM_A55_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(29U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define ARM_A55_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(29U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define ARM_A55_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(29U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* ARM_A55_MTR_BUS_CLK_ROOT */
#define ARM_A55_MTR_BUS_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(30U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define ARM_A55_MTR_BUS_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(30U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define ARM_A55_MTR_BUS_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(30U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define ARM_A55_MTR_BUS_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(30U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* ARM_A55_PERIPH_CLK_ROOT */
#define ARM_A55_PERIPH_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(31U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define ARM_A55_PERIPH_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(31U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define ARM_A55_PERIPH_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(31U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define ARM_A55_PERIPH_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(31U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* DRAM_ALT_CLK_ROOT */
#define DRAM_ALT_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(32U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define DRAM_ALT_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(32U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define DRAM_ALT_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(32U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define DRAM_ALT_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(32U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* DRAM_APB_CLK_ROOT */
#define DRAM_APB_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(33U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define DRAM_APB_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(33U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define DRAM_APB_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(33U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define DRAM_APB_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(33U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* DISP_APB_CLK_ROOT */
#define DISP_APB_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(34U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define DISP_APB_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(34U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define DISP_APB_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(34U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define DISP_APB_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(34U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* DISP_AXI_CLK_ROOT */
#define DISP_AXI_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(35U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define DISP_AXI_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(35U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define DISP_AXI_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(35U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define DISP_AXI_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(35U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* DISP_DP_CLK_ROOT */
#define DISP_DP_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(36U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define DISP_DP_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(36U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define DISP_DP_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(36U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define DISP_DP_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(36U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* DISP_OCRAM_CLK_ROOT */
#define DISP_OCRAM_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(37U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define DISP_OCRAM_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(37U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define DISP_OCRAM_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(37U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define DISP_OCRAM_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(37U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* DISP_USB31_CLK_ROOT */
#define DISP_USB31_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(38U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define DISP_USB31_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(38U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define DISP_USB31_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(38U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define DISP_USB31_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(38U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* DISP1_PIX_CLK_ROOT */
#define DISP1_PIX_CLK_ROOT_OSC_24M_CLK     CLOCK_ROOT(39U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define DISP1_PIX_CLK_ROOT_AUDIO_PLL1_CLK  CLOCK_ROOT(39U) | ROOT_MUX(1U) | CLOCK_ID(AUDIO_PLL1_CLK)
#define DISP1_PIX_CLK_ROOT_VIDEO_PLL1_CLK  CLOCK_ROOT(39U) | ROOT_MUX(2U) | CLOCK_ID(VIDEO_PLL1_CLK)

/* GPU_APB_CLK_ROOT */
#define GPU_APB_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(42U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define GPU_APB_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(42U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define GPU_APB_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(42U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define GPU_APB_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(42U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* GPU_CLK_ROOT */
#define GPU_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(43U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define GPU_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(43U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define GPU_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(43U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define GPU_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(43U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* HSIO_ACSCAN_480M_CLK_ROOT */
#define HSIO_ACSCAN_480M_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(44U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define HSIO_ACSCAN_480M_CLK_ROOT_AUDIO_PLL1_CLK     CLOCK_ROOT(44U) | ROOT_MUX(1U) | CLOCK_ID(AUDIO_PLL1_CLK)
#define HSIO_ACSCAN_480M_CLK_ROOT_VIDEO_PLL1_CLK     CLOCK_ROOT(44U) | ROOT_MUX(2U) | CLOCK_ID(VIDEO_PLL1_CLK)
#define HSIO_ACSCAN_480M_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(44U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* HSIO_ACSCAN_80M_CLK_ROOT */
#define HSIO_ACSCAN_80M_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(45U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define HSIO_ACSCAN_80M_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(45U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define HSIO_ACSCAN_80M_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(45U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define HSIO_ACSCAN_80M_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(45U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* HSIO_CLK_ROOT */
#define HSIO_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(46U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define HSIO_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(46U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define HSIO_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(46U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define HSIO_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(46U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* HSIO_PCIE_AUX_CLK_ROOT */
#define HSIO_PCIE_AUX_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(47U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define HSIO_PCIE_AUX_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(47U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define HSIO_PCIE_AUX_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(47U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define HSIO_PCIE_AUX_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(47U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* HSIO_PCIE_TEST_160M_CLK_ROOT */
#define HSIO_PCIE_TEST_160M_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(48U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define HSIO_PCIE_TEST_160M_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(48U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define HSIO_PCIE_TEST_160M_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(48U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define HSIO_PCIE_TEST_160M_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(48U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* HSIO_PCIE_TEST_400M_CLK_ROOT */
#define HSIO_PCIE_TEST_400M_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(49U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define HSIO_PCIE_TEST_400M_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(49U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define HSIO_PCIE_TEST_400M_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(49U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define HSIO_PCIE_TEST_400M_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(49U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* HSIO_PCIE_TEST_500M_CLK_ROOT */
#define HSIO_PCIE_TEST_500M_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(50U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define HSIO_PCIE_TEST_500M_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(50U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define HSIO_PCIE_TEST_500M_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(50U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define HSIO_PCIE_TEST_500M_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(50U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* HSIO_USB_TEST_50M_CLK_ROOT */
#define HSIO_USB_TEST_50M_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(51U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define HSIO_USB_TEST_50M_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(51U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define HSIO_USB_TEST_50M_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(51U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define HSIO_USB_TEST_50M_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(51U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* HSIO_USB_TEST_60M_CLK_ROOT */
#define HSIO_USB_TEST_60M_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(52U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define HSIO_USB_TEST_60M_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(52U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define HSIO_USB_TEST_60M_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(52U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define HSIO_USB_TEST_60M_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(52U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* BUS_M7_CLK_ROOT */
#define BUS_M7_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(53U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define BUS_M7_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(53U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define BUS_M7_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(53U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define BUS_M7_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(53U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* M7_CLK_ROOT */
#define M7_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(54U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define M7_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(54U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define M7_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(54U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define M7_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(54U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* M7_SYSTICK_CLK_ROOT */
#define M7_SYSTICK_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(55U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define M7_SYSTICK_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(55U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define M7_SYSTICK_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(55U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define M7_SYSTICK_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(55U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* BUS_NETCMIX_CLK_ROOT */
#define BUS_NETCMIX_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(56U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define BUS_NETCMIX_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(56U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define BUS_NETCMIX_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(56U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define BUS_NETCMIX_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(56U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* ENET_CLK_ROOT */
#define ENET_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(57U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define ENET_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(57U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define ENET_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(57U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define ENET_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(57U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* ENET_PHY_TEST_200M_CLK_ROOT */
#define ENET_PHY_TEST_200M_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(58U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define ENET_PHY_TEST_200M_CLK_ROOT_SYS_PLL1_DFS0_CLK       CLOCK_ROOT(58U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define ENET_PHY_TEST_200M_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(58U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define ENET_PHY_TEST_200M_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(58U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* ENET_PHY_TEST_500M_CLK_ROOT */
#define ENET_PHY_TEST_500M_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(59U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define ENET_PHY_TEST_500M_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(59U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define ENET_PHY_TEST_500M_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(59U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define ENET_PHY_TEST_500M_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(59U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* ENET_PHY_TEST_667M_CLK_ROOT */
#define ENET_PHY_TEST_667M_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(60U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define ENET_PHY_TEST_667M_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(60U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define ENET_PHY_TEST_667M_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(60U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define ENET_PHY_TEST_667M_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(60U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* ENET_REF_CLK_ROOT */
#define ENET_REF_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(61U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define ENET_REF_CLK_ROOT_SYS_PLL1_DFS0_CLK       CLOCK_ROOT(61U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define ENET_REF_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(61U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define ENET_REF_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(61U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* ENET_TIMER1_CLK_ROOT */
#define ENET_TIMER1_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(62U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define ENET_TIMER1_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(62U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define ENET_TIMER1_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(62U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define ENET_TIMER1_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(62U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* MQS2_CLK_ROOT */
#define MQS2_CLK_ROOT_OSC_24M_CLK     CLOCK_ROOT(63U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define MQS2_CLK_ROOT_AUDIO_PLL1_CLK  CLOCK_ROOT(63U) | ROOT_MUX(1U) | CLOCK_ID(AUDIO_PLL1_CLK)
#define MQS2_CLK_ROOT_AUDIO_PLL2_CLK  CLOCK_ROOT(63U) | ROOT_MUX(2U) | CLOCK_ID(AUDIO_PLL2_CLK)
#define MQS2_CLK_ROOT_EXT_CLK         CLOCK_ROOT(63U) | ROOT_MUX(3U) | CLOCK_ID(EXT_CLK)

/* SAI2_CLK_ROOT */
#define SAI2_CLK_ROOT_OSC_24M_CLK     CLOCK_ROOT(64U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define SAI2_CLK_ROOT_AUDIO_PLL1_CLK  CLOCK_ROOT(64U) | ROOT_MUX(1U) | CLOCK_ID(AUDIO_PLL1_CLK)
#define SAI2_CLK_ROOT_AUDIO_PLL2_CLK  CLOCK_ROOT(64U) | ROOT_MUX(2U) | CLOCK_ID(AUDIO_PLL2_CLK)
#define SAI2_CLK_ROOT_EXT_CLK         CLOCK_ROOT(64U) | ROOT_MUX(3U) | CLOCK_ID(EXT_CLK)

/* NOC_APB_CLK_ROOT */
#define NOC_APB_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(65U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define NOC_APB_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(65U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define NOC_APB_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(65U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define NOC_APB_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(65U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* NOC_CLK_ROOT */
#define NOC_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(66U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define NOC_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(66U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define NOC_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(66U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define NOC_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(66U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* NPU_APB_CLK_ROOT */
#define NPU_APB_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(67U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define NPU_APB_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(67U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define NPU_APB_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(67U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define NPU_APB_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(67U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* NPU_CLK_ROOT */
#define NPU_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(68U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define NPU_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(68U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define NPU_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(68U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define NPU_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(68U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* CCM_CKO1_CLK_ROOT */
#define CCM_CKO1_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(69U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define CCM_CKO1_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(69U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define CCM_CKO1_CLK_ROOT_OSC_32K_CLK        CLOCK_ROOT(69U) | ROOT_MUX(2U) | CLOCK_ID(OSC_32K_CLK)
#define CCM_CKO1_CLK_ROOT_AUDIO_PLL1_CLK     CLOCK_ROOT(69U) | ROOT_MUX(3U) | CLOCK_ID(AUDIO_PLL1_CLK)

/* CCM_CKO2_CLK_ROOT */
#define CCM_CKO2_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(70U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define CCM_CKO2_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(70U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define CCM_CKO2_CLK_ROOT_OSC_32K_CLK        CLOCK_ROOT(70U) | ROOT_MUX(2U) | CLOCK_ID(OSC_32K_CLK)
#define CCM_CKO2_CLK_ROOT_VIDEO_PLL1_CLK     CLOCK_ROOT(70U) | ROOT_MUX(3U) | CLOCK_ID(VIDEO_PLL1_CLK)

/* CCM_CKO3_CLK_ROOT */
#define CCM_CKO3_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(71U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define CCM_CKO3_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(71U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define CCM_CKO3_CLK_ROOT_OSC_32K_CLK        CLOCK_ROOT(71U) | ROOT_MUX(2U) | CLOCK_ID(OSC_32K_CLK)
#define CCM_CKO3_CLK_ROOT_AUDIO_PLL2_CLK     CLOCK_ROOT(71U) | ROOT_MUX(3U) | CLOCK_ID(AUDIO_PLL2_CLK)

/* CCM_CKO4_CLK_ROOT */
#define CCM_CKO4_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(72U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define CCM_CKO4_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(72U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define CCM_CKO4_CLK_ROOT_OSC_32K_CLK        CLOCK_ROOT(72U) | ROOT_MUX(2U) | CLOCK_ID(OSC_32K_CLK)
#define CCM_CKO4_CLK_ROOT_VIDEO_PLL1_CLK     CLOCK_ROOT(72U) | ROOT_MUX(3U) | CLOCK_ID(VIDEO_PLL1_CLK)

/* VPU_APB_CLK_ROOT */
#define VPU_APB_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(73U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define VPU_APB_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(73U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define VPU_APB_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(73U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define VPU_APB_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(73U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* VPU_CLK_ROOT */
#define VPU_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(74U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define VPU_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(74U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define VPU_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(74U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define VPU_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(74U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* VPU_DSP_CLK_ROOT */
#define VPU_DSP_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(75U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define VPU_DSP_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(75U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define VPU_DSP_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(75U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define VPU_DSP_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(75U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* VPU_JPEG_CLK_ROOT */
#define VPU_JPEG_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(76U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define VPU_JPEG_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(76U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define VPU_JPEG_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(76U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define VPU_JPEG_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(76U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* AUDIO_XCVR_CLK_ROOT */
#define AUDIO_XCVR_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(77U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define AUDIO_XCVR_CLK_ROOT_SYS_PLL1_DFS0_CLK       CLOCK_ROOT(77U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define AUDIO_XCVR_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(77U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define AUDIO_XCVR_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(77U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* BUS_WAKEUP_CLK_ROOT */
#define BUS_WAKEUP_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(78U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define BUS_WAKEUP_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(78U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define BUS_WAKEUP_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(78U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define BUS_WAKEUP_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(78U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* CAN2_CLK_ROOT */
#define CAN2_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(79U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define CAN2_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(79U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define CAN2_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(79U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define CAN2_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(79U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* CAN3_CLK_ROOT */
#define CAN3_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(80U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define CAN3_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(80U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define CAN3_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(80U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define CAN3_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(80U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* CAN4_CLK_ROOT */
#define CAN4_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(81U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define CAN4_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(81U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define CAN4_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(81U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define CAN4_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(81U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* CAN5_CLK_ROOT */
#define CAN5_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(82U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define CAN5_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(82U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define CAN5_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(82U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define CAN5_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(82U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* FLEXIO1_CLK_ROOT */
#define FLEXIO1_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(83U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define FLEXIO1_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(83U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define FLEXIO1_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(83U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define FLEXIO1_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(83U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* FLEXIO2_CLK_ROOT */
#define FLEXIO2_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(84U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define FLEXIO2_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(84U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define FLEXIO2_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(84U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define FLEXIO2_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(84U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* FLEXSPI1_CLK_ROOT */
#define FLEXSPI1_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(85U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define FLEXSPI1_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(85U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define FLEXSPI1_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(85U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define FLEXSPI1_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(85U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* I3C2_CLK_ROOT */
#define I3C2_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(86U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define I3C2_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(86U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define I3C2_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(86U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define I3C2_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(86U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* I3C2_SLOW_CLK_ROOT */
#define I3C2_SLOW_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(87U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define I3C2_SLOW_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(87U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define I3C2_SLOW_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(87U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define I3C2_SLOW_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(87U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPI2C3_CLK_ROOT */
#define LPI2C3_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(88U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPI2C3_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(88U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPI2C3_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(88U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPI2C3_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(88U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPI2C4_CLK_ROOT */
#define LPI2C4_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(89U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPI2C4_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(89U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPI2C4_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(89U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPI2C4_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(89U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPI2C5_CLK_ROOT */
#define LPI2C5_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(90U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPI2C5_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(90U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPI2C5_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(90U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPI2C5_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(90U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPI2C6_CLK_ROOT */
#define LPI2C6_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(91U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPI2C6_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(91U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPI2C6_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(91U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPI2C6_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(91U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPI2C7_CLK_ROOT */
#define LPI2C7_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(92U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPI2C7_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(92U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPI2C7_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(92U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPI2C7_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(92U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPI2C8_CLK_ROOT */
#define LPI2C8_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(93U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPI2C8_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(93U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPI2C8_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(93U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPI2C8_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(93U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPSPI3_CLK_ROOT */
#define LPSPI3_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(94U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPSPI3_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(94U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPSPI3_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(94U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPSPI3_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(94U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPSPI4_CLK_ROOT */
#define LPSPI4_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(95U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPSPI4_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(95U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPSPI4_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(95U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPSPI4_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(95U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPSPI5_CLK_ROOT */
#define LPSPI5_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(96U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPSPI5_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(96U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPSPI5_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(96U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPSPI5_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(96U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPSPI6_CLK_ROOT */
#define LPSPI6_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(97U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPSPI6_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(97U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPSPI6_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(97U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPSPI6_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(97U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPSPI7_CLK_ROOT */
#define LPSPI7_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(98U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPSPI7_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(98U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPSPI7_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(98U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPSPI7_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(98U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPSPI8_CLK_ROOT */
#define LPSPI8_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(99U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPSPI8_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(99U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPSPI8_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(99U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPSPI8_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(99U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPTMR2_CLK_ROOT */
#define LPTMR2_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(100U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPTMR2_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(100U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPTMR2_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(100U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPTMR2_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(100U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPUART3_CLK_ROOT */
#define LPUART3_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(101U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPUART3_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(101U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPUART3_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(101U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPUART3_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(101U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPUART4_CLK_ROOT */
#define LPUART4_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(102U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPUART4_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(102U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPUART4_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(102U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPUART4_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(102U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPUART5_CLK_ROOT */
#define LPUART5_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(103U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPUART5_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(103U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPUART5_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(103U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPUART5_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(103U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPUART6_CLK_ROOT */
#define LPUART6_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(104U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPUART6_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(104U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPUART6_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(104U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPUART6_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(104U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPUART7_CLK_ROOT */
#define LPUART7_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(105U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPUART7_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(105U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPUART7_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(105U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPUART7_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(105U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* LPUART8_CLK_ROOT */
#define LPUART8_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(106U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define LPUART8_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(106U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define LPUART8_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(106U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define LPUART8_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(106U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* SAI3_CLK_ROOT */
#define SAI3_CLK_ROOT_OSC_24M_CLK     CLOCK_ROOT(107U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define SAI3_CLK_ROOT_AUDIO_PLL1_CLK  CLOCK_ROOT(107U) | ROOT_MUX(1U) | CLOCK_ID(AUDIO_PLL1_CLK)
#define SAI3_CLK_ROOT_AUDIO_PLL2_CLK  CLOCK_ROOT(107U) | ROOT_MUX(2U) | CLOCK_ID(AUDIO_PLL2_CLK)
#define SAI3_CLK_ROOT_EXT_CLK         CLOCK_ROOT(107U) | ROOT_MUX(3U) | CLOCK_ID(EXT_CLK)

/* SAI4_CLK_ROOT */
#define SAI4_CLK_ROOT_OSC_24M_CLK     CLOCK_ROOT(108U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define SAI4_CLK_ROOT_AUDIO_PLL1_CLK  CLOCK_ROOT(108U) | ROOT_MUX(1U) | CLOCK_ID(AUDIO_PLL1_CLK)
#define SAI4_CLK_ROOT_AUDIO_PLL2_CLK  CLOCK_ROOT(108U) | ROOT_MUX(2U) | CLOCK_ID(AUDIO_PLL2_CLK)
#define SAI4_CLK_ROOT_EXT_CLK         CLOCK_ROOT(108U) | ROOT_MUX(3U) | CLOCK_ID(EXT_CLK)

/* SAI5_CLK_ROOT */
#define SAI5_CLK_ROOT_OSC_24M_CLK     CLOCK_ROOT(109U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define SAI5_CLK_ROOT_AUDIO_PLL1_CLK  CLOCK_ROOT(109U) | ROOT_MUX(1U) | CLOCK_ID(AUDIO_PLL1_CLK)
#define SAI5_CLK_ROOT_AUDIO_PLL2_CLK  CLOCK_ROOT(109U) | ROOT_MUX(2U) | CLOCK_ID(AUDIO_PLL2_CLK)
#define SAI5_CLK_ROOT_EXT_CLK         CLOCK_ROOT(109U) | ROOT_MUX(3U) | CLOCK_ID(EXT_CLK)

/* SPDIF_CLK_ROOT */
#define SPDIF_CLK_ROOT_OSC_24M_CLK     CLOCK_ROOT(110U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define SPDIF_CLK_ROOT_AUDIO_PLL1_CLK  CLOCK_ROOT(110U) | ROOT_MUX(1U) | CLOCK_ID(AUDIO_PLL1_CLK)
#define SPDIF_CLK_ROOT_AUDIO_PLL2_CLK  CLOCK_ROOT(110U) | ROOT_MUX(2U) | CLOCK_ID(AUDIO_PLL2_CLK)
#define SPDIF_CLK_ROOT_EXT_CLK         CLOCK_ROOT(110U) | ROOT_MUX(3U) | CLOCK_ID(EXT_CLK)

/* SWO_TRACE_CLK_ROOT */
#define SWO_TRACE_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(111U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define SWO_TRACE_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(111U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define SWO_TRACE_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(111U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define SWO_TRACE_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(111U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* TPM4_CLK_ROOT */
#define TPM4_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(112U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define TPM4_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(112U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define TPM4_CLK_ROOT_AUDIO_PLL1_CLK     CLOCK_ROOT(112U) | ROOT_MUX(2U) | CLOCK_ID(AUDIO_PLL1_CLK)
#define TPM4_CLK_ROOT_EXT_CLK            CLOCK_ROOT(112U) | ROOT_MUX(3U) | CLOCK_ID(EXT_CLK)

/* TPM5_CLK_ROOT */
#define TPM5_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(113U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define TPM5_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(113U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define TPM5_CLK_ROOT_AUDIO_PLL1_CLK     CLOCK_ROOT(113U) | ROOT_MUX(2U) | CLOCK_ID(AUDIO_PLL1_CLK)
#define TPM5_CLK_ROOT_EXT_CLK            CLOCK_ROOT(113U) | ROOT_MUX(3U) | CLOCK_ID(EXT_CLK)

/* TPM6_CLK_ROOT */
#define TPM6_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(114U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define TPM6_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(114U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define TPM6_CLK_ROOT_AUDIO_PLL1_CLK     CLOCK_ROOT(114U) | ROOT_MUX(2U) | CLOCK_ID(AUDIO_PLL1_CLK)
#define TPM6_CLK_ROOT_EXT_CLK            CLOCK_ROOT(114U) | ROOT_MUX(3U) | CLOCK_ID(EXT_CLK)

/* TSTMR2_CLK_ROOT */
#define TSTMR2_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(115U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define TSTMR2_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(115U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define TSTMR2_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(115U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define TSTMR2_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(115U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* USB_PHY_BURUNIN_CLK_ROOT */
#define USB_PHY_BURUNIN_CLK_ROOT_OSC_24M_CLK             CLOCK_ROOT(116U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define USB_PHY_BURUNIN_CLK_ROOT_SYS_PLL1_DFS0_DIV2_CLK  CLOCK_ROOT(116U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_DIV2_CLK)
#define USB_PHY_BURUNIN_CLK_ROOT_SYS_PLL1_DFS1_DIV2_CLK  CLOCK_ROOT(116U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_DIV2_CLK)
#define USB_PHY_BURUNIN_CLK_ROOT_FRO_CLK                 CLOCK_ROOT(116U) | ROOT_MUX(3U) | CLOCK_ID(FRO_CLK)

/* USDHC1_CLK_ROOT */
#define USDHC1_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(117U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define USDHC1_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(117U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define USDHC1_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(117U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define USDHC1_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(117U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* USDHC2_CLK_ROOT */
#define USDHC2_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(118U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define USDHC2_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(118U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define USDHC2_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(118U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define USDHC2_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(118U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* USDHC3_CLK_ROOT */
#define USDHC3_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(119U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define USDHC3_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(119U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define USDHC3_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(119U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define USDHC3_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(119U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* V2X_PK_CLK_ROOT */
#define V2X_PK_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(120U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define V2X_PK_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(120U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define V2X_PK_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(120U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define V2X_PK_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(120U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* WAKEUP_AXI_CLK_ROOT */
#define WAKEUP_AXI_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(121U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define WAKEUP_AXI_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(121U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define WAKEUP_AXI_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(121U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define WAKEUP_AXI_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(121U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

/* XSPI_SLV_ROOT_CLK_ROOT */
#define XSPI_SLV_ROOT_CLK_ROOT_OSC_24M_CLK        CLOCK_ROOT(122U) | ROOT_MUX(0U) | CLOCK_ID(OSC_24M_CLK)
#define XSPI_SLV_ROOT_CLK_ROOT_SYS_PLL1_DFS0_CLK  CLOCK_ROOT(122U) | ROOT_MUX(1U) | CLOCK_ID(SYS_PLL1_DFS0_CLK)
#define XSPI_SLV_ROOT_CLK_ROOT_SYS_PLL1_DFS1_CLK  CLOCK_ROOT(122U) | ROOT_MUX(2U) | CLOCK_ID(SYS_PLL1_DFS1_CLK)
#define XSPI_SLV_ROOT_CLK_ROOT_SYS_PLL1_DFS2_CLK  CLOCK_ROOT(122U) | ROOT_MUX(3U) | CLOCK_ID(SYS_PLL1_DFS2_CLK)

#endif /* __ARCH_ARM_SRC_IMX9_HARDWARE_IMX93_IMX93_EDMA_H */