/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.service.resources;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.crawl.CrawlDbReader;
import org.apache.nutch.fetcher.FetchNode;
import org.apache.nutch.fetcher.FetchNodeDb;
import org.apache.nutch.service.model.request.DbQuery;
import org.apache.nutch.service.model.response.FetchNodeDbInfo;
import org.apache.nutch.service.resources.AbstractResource;

@Path(value="/db")
public class DbResource
extends AbstractResource {
    @POST
    @Path(value="/crawldb")
    @Consumes(value={"application/json"})
    public Response readdb(DbQuery dbQuery) {
        if (dbQuery == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Configuration conf = this.configManager.get(dbQuery.getConfId());
        if (conf == null) {
            conf = this.configManager.get("default");
        }
        if (dbQuery.getCrawlId() == null || dbQuery.getType() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String type = dbQuery.getType();
        if (type.equalsIgnoreCase("stats")) {
            return this.crawlDbStats(conf, dbQuery.getArgs(), dbQuery.getCrawlId());
        }
        if (type.equalsIgnoreCase("dump")) {
            return this.crawlDbDump(conf, dbQuery.getArgs(), dbQuery.getCrawlId());
        }
        if (type.equalsIgnoreCase("topN")) {
            return this.crawlDbTopN(conf, dbQuery.getArgs(), dbQuery.getCrawlId());
        }
        if (type.equalsIgnoreCase("url")) {
            return this.crawlDbUrl(conf, dbQuery.getArgs(), dbQuery.getCrawlId());
        }
        return null;
    }

    @GET
    @Path(value="/fetchdb")
    public List<FetchNodeDbInfo> fetchDb(@DefaultValue(value="0") @QueryParam(value="to") int to, @DefaultValue(value="0") @QueryParam(value="from") int from) {
        ArrayList<FetchNodeDbInfo> listOfFetchedNodes = new ArrayList<FetchNodeDbInfo>();
        Map<Integer, FetchNode> fetchNodedbMap = FetchNodeDb.getInstance().getFetchNodeDb();
        if (to == 0 || to > fetchNodedbMap.size()) {
            to = fetchNodedbMap.size();
        }
        for (int i = from; i <= to; ++i) {
            if (!fetchNodedbMap.containsKey(i)) continue;
            FetchNode node = fetchNodedbMap.get(i);
            FetchNodeDbInfo fdbInfo = new FetchNodeDbInfo();
            fdbInfo.setUrl(node.getUrl().toString());
            fdbInfo.setStatus(node.getStatus());
            fdbInfo.setNumOfOutlinks(node.getOutlinks().length);
            fdbInfo.setChildNodes(node.getOutlinks());
            listOfFetchedNodes.add(fdbInfo);
        }
        return listOfFetchedNodes;
    }

    private Response crawlDbStats(Configuration conf, Map<String, String> args, String crawlId) {
        CrawlDbReader dbr = new CrawlDbReader();
        try {
            return Response.ok((Object)dbr.query(args, conf, "stats", crawlId)).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.serverError().entity((Object)e.getMessage()).type("text/plain").build();
        }
    }

    @Produces(value={"application/octet-stream"})
    private Response crawlDbDump(Configuration conf, Map<String, String> args, String crawlId) {
        CrawlDbReader dbr = new CrawlDbReader();
        try {
            return Response.ok((Object)dbr.query(args, conf, "dump", crawlId), (String)"application/octet-stream").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.serverError().entity((Object)e.getMessage()).type("text/plain").build();
        }
    }

    @Produces(value={"application/octet-stream"})
    private Response crawlDbTopN(Configuration conf, Map<String, String> args, String crawlId) {
        CrawlDbReader dbr = new CrawlDbReader();
        try {
            return Response.ok((Object)dbr.query(args, conf, "topN", crawlId), (String)"application/octet-stream").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.serverError().entity((Object)e.getMessage()).type("text/plain").build();
        }
    }

    private Response crawlDbUrl(Configuration conf, Map<String, String> args, String crawlId) {
        CrawlDbReader dbr = new CrawlDbReader();
        try {
            return Response.ok((Object)dbr.query(args, conf, "url", crawlId)).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.serverError().entity((Object)e.getMessage()).type("text/plain").build();
        }
    }
}

