/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.service.impl;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.service.ConfManager;
import org.apache.nutch.service.JobManager;
import org.apache.nutch.service.impl.JobFactory;
import org.apache.nutch.service.impl.JobWorker;
import org.apache.nutch.service.impl.NutchServerPoolExecutor;
import org.apache.nutch.service.model.request.JobConfig;
import org.apache.nutch.service.model.response.JobInfo;
import org.apache.nutch.util.NutchTool;

public class JobManagerImpl
implements JobManager {
    private JobFactory jobFactory;
    private NutchServerPoolExecutor executor;
    private ConfManager configManager;

    public JobManagerImpl(JobFactory jobFactory, ConfManager configManager, NutchServerPoolExecutor executor) {
        this.jobFactory = jobFactory;
        this.configManager = configManager;
        this.executor = executor;
    }

    @Override
    public JobInfo create(JobConfig jobConfig) {
        if (jobConfig.getArgs() == null) {
            throw new IllegalArgumentException("Arguments cannot be null!");
        }
        Configuration conf = this.cloneConfiguration(jobConfig.getConfId());
        NutchTool tool = this.createTool(jobConfig, conf);
        JobWorker worker = new JobWorker(jobConfig, conf, tool);
        this.executor.execute(worker);
        this.executor.purge();
        return worker.getInfo();
    }

    private Configuration cloneConfiguration(String confId) {
        Configuration conf = this.configManager.get(confId);
        if (conf == null) {
            throw new IllegalArgumentException("Unknown confId " + confId);
        }
        return new Configuration(conf);
    }

    @Override
    public Collection<JobInfo> list(String crawlId, JobInfo.State state) {
        if (state == null || state == JobInfo.State.ANY) {
            return this.executor.getAllJobs();
        }
        if (state == JobInfo.State.RUNNING || state == JobInfo.State.IDLE) {
            return this.executor.getJobRunning();
        }
        return this.executor.getJobHistory();
    }

    @Override
    public JobInfo get(String crawlId, String jobId) {
        return this.executor.getInfo(jobId);
    }

    @Override
    public boolean abort(String crawlId, String id) {
        return this.executor.findWorker(id).killJob();
    }

    @Override
    public boolean stop(String crawlId, String id) {
        return this.executor.findWorker(id).stopJob();
    }

    private NutchTool createTool(JobConfig jobConfig, Configuration conf) {
        if (StringUtils.isNotBlank((CharSequence)jobConfig.getJobClassName())) {
            return this.jobFactory.createToolByClassName(jobConfig.getJobClassName(), conf);
        }
        return this.jobFactory.createToolByType(jobConfig.getType(), conf);
    }
}

