/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class Inlink
implements Writable {
    private String fromUrl;
    private String anchor;
    private MapWritable md = null;

    public Inlink() {
    }

    public Inlink(String fromUrl, String anchor) {
        this.fromUrl = fromUrl;
        this.anchor = anchor;
    }

    public void readFields(DataInput in) throws IOException {
        this.fromUrl = Text.readString((DataInput)in);
        this.anchor = Text.readString((DataInput)in);
        boolean hasMD = in.readBoolean();
        if (hasMD) {
            this.md = new MapWritable();
            this.md.readFields(in);
        } else {
            this.md = null;
        }
    }

    public static void skip(DataInput in) throws IOException {
        Text.skip((DataInput)in);
        Text.skip((DataInput)in);
        boolean hasMD = in.readBoolean();
        if (hasMD) {
            MapWritable metadata = new MapWritable();
            metadata.readFields(in);
        }
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.fromUrl);
        Text.writeString((DataOutput)out, (String)this.anchor);
        if (this.md != null && this.md.size() > 0) {
            out.writeBoolean(true);
            this.md.write(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public static Inlink read(DataInput in) throws IOException {
        Inlink inlink = new Inlink();
        inlink.readFields(in);
        return inlink;
    }

    public String getFromUrl() {
        return this.fromUrl;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public MapWritable getMetadata() {
        return this.md;
    }

    public void setMetadata(MapWritable md) {
        this.md = md;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Inlink)) {
            return false;
        }
        Inlink other = (Inlink)o;
        return this.fromUrl.equals(other.fromUrl) && this.anchor.equals(other.anchor);
    }

    public int hashCode() {
        return this.fromUrl.hashCode() ^ this.anchor.hashCode();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.md != null && !this.md.isEmpty()) {
            for (Map.Entry e : this.md.entrySet()) {
                buffer.append(" ");
                buffer.append(e.getKey());
                buffer.append(": ");
                buffer.append(e.getValue());
            }
        }
        return "fromUrl: " + this.fromUrl + " anchor: " + this.anchor + " metadata: " + buffer.toString();
    }
}

