/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.document;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.termvectors.MultiTermVectorsRequest;
import org.opensearch.action.termvectors.MultiTermVectorsResponse;
import org.opensearch.action.termvectors.TermVectorsRequest;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.Strings;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.rest.action.document.RestTermVectorsAction;

public class RestMultiTermVectorsAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestTermVectorsAction.class);
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in multi term vector requests is deprecated.";

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_mtermvectors"), new RestHandler.Route(RestRequest.Method.POST, "/_mtermvectors"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_mtermvectors"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_mtermvectors"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/{type}/_mtermvectors"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/{type}/_mtermvectors")));
    }

    @Override
    public String getName() {
        return "document_multi_term_vectors_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MultiTermVectorsRequest multiTermVectorsRequest = new MultiTermVectorsRequest();
        TermVectorsRequest template = (TermVectorsRequest)new TermVectorsRequest().index(request.param("index"));
        if (request.hasParam("type")) {
            deprecationLogger.deprecate("mtermvectors_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
            template.type(request.param("type"));
        } else {
            template.type("_doc");
        }
        RestTermVectorsAction.readURIParameters(template, request);
        multiTermVectorsRequest.ids(Strings.commaDelimitedListToStringArray(request.param("ids")));
        request.withContentOrSourceParamParserOrNull((CheckedConsumer<XContentParser, IOException>)((CheckedConsumer)p -> multiTermVectorsRequest.add(template, (XContentParser)p)));
        return channel -> client.multiTermVectors(multiTermVectorsRequest, new RestToXContentListener<MultiTermVectorsResponse>((RestChannel)channel));
    }
}

