/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.util.Calendar;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.parser.RegexFTPFileEntryParserImpl;

public class UnixFTPEntryParser
extends RegexFTPFileEntryParserImpl {
    private static final String MONTHS = "(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)";
    private static final String REGEX = "([bcdlfmpSs-])(((r|-)(w|-)([xsStTL-]))((r|-)(w|-)([xsStTL-]))((r|-)(w|-)([xsStTL-])))\\s+(\\d+)\\s+(\\S+)\\s+(?:(\\S+)\\s+)?(\\d+)\\s+(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\\s+((?:[0-9])|(?:[0-2][0-9])|(?:3[0-1]))\\s+((\\d\\d\\d\\d)|((?:[01]\\d)|(?:2[0123])|(?:[1-9])):([012345]\\d))\\s+(\\S+)(\\s*.*)";

    public UnixFTPEntryParser() {
        super(REGEX);
    }

    public FTPFile parseFTPEntry(String entry) {
        FTPFile file = new FTPFile();
        file.setRawListing(entry);
        boolean isDevice = false;
        if (this.matches(entry)) {
            int type;
            String typeStr = this.group(1);
            String hardLinkCount = this.group(15);
            String usr = this.group(16);
            String grp = this.group(17);
            String filesize = this.group(18);
            String mo = this.group(19);
            String da = this.group(20);
            String yr = this.group(22);
            String hr = this.group(23);
            String min = this.group(24);
            String name = this.group(25);
            String endtoken = this.group(26);
            switch (typeStr.charAt(0)) {
                case 'd': {
                    type = 1;
                    break;
                }
                case 'l': {
                    type = 2;
                    break;
                }
                case 'b': 
                case 'c': {
                    isDevice = true;
                }
                case '-': 
                case 'f': {
                    type = 0;
                    break;
                }
                default: {
                    type = 3;
                }
            }
            file.setType(type);
            int g = 4;
            int access = 0;
            while (access < 3) {
                file.setPermission(access, 0, !this.group(g).equals("-"));
                file.setPermission(access, 1, !this.group(g + 1).equals("-"));
                String execPerm = this.group(g + 2);
                if (!execPerm.equals("-") && !Character.isUpperCase(execPerm.charAt(0))) {
                    file.setPermission(access, 2, true);
                } else {
                    file.setPermission(access, 2, false);
                }
                ++access;
                g += 4;
            }
            if (!isDevice) {
                try {
                    file.setHardLinkCount(Integer.parseInt(hardLinkCount));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            file.setUser(usr);
            file.setGroup(grp);
            try {
                file.setSize(Integer.parseInt(filesize));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            Calendar cal = Calendar.getInstance();
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(11, 0);
            try {
                int pos = MONTHS.indexOf(mo);
                int month = pos / 4;
                if (null != yr) {
                    cal.set(1, Integer.parseInt(yr));
                } else {
                    int year = cal.get(1);
                    if (cal.get(2) < month) {
                        --year;
                    }
                    cal.set(1, year);
                    cal.set(11, Integer.parseInt(hr));
                    cal.set(12, Integer.parseInt(min));
                }
                cal.set(2, month);
                cal.set(5, Integer.parseInt(da));
                file.setTimestamp(cal);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (null == endtoken) {
                file.setName(name);
            } else {
                name = name + endtoken;
                if (type == 2) {
                    int end = name.indexOf(" -> ");
                    if (end == -1) {
                        file.setName(name);
                    } else {
                        file.setName(name.substring(0, end));
                        file.setLink(name.substring(end + 4));
                    }
                } else {
                    file.setName(name);
                }
            }
            return file;
        }
        return null;
    }
}

