/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.binsearch.impl.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.input.CountingInputStream;
import org.archive.util.binsearch.impl.HTTPSeekableLineReader;

public class HTTPURLConnSLR
extends HTTPSeekableLineReader {
    protected String url;
    protected int connTimeout;
    protected int readTimeout;
    protected HttpURLConnection httpUrlConn = null;
    protected CountingInputStream cin = null;

    public HTTPURLConnSLR(String url, int connTimeout, int socketTimeout) {
        this.url = url;
        this.connTimeout = connTimeout;
        this.readTimeout = socketTimeout;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public long getSize() throws IOException {
        return 0L;
    }

    @Override
    public String getHeaderValue(String headerName) {
        if (this.httpUrlConn != null) {
            this.httpUrlConn.getHeaderField(headerName);
        }
        return null;
    }

    @Override
    protected InputStream doSeekLoad(long offset, int maxLength) throws IOException {
        URL theUrl = new URL(this.url);
        URLConnection connection = theUrl.openConnection();
        this.httpUrlConn = (HttpURLConnection)connection;
        connection.setConnectTimeout(this.connTimeout);
        connection.setReadTimeout(this.readTimeout);
        String rangeHeader = HTTPURLConnSLR.makeRangeHeader(offset, maxLength);
        if (rangeHeader != null) {
            this.httpUrlConn.addRequestProperty("Range", rangeHeader);
        }
        if (this.isNoKeepAlive()) {
            this.httpUrlConn.addRequestProperty("Connection", "close");
        }
        if (this.getCookie() != null) {
            this.httpUrlConn.addRequestProperty("Cookie", this.cookie);
        }
        this.httpUrlConn.connect();
        int code = this.httpUrlConn.getResponseCode();
        this.connectedUrl = this.httpUrlConn.getURL().toString();
        if (code != 206 && code != 200) {
            throw new HTTPSeekableLineReader.BadHttpStatusException(code, this.connectedUrl + " " + rangeHeader);
        }
        InputStream is = this.httpUrlConn.getInputStream();
        this.cin = new CountingInputStream(is);
        return this.cin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws IOException {
        if (this.httpUrlConn == null) {
            return;
        }
        try {
            long bytesRead;
            long contentLength = this.httpUrlConn.getContentLength();
            long l = bytesRead = this.cin != null ? this.cin.getByteCount() : 0L;
            if (contentLength > 0L && contentLength == bytesRead) {
                try {
                    this.cin.close();
                }
                catch (IOException e) {
                    this.httpUrlConn.disconnect();
                }
            } else {
                this.httpUrlConn.disconnect();
            }
            this.httpUrlConn = null;
        }
        finally {
            if (this.httpUrlConn != null) {
                this.httpUrlConn.disconnect();
                this.httpUrlConn = null;
            }
        }
        this.cin = null;
        this.is = null;
        this.br = null;
    }
}

