/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import org.archive.format.gzip.GZIPConstants;
import org.archive.format.gzip.GZIPFExtraRecords;
import org.archive.format.gzip.GZIPFormatException;
import org.archive.format.gzip.GZIPHeader;
import org.archive.format.gzip.GZIPStaticHeader;
import org.archive.util.ByteOp;
import org.archive.util.io.CRCInputStream;

public class GZIPDecoder
implements GZIPConstants {
    public static final long SEARCH_EOF_AT_START = Long.MIN_VALUE;
    private int maxNameSize = 1024;
    private int maxCommentSize = 1024;

    public GZIPDecoder() {
    }

    public GZIPDecoder(int max) {
        this.maxNameSize = max;
        this.maxCommentSize = max;
    }

    public GZIPDecoder(int maxNameSize, int maxCommentSize) {
        this.maxNameSize = maxNameSize;
        this.maxCommentSize = maxCommentSize;
    }

    public boolean alignedAtEOF(long skipped) {
        return skipped == Long.MIN_VALUE;
    }

    public long alignOnMagic3(InputStream is) throws IOException {
        long bytesSkipped = 0L;
        byte[] lookahead = new byte[3];
        int keep = 0;
        while (true) {
            if (keep == 2) {
                lookahead[0] = lookahead[1];
                lookahead[1] = lookahead[2];
            } else if (keep == 1) {
                lookahead[0] = lookahead[2];
            }
            int amt = is.read(lookahead, keep, 3 - keep);
            if (amt == -1) {
                long skippedBeforeEOF = bytesSkipped + (long)keep;
                if (skippedBeforeEOF == 0L) {
                    return Long.MIN_VALUE;
                }
                return -1L * skippedBeforeEOF;
            }
            if (lookahead[0] != 31) {
                keep = lookahead[1] == 31 && lookahead[2] == 139 ? 2 : (lookahead[2] == 31 ? 1 : 0);
                bytesSkipped += (long)(3 - keep);
                continue;
            }
            if ((lookahead[1] & 0xFF) != 139) {
                keep = lookahead[2] == 31 ? 1 : 0;
                bytesSkipped += (long)(3 - keep);
                continue;
            }
            if (GZIPHeader.isValidCompressionMethod(lookahead[2])) break;
            if (lookahead[2] == 31) {
                keep = 1;
            }
            bytesSkipped += (long)(3 - keep);
        }
        return bytesSkipped;
    }

    public GZIPHeader parseHeader(InputStream origIn) throws GZIPFormatException, IOException {
        return this.parseHeader(origIn, false);
    }

    public GZIPHeader parseHeader(InputStream origIn, boolean assume1st3) throws GZIPFormatException, IOException {
        GZIPHeader header = null;
        CRCInputStream is = null;
        GZIPStaticHeader staticHeader = null;
        if (assume1st3) {
            CRC32 crc = new CRC32();
            crc.update(GZIPStaticHeader.DEFAULT_HEADER_DATA, 0, 3);
            is = new CRCInputStream(origIn, crc);
            staticHeader = new GZIPStaticHeader(is, true);
        } else {
            is = new CRCInputStream(origIn);
            staticHeader = new GZIPStaticHeader(is);
        }
        header = new GZIPHeader(staticHeader);
        if (staticHeader.isFExtraSet()) {
            header.records = new GZIPFExtraRecords(is);
        }
        if (staticHeader.isFNameSet()) {
            if (this.maxNameSize > 0) {
                header.fileName = ByteOp.readToNull(is, this.maxNameSize);
                header.fileNameLength = header.fileName.length;
            } else {
                header.fileName = null;
                header.fileNameLength = ByteOp.discardToNull(is);
            }
        }
        if (staticHeader.isFCommentSet()) {
            if (this.maxCommentSize > 0) {
                header.comment = ByteOp.readToNull(is, this.maxCommentSize);
                header.commentLength = header.comment.length;
            } else {
                header.comment = null;
                header.commentLength = ByteOp.discardToNull(is);
            }
        }
        if (staticHeader.isFHCRCSet()) {
            header.crc = ByteOp.readShort(is);
            int wantCRC16 = (int)(is.getCRCValue() & 0xFFFFL);
            if (wantCRC16 != header.crc) {
                throw new GZIPFormatException("HEADER CRC ERROR");
            }
        }
        return header;
    }
}

