/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.arc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.archive.format.arc.FiledescRecord;

public class FiledescRecordParser {
    public boolean strict = false;

    public FiledescRecord parse(InputStream is) throws IOException {
        FiledescRecord rec = new FiledescRecord();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line = br.readLine();
            this.parseLine1(rec, line);
            line = br.readLine();
            if (line == null) {
                if (this.strict) {
                    throw new IOException("No format line");
                }
                rec.setFormat("Unknown");
            } else {
                rec.setFormat(line);
            }
            line = br.readLine();
            while (line != null) {
                this.addMetaDataLine(rec, line);
                line = br.readLine();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return rec;
    }

    private void addMetaDataLine(FiledescRecord rec, String metaLine) {
        int endOfTag;
        if (metaLine.startsWith("<") && (endOfTag = metaLine.indexOf(62)) > 0) {
            String name = metaLine.substring(1, endOfTag);
            String tail = "</" + name + ">";
            if (metaLine.endsWith(tail)) {
                int nameLength = name.length();
                int wrapperLength = nameLength * 2 + 5;
                int valueLength = metaLine.length() - wrapperLength;
                if (valueLength > 0) {
                    String value = metaLine.substring(nameLength + 2, nameLength + valueLength + 2);
                    rec.addMetaData(name, value);
                }
            }
        }
    }

    private void parseLine1(FiledescRecord rec, String line1) throws IOException {
        if (line1 == null) {
            if (this.strict) {
                throw new IOException("Empty filedesc record");
            }
            rec.setMajorVersion(0);
            rec.setMinorVersion(0);
            rec.setOrganization("Unknown");
            return;
        }
        String[] parts = line1.split(" ");
        if (parts.length < 3) {
            if (this.strict) {
                throw new IOException("Bad Filedesc line 1:" + line1);
            }
            rec.setOrganization(line1);
            if (parts.length < 2) {
                rec.setMinorVersion(0);
            } else {
                rec.setMinorVersion(this.parseIntOrVal(parts[1], 0));
            }
            if (parts.length < 1) {
                rec.setMajorVersion(0);
            } else {
                rec.setMajorVersion(this.parseIntOrVal(parts[0], 0));
            }
        } else {
            if (parts.length == 3) {
                rec.setOrganization(parts[2]);
            } else {
                StringBuilder sb = new StringBuilder(line1.length());
                for (int i = 2; i < parts.length; ++i) {
                    if (i > 2) {
                        sb.append(" ");
                    }
                    sb.append(parts[i]);
                    rec.setOrganization(sb.toString());
                }
            }
            rec.setMajorVersion(this.parseIntOrVal(parts[0], 0));
            rec.setMinorVersion(this.parseIntOrVal(parts[1], 0));
        }
    }

    private int parseIntOrVal(String string, int val) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return val;
        }
    }
}

