/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.configuration.json;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.controller.flow.VersionedDataflow;
import org.apache.nifi.controller.flow.VersionedFlowEncodingVersion;
import org.apache.nifi.flow.Bundle;
import org.apache.nifi.flow.ComponentType;
import org.apache.nifi.flow.ConnectableComponent;
import org.apache.nifi.flow.PortType;
import org.apache.nifi.flow.Position;
import org.apache.nifi.flow.ScheduledState;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedConnection;
import org.apache.nifi.flow.VersionedControllerService;
import org.apache.nifi.flow.VersionedFunnel;
import org.apache.nifi.flow.VersionedPort;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedProcessor;
import org.apache.nifi.flow.VersionedRemoteGroupPort;
import org.apache.nifi.flow.VersionedRemoteProcessGroup;
import org.apache.nifi.flow.VersionedReportingTask;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.minifi.commons.api.MiNiFiProperties;
import org.apache.nifi.minifi.toolkit.configuration.json.ComponentPropertyProvider;
import org.apache.nifi.minifi.toolkit.schema.ComponentStatusRepositorySchema;
import org.apache.nifi.minifi.toolkit.schema.ConfigSchema;
import org.apache.nifi.minifi.toolkit.schema.ConnectionSchema;
import org.apache.nifi.minifi.toolkit.schema.ContentRepositorySchema;
import org.apache.nifi.minifi.toolkit.schema.ControllerServiceSchema;
import org.apache.nifi.minifi.toolkit.schema.CorePropertiesSchema;
import org.apache.nifi.minifi.toolkit.schema.FlowFileRepositorySchema;
import org.apache.nifi.minifi.toolkit.schema.FunnelSchema;
import org.apache.nifi.minifi.toolkit.schema.PortSchema;
import org.apache.nifi.minifi.toolkit.schema.ProcessGroupSchema;
import org.apache.nifi.minifi.toolkit.schema.ProcessorSchema;
import org.apache.nifi.minifi.toolkit.schema.ProvenanceRepositorySchema;
import org.apache.nifi.minifi.toolkit.schema.RemotePortSchema;
import org.apache.nifi.minifi.toolkit.schema.RemoteProcessGroupSchema;
import org.apache.nifi.minifi.toolkit.schema.ReportingSchema;
import org.apache.nifi.minifi.toolkit.schema.SwapSchema;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchemaWithIdAndName;
import org.apache.nifi.scheduling.ExecutionNode;

public class ConfigSchemaToVersionedDataFlowTransformer {
    private static final String DEFAULT_FLOW_FILE_EXPIRATION = "0 sec";
    private static final String DEFAULT_BACK_PRESSURE_DATA_SIZE_THRESHOLD = "1 GB";
    private static final String FLOW_FILE_CONCURRENCY = "UNBOUNDED";
    private static final String FLOW_FILE_OUTBOUND_POLICY = "STREAM_WHEN_AVAILABLE";
    private static final long DEFAULT_BACK_PRESSURE_OBJECT_THRESHOLD = 10000L;
    private static final Position DEFAULT_POSITION = new Position(0.0, 0.0);
    private final ConfigSchema configSchema;
    private final ComponentPropertyProvider componentPropertyProvider;

    public ConfigSchemaToVersionedDataFlowTransformer(ConfigSchema configSchema) {
        this.configSchema = configSchema;
        this.componentPropertyProvider = new ComponentPropertyProvider(configSchema);
    }

    public Map<String, String> extractProperties() {
        CorePropertiesSchema coreProperties = this.configSchema.getCoreProperties();
        FlowFileRepositorySchema flowFileRepositoryProperties = this.configSchema.getFlowfileRepositoryProperties();
        ContentRepositorySchema contentRepositoryProperties = this.configSchema.getContentRepositoryProperties();
        ProvenanceRepositorySchema provenanceRepositoryProperties = this.configSchema.getProvenanceRepositorySchema();
        ComponentStatusRepositorySchema componentStatusRepositoryProperties = this.configSchema.getComponentStatusRepositoryProperties();
        SwapSchema swapProperties = this.configSchema.getFlowfileRepositoryProperties().getSwapProperties();
        return Stream.concat(Stream.of(Map.entry(MiNiFiProperties.NIFI_MINIFI_FLOW_MAX_CONCURRENT_THREADS.getKey(), coreProperties.getMaxConcurrentThreads().toString()), Map.entry("nifi.flowcontroller.graceful.shutdown.period", coreProperties.getFlowControllerGracefulShutdownPeriod()), Map.entry("nifi.flowservice.writedelay.interval", coreProperties.getFlowServiceWriteDelayInterval()), Map.entry("nifi.administrative.yield.duration", coreProperties.getAdministrativeYieldDuration()), Map.entry("nifi.bored.yield.duration", coreProperties.getBoredYieldDuration()), Map.entry("nifi.flowfile.repository.implementation", flowFileRepositoryProperties.getFlowFileRepository()), Map.entry("nifi.flowfile.repository.checkpoint.interval", flowFileRepositoryProperties.getCheckpointInterval()), Map.entry("nifi.flowfile.repository.always.sync", Boolean.toString(flowFileRepositoryProperties.getAlwaysSync())), Map.entry("nifi.content.repository.implementation", contentRepositoryProperties.getContentRepository()), Map.entry("nifi.content.claim.max.appendable.size", contentRepositoryProperties.getContentClaimMaxAppendableSize()), Map.entry("nifi.content.repository.archive.max.retention.period", contentRepositoryProperties.getContentRepoArchiveMaxRetentionPeriod()), Map.entry("nifi.content.repository.archive.max.usage.percentage", contentRepositoryProperties.getContentRepoArchiveMaxUsagePercentage()), Map.entry("nifi.content.repository.archive.enabled", Boolean.toString(contentRepositoryProperties.getContentRepoArchiveEnabled())), Map.entry("nifi.provenance.repository.implementation", provenanceRepositoryProperties.getProvenanceRepository()), Map.entry("nifi.provenance.repository.rollover.time", provenanceRepositoryProperties.getProvenanceRepoRolloverTimeKey()), Map.entry("nifi.provenance.repository.index.shard.size", provenanceRepositoryProperties.getProvenanceRepoIndexShardSize()), Map.entry("nifi.provenance.repository.max.storage.size", provenanceRepositoryProperties.getProvenanceRepoMaxStorageSize()), Map.entry("nifi.provenance.repository.max.storage.time", provenanceRepositoryProperties.getProvenanceRepoMaxStorageTime()), Map.entry("nifi.components.status.snapshot.frequency", componentStatusRepositoryProperties.getSnapshotFrequency()), Map.entry("nifi.queue.swap.threshold", swapProperties.getThreshold().toString())), Optional.ofNullable(this.configSchema.getNifiPropertiesOverrides()).map(Map::entrySet).orElse(Set.of()).stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public VersionedDataflow convert() {
        VersionedDataflow versionedDataflow = new VersionedDataflow();
        versionedDataflow.setEncodingVersion(new VersionedFlowEncodingVersion(2, 0));
        versionedDataflow.setMaxTimerDrivenThreadCount(this.configSchema.getCoreProperties().getMaxConcurrentThreads().intValue());
        versionedDataflow.setRegistries(List.of());
        versionedDataflow.setParameterContexts(List.of());
        versionedDataflow.setParameterProviders(List.of());
        versionedDataflow.setControllerServices(List.of());
        versionedDataflow.setReportingTasks(this.convertComponents(() -> ((ConfigSchema)this.configSchema).getReportingTasksSchema(), this::toVersionedReportingTask, Collectors.toList()));
        VersionedProcessGroup versionedProcessGroup = new VersionedProcessGroup();
        versionedProcessGroup.setDefaultFlowFileExpiration(DEFAULT_FLOW_FILE_EXPIRATION);
        versionedProcessGroup.setDefaultBackPressureObjectThreshold(Long.valueOf(10000L));
        versionedProcessGroup.setDefaultBackPressureDataSizeThreshold(DEFAULT_BACK_PRESSURE_DATA_SIZE_THRESHOLD);
        versionedProcessGroup.setFlowFileConcurrency(FLOW_FILE_CONCURRENCY);
        versionedProcessGroup.setFlowFileOutboundPolicy(FLOW_FILE_OUTBOUND_POLICY);
        this.convertProcessGroup(this.configSchema.getProcessGroupSchema(), versionedProcessGroup);
        Map<String, String> idToInstanceIdMapOfConnectableComponents = this.getIdToInstanceIdMapOfConnectableComponents(versionedProcessGroup);
        this.setConnectableComponentsInstanceId(versionedProcessGroup, idToInstanceIdMapOfConnectableComponents);
        versionedDataflow.setRootGroup(versionedProcessGroup);
        return versionedDataflow;
    }

    private Map<String, String> getIdToInstanceIdMapOfConnectableComponents(VersionedProcessGroup versionedProcessGroup) {
        Map<String, String> thisProcessGroupIdToInstanceIdMaps = Stream.of(Optional.ofNullable(versionedProcessGroup.getProcessors()).orElse(Set.of()), Optional.ofNullable(versionedProcessGroup.getInputPorts()).orElse(Set.of()), Optional.ofNullable(versionedProcessGroup.getOutputPorts()).orElse(Set.of()), Optional.ofNullable(versionedProcessGroup.getFunnels()).orElse(Set.of()), Optional.ofNullable(versionedProcessGroup.getRemoteProcessGroups()).orElse(Set.of()).stream().map(VersionedRemoteProcessGroup::getInputPorts).flatMap(Collection::stream).collect(Collectors.toSet()), Optional.ofNullable(versionedProcessGroup.getRemoteProcessGroups()).orElse(Set.of()).stream().map(VersionedRemoteProcessGroup::getOutputPorts).flatMap(Collection::stream).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toMap(VersionedComponent::getIdentifier, VersionedComponent::getInstanceIdentifier));
        Stream<Map> childProcessGroupsIdToInstanceIdMaps = Optional.ofNullable(versionedProcessGroup.getProcessGroups()).orElse(Set.of()).stream().map(this::getIdToInstanceIdMapOfConnectableComponents);
        return Stream.concat(Stream.of(thisProcessGroupIdToInstanceIdMaps), childProcessGroupsIdToInstanceIdMaps).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void setConnectableComponentsInstanceId(VersionedProcessGroup versionedProcessGroup, Map<String, String> idToInstanceIdMapOfConnectableComponents) {
        Optional.ofNullable(versionedProcessGroup.getConnections()).orElse(Set.of()).forEach(connection -> {
            ConnectableComponent source = connection.getSource();
            source.setInstanceIdentifier((String)idToInstanceIdMapOfConnectableComponents.get(source.getId()));
            ConnectableComponent destination = connection.getDestination();
            System.err.println(String.valueOf(destination.getType()) + " - " + destination.getId() + " - " + (String)idToInstanceIdMapOfConnectableComponents.get(destination.getId()));
            destination.setInstanceIdentifier((String)idToInstanceIdMapOfConnectableComponents.get(destination.getId()));
        });
        Optional.ofNullable(versionedProcessGroup.getProcessGroups()).orElse(Set.of()).forEach(childProcessGroup -> this.setConnectableComponentsInstanceId((VersionedProcessGroup)childProcessGroup, idToInstanceIdMapOfConnectableComponents));
    }

    private void convertProcessGroup(ProcessGroupSchema processGroupSchema, VersionedProcessGroup processGroup) {
        processGroup.setIdentifier(processGroupSchema.getId());
        processGroup.setInstanceIdentifier(processGroupSchema.getId());
        processGroup.setName(this.getNameOrId((BaseSchemaWithIdAndName)processGroupSchema));
        processGroup.setComments(processGroupSchema.getComment());
        processGroup.setPosition(DEFAULT_POSITION);
        processGroup.setProcessors(this.convertComponents(() -> ((ProcessGroupSchema)processGroupSchema).getProcessors(), this::toVersionedProcessor, Collectors.toSet()));
        processGroup.setControllerServices(this.convertComponents(() -> ((ProcessGroupSchema)processGroupSchema).getControllerServices(), this::toVersionedControllerService, Collectors.toSet()));
        processGroup.setConnections(this.convertComponents(() -> ((ProcessGroupSchema)processGroupSchema).getConnections(), this::toVersionedConnection, Collectors.toSet()));
        processGroup.setFunnels(this.convertComponents(() -> ((ProcessGroupSchema)processGroupSchema).getFunnels(), this::toVersionedFunnel, Collectors.toSet()));
        processGroup.setRemoteProcessGroups(this.convertComponents(() -> ((ProcessGroupSchema)processGroupSchema).getRemoteProcessGroups(), this::toRemoteProcessGroup, Collectors.toSet()));
        processGroup.setInputPorts(this.convertComponents(() -> ((ProcessGroupSchema)processGroupSchema).getInputPortSchemas(), this::toInputPort, Collectors.toSet()));
        processGroup.setOutputPorts(this.convertComponents(() -> ((ProcessGroupSchema)processGroupSchema).getOutputPortSchemas(), this::toOutputPort, Collectors.toSet()));
        processGroup.setProcessGroups(this.convertComponents(() -> ((ProcessGroupSchema)processGroupSchema).getProcessGroupSchemas(), this::toVersionedProcessGroup, Collectors.toSet()));
    }

    private <T, U, V> V convertComponents(Supplier<List<U>> convertibles, Function<U, T> converter, Collector<T, ?, V> collector) {
        return Optional.ofNullable(convertibles.get()).orElse(List.of()).stream().map(converter).collect(collector);
    }

    private VersionedReportingTask toVersionedReportingTask(ReportingSchema reportingSchema) {
        VersionedReportingTask reportingTask = new VersionedReportingTask();
        reportingTask.setIdentifier(reportingSchema.getId());
        reportingTask.setInstanceIdentifier(UUID.randomUUID().toString());
        reportingTask.setName(this.getNameOrId((BaseSchemaWithIdAndName)reportingSchema));
        reportingTask.setComments(reportingSchema.getComment());
        reportingTask.setType(reportingSchema.getReportingClass());
        reportingTask.setBundle(this.bundleFor(reportingSchema.getReportingClass()));
        reportingTask.setSchedulingStrategy(reportingSchema.getSchedulingStrategy());
        reportingTask.setSchedulingPeriod(reportingSchema.getSchedulingPeriod());
        reportingTask.setProperties(this.toStringStringProperties(reportingSchema.getProperties()));
        reportingTask.setComponentType(ComponentType.REPORTING_TASK);
        reportingTask.setScheduledState(ScheduledState.RUNNING);
        reportingTask.setPropertyDescriptors(Map.of());
        reportingTask.setPosition(DEFAULT_POSITION);
        return reportingTask;
    }

    private VersionedProcessor toVersionedProcessor(ProcessorSchema processorSchema) {
        VersionedProcessor processor = new VersionedProcessor();
        processor.setIdentifier(processorSchema.getId());
        processor.setInstanceIdentifier(UUID.randomUUID().toString());
        processor.setGroupIdentifier(this.componentPropertyProvider.parentId(processorSchema.getId()));
        processor.setName(this.getNameOrId((BaseSchemaWithIdAndName)processorSchema));
        processor.setType(processorSchema.getProcessorClass());
        processor.setBundle(this.bundleFor(processorSchema.getProcessorClass()));
        processor.setConcurrentlySchedulableTaskCount(Integer.valueOf(processorSchema.getMaxConcurrentTasks().intValue()));
        processor.setSchedulingStrategy(processorSchema.getSchedulingStrategy());
        processor.setSchedulingPeriod(processorSchema.getSchedulingPeriod());
        processor.setPenaltyDuration(processorSchema.getPenalizationPeriod());
        processor.setYieldDuration(processorSchema.getYieldPeriod());
        processor.setRunDurationMillis(Long.valueOf(TimeUnit.NANOSECONDS.toMicros(processorSchema.getRunDurationNanos().longValue())));
        processor.setAutoTerminatedRelationships(Set.copyOf(processorSchema.getAutoTerminatedRelationshipsList()));
        processor.setProperties(this.toStringStringProperties(processorSchema.getProperties()));
        processor.setAnnotationData(processorSchema.getAnnotationData());
        processor.setComponentType(ComponentType.PROCESSOR);
        processor.setScheduledState(ScheduledState.RUNNING);
        processor.setPropertyDescriptors(Map.of());
        processor.setBulletinLevel(LogLevel.WARN.name());
        processor.setPosition(DEFAULT_POSITION);
        processor.setExecutionNode(ExecutionNode.ALL.name());
        return processor;
    }

    private VersionedControllerService toVersionedControllerService(ControllerServiceSchema controllerServiceSchema) {
        VersionedControllerService controllerService = new VersionedControllerService();
        controllerService.setIdentifier(controllerServiceSchema.getId());
        controllerService.setInstanceIdentifier(UUID.randomUUID().toString());
        controllerService.setGroupIdentifier(this.componentPropertyProvider.parentId(controllerServiceSchema.getId()));
        controllerService.setName(this.getNameOrId((BaseSchemaWithIdAndName)controllerServiceSchema));
        controllerService.setType(controllerServiceSchema.getServiceClass());
        controllerService.setBundle(this.bundleFor(controllerServiceSchema.getServiceClass()));
        controllerService.setProperties(this.toStringStringProperties(controllerServiceSchema.getProperties()));
        controllerService.setAnnotationData(controllerServiceSchema.getAnnotationData());
        controllerService.setComponentType(ComponentType.CONTROLLER_SERVICE);
        controllerService.setScheduledState(ScheduledState.RUNNING);
        controllerService.setPropertyDescriptors(Map.of());
        controllerService.setPosition(DEFAULT_POSITION);
        return controllerService;
    }

    private VersionedConnection toVersionedConnection(ConnectionSchema connectionSchema) {
        VersionedConnection connection = new VersionedConnection();
        connection.setIdentifier(connectionSchema.getId());
        connection.setInstanceIdentifier(UUID.randomUUID().toString());
        connection.setName(this.getNameOrId((BaseSchemaWithIdAndName)connectionSchema));
        connection.setComponentType(ComponentType.CONNECTION);
        connection.setSource(this.connectableComponent(connectionSchema.getSourceId()));
        connection.setDestination(this.connectableComponent(connectionSchema.getDestinationId()));
        connection.setSelectedRelationships(Set.copyOf(connectionSchema.getSourceRelationshipNames()));
        connection.setBackPressureDataSizeThreshold(connectionSchema.getMaxWorkQueueDataSize());
        connection.setBackPressureObjectThreshold(Long.valueOf(connectionSchema.getMaxWorkQueueSize().longValue()));
        connection.setFlowFileExpiration(connectionSchema.getFlowfileExpiration());
        connection.setPrioritizers(List.of(connectionSchema.getQueuePrioritizerClass()).stream().filter(StringUtils::isNotBlank).collect(Collectors.toList()));
        connection.setPosition(DEFAULT_POSITION);
        connection.setLabelIndex(Integer.valueOf(0));
        connection.setzIndex(Long.valueOf(0L));
        return connection;
    }

    private ConnectableComponent connectableComponent(String componentId) {
        ConnectableComponent component = new ConnectableComponent();
        component.setId(componentId);
        component.setGroupId(this.componentPropertyProvider.parentId(componentId));
        component.setType(this.componentPropertyProvider.connectableComponentType(componentId));
        return component;
    }

    private VersionedFunnel toVersionedFunnel(FunnelSchema funnelSchema) {
        VersionedFunnel funnel = new VersionedFunnel();
        funnel.setIdentifier(funnelSchema.getId());
        funnel.setInstanceIdentifier(UUID.randomUUID().toString());
        funnel.setGroupIdentifier(this.componentPropertyProvider.parentId(funnelSchema.getId()));
        funnel.setName(funnelSchema.getWrapperName());
        funnel.setComponentType(ComponentType.FUNNEL);
        funnel.setPosition(DEFAULT_POSITION);
        return funnel;
    }

    private VersionedRemoteProcessGroup toRemoteProcessGroup(RemoteProcessGroupSchema remoteProcessGroupSchema) {
        VersionedRemoteProcessGroup remoteProcessGroup = new VersionedRemoteProcessGroup();
        remoteProcessGroup.setIdentifier(remoteProcessGroupSchema.getId());
        remoteProcessGroup.setInstanceIdentifier(UUID.randomUUID().toString());
        remoteProcessGroup.setGroupIdentifier(this.componentPropertyProvider.parentId(remoteProcessGroupSchema.getId()));
        remoteProcessGroup.setName(this.getNameOrId((BaseSchemaWithIdAndName)remoteProcessGroupSchema));
        remoteProcessGroup.setComponentType(ComponentType.REMOTE_PROCESS_GROUP);
        remoteProcessGroup.setTargetUris(remoteProcessGroupSchema.getUrls());
        remoteProcessGroup.setComments(remoteProcessGroupSchema.getComment());
        remoteProcessGroup.setCommunicationsTimeout(remoteProcessGroupSchema.getTimeout());
        remoteProcessGroup.setYieldDuration(remoteProcessGroupSchema.getYieldPeriod());
        remoteProcessGroup.setTransportProtocol(remoteProcessGroupSchema.getTransportProtocol());
        Optional.ofNullable(remoteProcessGroupSchema.getLocalNetworkInterface()).filter(StringUtils::isNotBlank).ifPresent(arg_0 -> ((VersionedRemoteProcessGroup)remoteProcessGroup).setLocalNetworkInterface(arg_0));
        Optional.ofNullable(remoteProcessGroupSchema.getProxyHost()).filter(StringUtils::isNotBlank).ifPresent(arg_0 -> ((VersionedRemoteProcessGroup)remoteProcessGroup).setProxyHost(arg_0));
        Optional.ofNullable(remoteProcessGroupSchema.getProxyPort()).filter(Objects::nonNull).ifPresent(arg_0 -> ((VersionedRemoteProcessGroup)remoteProcessGroup).setProxyPort(arg_0));
        Optional.ofNullable(remoteProcessGroupSchema.getProxyUser()).filter(StringUtils::isNotBlank).ifPresent(arg_0 -> ((VersionedRemoteProcessGroup)remoteProcessGroup).setProxyUser(arg_0));
        Optional.ofNullable(remoteProcessGroupSchema.getProxyPassword()).filter(StringUtils::isNotBlank).ifPresent(arg_0 -> ((VersionedRemoteProcessGroup)remoteProcessGroup).setProxyPassword(arg_0));
        remoteProcessGroup.setPosition(DEFAULT_POSITION);
        remoteProcessGroup.setInputPorts(this.convertComponents(() -> ((RemoteProcessGroupSchema)remoteProcessGroupSchema).getInputPorts(), this::toRemoteInputPort, Collectors.toSet()));
        remoteProcessGroup.setOutputPorts(this.convertComponents(() -> ((RemoteProcessGroupSchema)remoteProcessGroupSchema).getOutputPorts(), this::toRemoteOutputPort, Collectors.toSet()));
        return remoteProcessGroup;
    }

    private VersionedRemoteGroupPort toRemoteInputPort(RemotePortSchema portSchema) {
        return this.toVersionedRemoteGroupPort(portSchema, ComponentType.REMOTE_INPUT_PORT);
    }

    private VersionedRemoteGroupPort toRemoteOutputPort(RemotePortSchema portSchema) {
        return this.toVersionedRemoteGroupPort(portSchema, ComponentType.REMOTE_OUTPUT_PORT);
    }

    private VersionedRemoteGroupPort toVersionedRemoteGroupPort(RemotePortSchema portSchema, ComponentType portType) {
        VersionedRemoteGroupPort port = new VersionedRemoteGroupPort();
        port.setIdentifier(UUID.randomUUID().toString());
        port.setInstanceIdentifier(portSchema.getId());
        port.setTargetId(portSchema.getId());
        port.setGroupIdentifier(this.componentPropertyProvider.parentId(portSchema.getId()));
        port.setName(this.getNameOrId((BaseSchemaWithIdAndName)portSchema));
        port.setComponentType(portType);
        port.setScheduledState(ScheduledState.RUNNING);
        port.setComments(portSchema.getComment());
        port.setConcurrentlySchedulableTaskCount(Integer.valueOf(portSchema.getMax_concurrent_tasks().intValue()));
        port.setUseCompression(Boolean.valueOf(portSchema.getUseCompression()));
        port.setPosition(DEFAULT_POSITION);
        return port;
    }

    private VersionedPort toInputPort(PortSchema portSchema) {
        return this.toVersionedPort(portSchema, PortType.INPUT_PORT);
    }

    private VersionedPort toOutputPort(PortSchema portSchema) {
        return this.toVersionedPort(portSchema, PortType.OUTPUT_PORT);
    }

    private VersionedPort toVersionedPort(PortSchema portSchema, PortType portType) {
        VersionedPort port = new VersionedPort();
        port.setIdentifier(portSchema.getId());
        port.setInstanceIdentifier(UUID.randomUUID().toString());
        port.setGroupIdentifier(this.componentPropertyProvider.parentId(portSchema.getId()));
        port.setName(this.getNameOrId((BaseSchemaWithIdAndName)portSchema));
        port.setComponentType(portType == PortType.INPUT_PORT ? ComponentType.INPUT_PORT : ComponentType.OUTPUT_PORT);
        port.setScheduledState(ScheduledState.RUNNING);
        port.setType(portType);
        port.setAllowRemoteAccess(Boolean.TRUE);
        port.setPosition(DEFAULT_POSITION);
        return port;
    }

    private VersionedProcessGroup toVersionedProcessGroup(ProcessGroupSchema childProcessGroupSchema) {
        VersionedProcessGroup childProcessGroup = new VersionedProcessGroup();
        childProcessGroup.setGroupIdentifier(this.componentPropertyProvider.parentId(childProcessGroupSchema.getId()));
        this.convertProcessGroup(childProcessGroupSchema, childProcessGroup);
        return childProcessGroup;
    }

    private Map<String, String> toStringStringProperties(Map<String, Object> stringObjectProperties) {
        return stringObjectProperties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Optional.ofNullable(entry.getValue()).map(Object::toString).orElse("")));
    }

    private Bundle bundleFor(String type) {
        Bundle bundle = new Bundle();
        bundle.setGroup("");
        bundle.setArtifact(type);
        bundle.setVersion("");
        return bundle;
    }

    private String getNameOrId(BaseSchemaWithIdAndName schema) {
        return Optional.ofNullable(schema.getName()).filter(StringUtils::isNotBlank).orElse(schema.getId());
    }
}

