/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.management;

import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings;
import jetbrains.exodus.entitystore.management.EntityStoreConfigMBean;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.management.MBeanBase;
import org.jetbrains.annotations.NotNull;

public class EntityStoreConfig
extends MBeanBase
implements EntityStoreConfigMBean {
    @NotNull
    private final PersistentEntityStoreImpl store;
    @NotNull
    private final PersistentEntityStoreConfig config;

    public EntityStoreConfig(@NotNull PersistentEntityStoreImpl store) {
        super(EntityStoreConfig.getObjectName(store));
        this.store = store;
        this.config = store.getConfig();
    }

    @Override
    public boolean getRefactoringSkipAll() {
        return this.config.getRefactoringSkipAll();
    }

    @Override
    public boolean getRefactoringNullIndices() {
        return this.config.getRefactoringNullIndices();
    }

    @Override
    public boolean getRefactoringBlobNullIndices() {
        return this.config.getRefactoringBlobNullIndices();
    }

    @Override
    public boolean getRefactoringHeavyLinks() {
        return this.config.getRefactoringHeavyLinks();
    }

    @Override
    public boolean getRefactoringHeavyProps() {
        return this.config.getRefactoringHeavyProps();
    }

    @Override
    public boolean getRefactoringDeleteRedundantBlobs() {
        return this.config.getRefactoringDeleteRedundantBlobs();
    }

    @Override
    public int getRefactoringDeduplicateBlobsEvery() {
        return this.config.getRefactoringDeduplicateBlobsEvery();
    }

    @Override
    public int getRefactoringDeduplicateBlobsMinSize() {
        return this.config.getRefactoringDeduplicateBlobsMinSize();
    }

    @Override
    public int getMaxInPlaceBlobSize() {
        return this.config.getMaxInPlaceBlobSize();
    }

    @Override
    public void setMaxInPlaceBlobSize(int blobSize) {
        this.config.setMaxInPlaceBlobSize(blobSize);
    }

    @Override
    public boolean isBlobStringsCacheShared() {
        return this.config.isBlobStringsCacheShared();
    }

    @Override
    public long getBlobStringsCacheMaxValueSize() {
        return this.config.getBlobStringsCacheMaxValueSize();
    }

    @Override
    public void setBlobStringsCacheMaxValueSize(long maxValueSize) {
        this.config.setBlobStringsCacheMaxValueSize(maxValueSize);
    }

    @Override
    public boolean isCachingDisabled() {
        return this.config.isCachingDisabled();
    }

    @Override
    public void setCachingDisabled(boolean disabled) {
        this.config.setCachingDisabled(disabled);
    }

    @Override
    public boolean isReorderingDisabled() {
        return this.config.isReorderingDisabled();
    }

    @Override
    public void setReorderingDisabled(boolean disabled) {
        this.config.setReorderingDisabled(disabled);
    }

    @Override
    public boolean isExplainOn() {
        return this.config.isExplainOn();
    }

    @Override
    public boolean isDebugLinkDataGetter() {
        return this.config.isDebugLinkDataGetter();
    }

    @Override
    public boolean isDebugSearchForIncomingLinksOnDelete() {
        return this.config.isDebugSearchForIncomingLinksOnDelete();
    }

    @Override
    public void setDebugSearchForIncomingLinksOnDelete(boolean debug) {
        this.config.setDebugSearchForIncomingLinksOnDelete(debug);
    }

    @Override
    public boolean isDebugTestLinkedEntities() {
        return this.config.isDebugTestLinkedEntities();
    }

    @Override
    public void setDebugTestLinkedEntities(boolean debug) {
        this.config.setDebugTestLinkedEntities(debug);
    }

    @Override
    public boolean isDebugAllowInMemorySort() {
        return this.config.isDebugAllowInMemorySort();
    }

    @Override
    public void setDebugAllowInMemorySort(boolean debug) {
        this.config.setDebugAllowInMemorySort(debug);
    }

    @Override
    public int getEntityIterableCacheSize() {
        return this.config.getEntityIterableCacheSize();
    }

    @Override
    public int getEntityIterableCacheCountsCacheSize() {
        return this.config.getEntityIterableCacheCountsCacheSize();
    }

    @Override
    public long getEntityIterableCacheCountsLifeTime() {
        return this.config.getEntityIterableCacheCountsLifeTime();
    }

    @Override
    public void setEntityIterableCacheCountsLifeTime(long lifeTime) {
        this.config.setEntityIterableCacheCountsLifeTime(lifeTime);
    }

    @Override
    public int getEntityIterableCacheThreadCount() {
        return this.config.getEntityIterableCacheThreadCount();
    }

    @Override
    public long getEntityIterableCacheCachingTimeout() {
        return this.config.getEntityIterableCacheCachingTimeout();
    }

    @Override
    public void setEntityIterableCacheCachingTimeout(long cachingTimeout) {
        this.config.setEntityIterableCacheCachingTimeout(cachingTimeout);
    }

    @Override
    public long getEntityIterableCacheCountsCachingTimeout() {
        return this.config.getEntityIterableCacheCountsCachingTimeout();
    }

    @Override
    public void setEntityIterableCacheCountsCachingTimeout(long cachingTimeout) {
        this.config.setEntityIterableCacheCountsCachingTimeout(cachingTimeout);
    }

    @Override
    public long getEntityIterableCacheStartCachingTimeout() {
        return this.config.getEntityIterableCacheStartCachingTimeout();
    }

    @Override
    public void setEntityIterableCacheStartCachingTimeout(long startCachingTimeout) {
        this.config.setEntityIterableCacheStartCachingTimeout(startCachingTimeout);
    }

    @Override
    public int getEntityIterableCacheDeferredDelay() {
        return this.config.getEntityIterableCacheDeferredDelay();
    }

    @Override
    public void setEntityIterableCacheDeferredDelay(int deferredDelay) {
        this.config.setEntityIterableCacheDeferredDelay(deferredDelay);
    }

    @Override
    public int getEntityIterableCacheMaxSizeOfDirectValue() {
        return this.config.getEntityIterableCacheMaxSizeOfDirectValue();
    }

    @Override
    public void setEntityIterableCacheMaxSizeOfDirectValue(int maxSizeOfDirectValue) {
        this.config.setEntityIterableCacheMaxSizeOfDirectValue(maxSizeOfDirectValue);
    }

    @Override
    public boolean getEntityIterableCacheUseHumanReadable() {
        return this.config.getEntityIterableCacheUseHumanReadable();
    }

    @Override
    public void setEntityIterableCacheUseHumanReadable(boolean useHumanReadable) {
        this.config.setEntityIterableCacheUseHumanReadable(useHumanReadable);
    }

    @Override
    public int getEntityIterableCacheHeavyIterablesCacheSize() {
        return this.config.getEntityIterableCacheHeavyIterablesCacheSize();
    }

    @Override
    public long getEntityIterableCacheHeavyIterablesLifeSpan() {
        return this.config.getEntityIterableCacheHeavyIterablesLifeSpan();
    }

    @Override
    public void setEntityIterableCacheHeavyIterablesLifeSpan(long lifeSpan) {
        this.config.setEntityIterableCacheHeavyIterablesLifeSpan(lifeSpan);
    }

    @Override
    public int getTransactionPropsCacheSize() {
        return this.config.getTransactionPropsCacheSize();
    }

    @Override
    public void setTransactionPropsCacheSize(int transactionPropsCacheSize) {
        this.config.setTransactionPropsCacheSize(transactionPropsCacheSize);
    }

    @Override
    public int getTransactionLinksCacheSize() {
        return this.config.getTransactionLinksCacheSize();
    }

    @Override
    public void setTransactionLinksCacheSize(int transactionLinksCacheSize) {
        this.config.setTransactionLinksCacheSize(transactionLinksCacheSize);
    }

    @Override
    public int getTransactionBlobStringsCacheSize() {
        return this.config.getTransactionBlobStringsCacheSize();
    }

    @Override
    public void setTransactionBlobStringsCacheSize(int transactionBlobStringsCacheSize) {
        this.config.setTransactionBlobStringsCacheSize(transactionBlobStringsCacheSize);
    }

    @Override
    public boolean getGatherStatistics() {
        return this.config.getGatherStatistics();
    }

    @Override
    public void startBlobsDeduplication() {
        ((EnvironmentImpl)this.store.getEnvironment()).getGC().getCleanerJobProcessor().queue(new Job(){

            protected void execute() {
                new PersistentEntityStoreRefactorings(EntityStoreConfig.this.store).refactorDeduplicateInPlaceBlobs();
            }
        });
    }

    @Override
    public void close() {
        this.store.close();
        super.close();
    }

    public static String getObjectName(@NotNull PersistentEntityStoreImpl store) {
        return "jetbrains.exodus.entitystore: type=EntityStoreConfig, location=" + EntityStoreConfig.escapeLocation((String)store.getLocation()) + ", name=" + store.getName();
    }
}

