/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.vm;

import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.griffin.engine.LimitOverflowException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.BinarySequence;
import io.questdb.std.Chars;
import io.questdb.std.Long256;
import io.questdb.std.Long256Acceptor;
import io.questdb.std.Long256FromCharSequenceDecoder;
import io.questdb.std.Long256Impl;
import io.questdb.std.LongList;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.FloatingDirectCharSink;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.NotNull;

public class MemoryPARWImpl
implements MemoryARW {
    private static final Log LOG = LogFactory.getLog(MemoryPARWImpl.class);
    protected final LongList pages = new LongList(4, 0L);
    private final ByteSequenceView bsview = new ByteSequenceView();
    private final CharSequenceView csview = new CharSequenceView();
    private final CharSequenceView csview2 = new CharSequenceView();
    private final InPageLong256FromCharSequenceDecoder inPageLong256Decoder = new InPageLong256FromCharSequenceDecoder();
    private final Long256Impl long256 = new Long256Impl();
    private final Long256Impl long256B = new Long256Impl();
    private final int maxPages;
    private final StraddlingPageLong256FromCharSequenceDecoder straddlingPageLong256Decoder = new StraddlingPageLong256FromCharSequenceDecoder();
    private final FloatingDirectCharSink utf8FloatingSink = new FloatingDirectCharSink();
    private final StringSink utf8StrSink = new StringSink();
    protected int memoryTag;
    private long absolutePointer;
    private long appendPointer = -1L;
    private long baseOffset = 1L;
    private long extendSegmentMod;
    private int extendSegmentMsb;
    private long extendSegmentSize;
    private long pageHi = -1L;
    private long pageLo = -1L;
    private long roOffsetHi = 0L;
    private long roOffsetLo = 0L;

    public MemoryPARWImpl(long pageSize, int maxPages, int memoryTag) {
        this.setExtendSegmentSize(pageSize);
        this.maxPages = maxPages;
        this.memoryTag = memoryTag;
    }

    protected MemoryPARWImpl() {
        this.maxPages = Integer.MAX_VALUE;
        this.memoryTag = 0;
    }

    @Override
    public long addressOf(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi) {
            return this.absolutePointer + offset;
        }
        return this.addressOf0(offset);
    }

    @Override
    public long appendAddressFor(long bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long appendAddressFor(long offset, long bytes) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        this.releaseAllPagesButFirst();
        this.appendPointer = -1L;
        this.pageHi = -1L;
        this.pageLo = -1L;
        this.baseOffset = 1L;
        this.clearHotPage();
    }

    public void clearHotPage() {
        this.roOffsetHi = 0L;
        this.roOffsetLo = 0L;
    }

    @Override
    public void close() {
        this.clear();
        int n = this.pages.size();
        if (n > 0) {
            this.release(this.pages.getQuick(0));
            this.pages.setQuick(0, 0L);
            this.pages.clear();
        }
    }

    public void copyTo(long address, long offset, long len) {
        long pageSize = this.getPageSize();
        while (len > 0L) {
            int page = this.pageIndex(offset);
            long pageAddress = this.getPageAddress(page);
            assert (pageAddress > 0L);
            long offsetInPage = this.offsetInPage(offset);
            long bytesToCopy = Math.min(len, pageSize - offsetInPage);
            Vect.memcpy(address, pageAddress + offsetInPage, bytesToCopy);
            len -= bytesToCopy;
            offset += bytesToCopy;
            address += bytesToCopy;
        }
    }

    @Override
    public void extend(long size) {
        assert (size > 0L);
        this.mapWritePage(this.pageIndex(size - 1L), size - 1L);
    }

    @Override
    public final long getAppendOffset() {
        return this.baseOffset + this.appendPointer;
    }

    @Override
    public final BinarySequence getBin(long offset) {
        long len = this.getLong(offset);
        if (len == -1L) {
            return null;
        }
        return this.bsview.of(offset + 8L, len);
    }

    @Override
    public final long getBinLen(long offset) {
        return this.getLong(offset);
    }

    @Override
    public boolean getBool(long offset) {
        return this.getByte(offset) == 1;
    }

    @Override
    public final byte getByte(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 1L) {
            return Unsafe.getUnsafe().getByte(this.absolutePointer + offset);
        }
        return this.getByte0(offset);
    }

    @Override
    public final char getChar(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 2L) {
            return Unsafe.getUnsafe().getChar(this.absolutePointer + offset);
        }
        return this.getChar0(offset);
    }

    @Override
    public final double getDouble(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 8L) {
            return Unsafe.getUnsafe().getDouble(this.absolutePointer + offset);
        }
        return this.getDouble0(offset);
    }

    @Override
    public long getExtendSegmentSize() {
        return this.extendSegmentSize;
    }

    @Override
    public final float getFloat(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 4L) {
            return Unsafe.getUnsafe().getFloat(this.absolutePointer + offset);
        }
        return this.getFloat0(offset);
    }

    @Override
    public final int getInt(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 4L) {
            return Unsafe.getUnsafe().getInt(this.absolutePointer + offset);
        }
        return this.getInt0(offset);
    }

    @Override
    public long getLong(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 8L) {
            return Unsafe.getUnsafe().getLong(this.absolutePointer + offset);
        }
        return this.getLong0(offset);
    }

    @Override
    public void getLong256(long offset, CharSink sink) {
        long d;
        long c;
        long b;
        long a;
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 32L) {
            a = Unsafe.getUnsafe().getLong(this.absolutePointer + offset);
            b = Unsafe.getUnsafe().getLong(this.absolutePointer + offset + 8L);
            c = Unsafe.getUnsafe().getLong(this.absolutePointer + offset + 16L);
            d = Unsafe.getUnsafe().getLong(this.absolutePointer + offset + 24L);
        } else {
            a = this.getLong(offset);
            b = this.getLong(offset + 8L);
            c = this.getLong(offset + 16L);
            d = this.getLong(offset + 24L);
        }
        Numbers.appendLong256(a, b, c, d, sink);
    }

    @Override
    public void getLong256(long offset, Long256Acceptor sink) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 32L) {
            sink.setAll(Unsafe.getUnsafe().getLong(this.absolutePointer + offset), Unsafe.getUnsafe().getLong(this.absolutePointer + offset + 8L), Unsafe.getUnsafe().getLong(this.absolutePointer + offset + 16L), Unsafe.getUnsafe().getLong(this.absolutePointer + offset + 24L));
        } else {
            sink.setAll(this.getLong(offset), this.getLong(offset + 8L), this.getLong(offset + 16L), this.getLong(offset + 24L));
        }
    }

    @Override
    public Long256 getLong256A(long offset) {
        this.getLong256(offset, this.long256);
        return this.long256;
    }

    @Override
    public Long256 getLong256B(long offset) {
        this.getLong256(offset, this.long256B);
        return this.long256B;
    }

    @Override
    public long getPageAddress(int page) {
        if (page < this.pages.size()) {
            return this.pages.getQuick(page);
        }
        return 0L;
    }

    @Override
    public int getPageCount() {
        return this.pages.size();
    }

    @Override
    public long getPageSize() {
        return this.getExtendSegmentSize();
    }

    @Override
    public final short getShort(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 2L) {
            return Unsafe.getUnsafe().getShort(this.absolutePointer + offset);
        }
        return this.getShort0(offset);
    }

    @Override
    public final CharSequence getStr(long offset) {
        return this.getStr0(offset, this.csview);
    }

    public final CharSequence getStr0(long offset, CharSequenceView view) {
        int len = this.getInt(offset);
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        return view.of(offset + 4L, len);
    }

    @Override
    public final CharSequence getStr2(long offset) {
        return this.getStr0(offset, this.csview2);
    }

    @Override
    public final int getStrLen(long offset) {
        return this.getInt(offset);
    }

    public boolean isMapped(long offset, long len) {
        int pageEndIndex;
        int pageIndex = this.pageIndex(offset);
        if (pageIndex == (pageEndIndex = this.pageIndex(offset + len - 1L))) {
            return this.getPageAddress(pageIndex) > 0L;
        }
        return false;
    }

    @Override
    public void jumpTo(long offset) {
        assert (offset > -1L);
        long p = offset - this.baseOffset;
        if (p > this.pageLo && p < this.pageHi) {
            this.appendPointer = p;
        } else {
            this.jumpTo0(offset);
        }
    }

    @Override
    public long offsetInPage(long offset) {
        return offset & this.extendSegmentMod;
    }

    @Override
    public final int pageIndex(long offset) {
        return (int)(offset >> this.extendSegmentMsb);
    }

    public long pageRemaining(long offset) {
        return this.getPageSize() - this.offsetInPage(offset);
    }

    @Override
    public final long putBin(BinarySequence value) {
        if (value == null) {
            this.putLong(-1L);
        } else {
            long len = value.length();
            this.putLong(len);
            long remaining = this.pageHi - this.appendPointer;
            if (len < remaining) {
                this.putBinSequence(value, 0L, len);
                this.appendPointer += len;
            } else {
                this.putBin0(value, len, remaining);
            }
        }
        return this.getAppendOffset();
    }

    @Override
    public final long putBin(long from, long len) {
        this.putLong(len > 0L ? len : -1L);
        if (len < 1L) {
            return this.getAppendOffset();
        }
        if (len < this.pageHi - this.appendPointer) {
            Vect.memcpy(this.appendPointer, from, len);
            this.appendPointer += len;
        } else {
            this.putBinSlit(from, len);
        }
        return this.getAppendOffset();
    }

    @Override
    public final void putBlockOfBytes(long from, long len) {
        if (len < this.pageHi - this.appendPointer) {
            Vect.memcpy(this.appendPointer, from, len);
            this.appendPointer += len;
        } else {
            this.putBinSlit(from, len);
        }
    }

    @Override
    public void putBool(long offset, boolean value) {
        this.putByte(offset, (byte)(value ? 1 : 0));
    }

    @Override
    public void putBool(boolean value) {
        this.putByte((byte)(value ? 1 : 0));
    }

    @Override
    public final void putByte(long offset, byte value) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 1L) {
            Unsafe.getUnsafe().putByte(this.absolutePointer + offset, value);
        } else {
            this.putByteRnd(offset, value);
        }
    }

    @Override
    public void putByte(byte value) {
        if (this.pageHi == this.appendPointer) {
            this.pageAt(this.getAppendOffset() + 1L);
        }
        Unsafe.getUnsafe().putByte(this.appendPointer++, value);
    }

    @Override
    public void putChar(long offset, char value) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 2L) {
            Unsafe.getUnsafe().putChar(this.absolutePointer + offset, value);
        } else {
            this.putCharBytes(offset, value);
        }
    }

    @Override
    public final void putChar(char value) {
        if (this.pageHi - this.appendPointer > 1L) {
            Unsafe.getUnsafe().putChar(this.appendPointer, value);
            this.appendPointer += 2L;
        } else {
            this.putCharBytes(value);
        }
    }

    @Override
    public void putDouble(long offset, double value) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 8L) {
            Unsafe.getUnsafe().putDouble(this.absolutePointer + offset, value);
        } else {
            this.putDoubleBytes(offset, value);
        }
    }

    @Override
    public final void putDouble(double value) {
        if (this.pageHi - this.appendPointer > 7L) {
            Unsafe.getUnsafe().putDouble(this.appendPointer, value);
            this.appendPointer += 8L;
        } else {
            this.putDoubleBytes(value);
        }
    }

    @Override
    public void putFloat(long offset, float value) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 4L) {
            Unsafe.getUnsafe().putFloat(this.absolutePointer + offset, value);
        } else {
            this.putFloatBytes(offset, value);
        }
    }

    @Override
    public final void putFloat(float value) {
        if (this.pageHi - this.appendPointer > 3L) {
            Unsafe.getUnsafe().putFloat(this.appendPointer, value);
            this.appendPointer += 4L;
        } else {
            this.putFloatBytes(value);
        }
    }

    @Override
    public void putInt(long offset, int value) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 4L) {
            Unsafe.getUnsafe().putInt(this.absolutePointer + offset, value);
        } else {
            this.putIntBytes(offset, value);
        }
    }

    @Override
    public final void putInt(int value) {
        if (this.pageHi - this.appendPointer > 3L) {
            Unsafe.getUnsafe().putInt(this.appendPointer, value);
            this.appendPointer += 4L;
        } else {
            this.putIntBytes(value);
        }
    }

    @Override
    public void putLong(long offset, long value) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 8L) {
            Unsafe.getUnsafe().putLong(this.absolutePointer + offset, value);
        } else {
            this.putLongBytes(offset, value);
        }
    }

    @Override
    public final void putLong(long value) {
        if (this.pageHi - this.appendPointer > 7L) {
            Unsafe.getUnsafe().putLong(this.appendPointer, value);
            this.appendPointer += 8L;
        } else {
            this.putLongBytes(value);
        }
    }

    @Override
    public final void putLong128(long lo, long hi) {
        if (this.pageHi - this.appendPointer > 15L) {
            Unsafe.getUnsafe().putLong(this.appendPointer, lo);
            Unsafe.getUnsafe().putLong(this.appendPointer + 8L, hi);
            this.appendPointer += 16L;
        } else {
            this.putLong(lo);
            this.putLong(hi);
        }
    }

    @Override
    public void putLong256(long offset, Long256 value) {
        this.putLong256(offset, value.getLong0(), value.getLong1(), value.getLong2(), value.getLong3());
    }

    @Override
    public void putLong256(long offset, long l0, long l1, long l2, long l3) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 32L) {
            Unsafe.getUnsafe().putLong(this.absolutePointer + offset, l0);
            Unsafe.getUnsafe().putLong(this.absolutePointer + offset + 8L, l1);
            Unsafe.getUnsafe().putLong(this.absolutePointer + offset + 16L, l2);
            Unsafe.getUnsafe().putLong(this.absolutePointer + offset + 24L, l3);
        } else {
            this.putLong(offset, l0);
            this.putLong(offset + 8L, l1);
            this.putLong(offset + 16L, l2);
            this.putLong(offset + 24L, l3);
        }
    }

    @Override
    public final void putLong256(long l0, long l1, long l2, long l3) {
        if (this.pageHi - this.appendPointer > 31L) {
            Unsafe.getUnsafe().putLong(this.appendPointer, l0);
            Unsafe.getUnsafe().putLong(this.appendPointer + 8L, l1);
            Unsafe.getUnsafe().putLong(this.appendPointer + 16L, l2);
            Unsafe.getUnsafe().putLong(this.appendPointer + 24L, l3);
            this.appendPointer += 32L;
        } else {
            this.putLong(l0);
            this.putLong(l1);
            this.putLong(l2);
            this.putLong(l3);
        }
    }

    @Override
    public final void putLong256(Long256 value) {
        this.putLong256(value.getLong0(), value.getLong1(), value.getLong2(), value.getLong3());
    }

    @Override
    public final void putLong256(CharSequence hexString) {
        if (this.pageHi - this.appendPointer < 32L) {
            this.straddlingPageLong256Decoder.putLong256(hexString);
        } else {
            this.inPageLong256Decoder.putLong256(hexString);
        }
    }

    @Override
    public final void putLong256(@NotNull CharSequence hexString, int start, int end) {
        if (this.pageHi - this.appendPointer < 32L) {
            this.straddlingPageLong256Decoder.putLong256(hexString, start, end);
        } else {
            this.inPageLong256Decoder.putLong256(hexString, start, end);
        }
    }

    @Override
    public final long putNullBin() {
        this.putLong(-1L);
        return this.getAppendOffset();
    }

    @Override
    public final void putNullStr(long offset) {
        this.putInt(offset, -1);
    }

    @Override
    public final long putNullStr() {
        this.putInt(-1);
        return this.getAppendOffset();
    }

    @Override
    public void putShort(long offset, short value) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 2L) {
            Unsafe.getUnsafe().putShort(this.absolutePointer + offset, value);
        } else {
            this.putShortBytes(offset, value);
        }
    }

    @Override
    public final void putShort(short value) {
        if (this.pageHi - this.appendPointer > 1L) {
            Unsafe.getUnsafe().putShort(this.appendPointer, value);
            this.appendPointer += 2L;
        } else {
            this.putShortBytes(value);
        }
    }

    @Override
    public void putStr(long offset, CharSequence value) {
        if (value == null) {
            this.putNullStr(offset);
        } else {
            this.putStr(offset, value, 0, value.length());
        }
    }

    @Override
    public void putStr(long offset, CharSequence value, int pos, int len) {
        this.putInt(offset, len);
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - (long)len * 2L - 4L) {
            MemoryPARWImpl.copyStrChars(value, pos, len, this.absolutePointer + offset + 4L);
        } else {
            this.putStrSplit(offset + 4L, value, pos, len);
        }
    }

    @Override
    public final long putStr(CharSequence value) {
        return value == null ? this.putNullStr() : this.putStr0(value, 0, value.length());
    }

    @Override
    public final long putStr(char value) {
        if (value == '\u0000') {
            return this.putNullStr();
        }
        this.putInt(1);
        if (this.pageHi - this.appendPointer < 2L) {
            this.putSplitChar(value);
        } else {
            Unsafe.getUnsafe().putChar(this.appendPointer, value);
            this.appendPointer += 2L;
        }
        return this.getAppendOffset();
    }

    @Override
    public final long putStr(CharSequence value, int pos, int len) {
        if (value == null) {
            return this.putNullStr();
        }
        return this.putStr0(value, pos, len);
    }

    @Override
    public long putStrUtf8AsUtf16(DirectByteCharSequence value, boolean hasNonAsciiChars) {
        if (value != null && hasNonAsciiChars) {
            return this.putStrUtf8AsUtf160(value);
        }
        return this.putStr(value);
    }

    @Override
    public long size() {
        return this.getAppendOffset();
    }

    @Override
    public void skip(long bytes) {
        assert (bytes >= 0L);
        if (this.pageHi - this.appendPointer > bytes) {
            this.appendPointer += bytes;
        } else {
            this.skip0(bytes);
        }
    }

    @Override
    public void truncate() {
        this.clear();
    }

    @Override
    public void zero() {
        throw new UnsupportedOperationException();
    }

    private static void copyStrChars(CharSequence value, int pos, int len, long address) {
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i + pos);
            Unsafe.getUnsafe().putChar(address + 2L * (long)i, c);
        }
    }

    private long addressOf0(long offset) {
        return this.computeHotPage(this.pageIndex(offset)) + this.offsetInPage(offset);
    }

    private long computeHotPage(int page) {
        long pageAddress = this.getPageAddress(page);
        assert (pageAddress > 0L);
        return this.computeHotPage(page, pageAddress);
    }

    private long computeHotPage(int page, long pageAddress) {
        this.roOffsetLo = this.pageOffset(page) - 1L;
        this.roOffsetHi = this.roOffsetLo + this.getPageSize() + 1L;
        this.absolutePointer = pageAddress - this.roOffsetLo - 1L;
        return pageAddress;
    }

    private byte getByte0(long offset) {
        return Unsafe.getUnsafe().getByte(this.computeHotPage(this.pageIndex(offset)) + this.offsetInPage(offset));
    }

    private char getChar0(long offset) {
        int page = this.pageIndex(offset);
        long pageOffset = this.offsetInPage(offset);
        long pageSize = this.getPageSize();
        if (pageSize - pageOffset > 1L) {
            return Unsafe.getUnsafe().getChar(this.computeHotPage(page) + pageOffset);
        }
        return this.getCharBytes(page, pageOffset, pageSize);
    }

    private double getDouble0(long offset) {
        int page = this.pageIndex(offset);
        long pageOffset = this.offsetInPage(offset);
        long pageSize = this.getPageSize();
        if (pageSize - pageOffset > 7L) {
            return Unsafe.getUnsafe().getDouble(this.computeHotPage(page) + pageOffset);
        }
        return this.getDoubleBytes(page, pageOffset, pageSize);
    }

    private float getFloat0(long offset) {
        int page = this.pageIndex(offset);
        long pageOffset = this.offsetInPage(offset);
        if (this.getPageSize() - pageOffset > 3L) {
            return Unsafe.getUnsafe().getFloat(this.computeHotPage(page) + pageOffset);
        }
        return this.getFloatBytes(page, pageOffset);
    }

    private int getInt0(long offset) {
        int page = this.pageIndex(offset);
        long pageOffset = this.offsetInPage(offset);
        if (this.getPageSize() - pageOffset > 3L) {
            return Unsafe.getUnsafe().getInt(this.computeHotPage(page) + pageOffset);
        }
        return this.getIntBytes(page, pageOffset);
    }

    private long getLong0(long offset) {
        int page = this.pageIndex(offset);
        long pageOffset = this.offsetInPage(offset);
        long pageSize = this.getPageSize();
        if (pageSize - pageOffset > 7L) {
            return Unsafe.getUnsafe().getLong(this.computeHotPage(page) + pageOffset);
        }
        return this.getLongBytes(page, pageOffset, pageSize);
    }

    private short getShort0(long offset) {
        int page = this.pageIndex(offset);
        long pageOffset = this.offsetInPage(offset);
        long pageSize = this.getPageSize();
        if (pageSize - pageOffset > 1L) {
            return Unsafe.getUnsafe().getShort(this.computeHotPage(page) + pageOffset);
        }
        return this.getShortBytes(page, pageOffset, pageSize);
    }

    private long jumpTo0(long offset) {
        int page = this.pageIndex(offset);
        long pageAddress = this.pageLo = this.mapWritePage(page, offset);
        this.pageHi = this.pageLo + this.getPageSize();
        this.baseOffset = this.pageOffset(page + 1) - this.pageHi;
        this.appendPointer = this.pageLo + this.offsetInPage(offset);
        --this.pageLo;
        this.computeHotPage(page, pageAddress);
        return pageAddress;
    }

    private void pageAt(long offset) {
        int page = this.pageIndex(offset);
        this.updateLimits(page, this.mapWritePage(page, offset));
    }

    private void putBin0(BinarySequence value, long len, long remaining) {
        long pos = 0L;
        do {
            this.putBinSequence(value, pos, remaining);
            pos += remaining;
            this.pageAt(this.baseOffset + this.pageHi);
        } while ((len -= remaining) >= (remaining = this.pageHi - this.appendPointer));
        this.putBinSequence(value, pos, len);
        this.appendPointer += len;
    }

    private void putBinSequence(BinarySequence value, long pos, long len) {
        value.copyTo(this.appendPointer, pos, len);
    }

    private void putBinSlit(long start, long len) {
        while (true) {
            int half;
            if (len <= (long)(half = (int)(this.pageHi - this.appendPointer))) {
                Vect.memcpy(this.appendPointer, start, len);
                this.appendPointer += len;
                break;
            }
            Vect.memcpy(this.appendPointer, start, half);
            this.pageAt(this.getAppendOffset() + (long)half);
            len -= (long)half;
            start += (long)half;
        }
    }

    private void putByteRnd(long offset, byte value) {
        Unsafe.getUnsafe().putByte(this.jumpTo0(offset) + this.offsetInPage(offset), value);
    }

    private void putLong256Null() {
        Long256Impl.putNull(this.appendPointer);
    }

    private void putSplitChar(char c) {
        this.putByte((byte)c);
        this.putByte((byte)(c >> 8));
    }

    private long putStr0(CharSequence value, int pos, int len) {
        this.putInt(len);
        if (this.pageHi - this.appendPointer < (long)len << 1) {
            this.putStrSplit(value, pos, len);
        } else {
            MemoryPARWImpl.copyStrChars(value, pos, len, this.appendPointer);
            this.appendPointer += (long)len * 2L;
        }
        return this.getAppendOffset();
    }

    private void putStrSplit(long offset, CharSequence value, int pos, int len) {
        int start = pos;
        while (true) {
            int half;
            if (len <= (half = (int)((this.roOffsetHi - offset) / 2L))) break;
            MemoryPARWImpl.copyStrChars(value, start, half, this.absolutePointer + offset);
            if ((offset += (long)half * 2L) < this.roOffsetHi) {
                char c = value.charAt(start + half);
                this.putByte(offset, (byte)c);
                this.putByte(offset + 1L, (byte)(c >> 8));
                offset += 2L;
                ++half;
            } else {
                this.jumpTo0(offset);
            }
            len -= half;
            start += half;
        }
        MemoryPARWImpl.copyStrChars(value, start, len, this.absolutePointer + offset);
    }

    private void putStrSplit(CharSequence value, int pos, int len) {
        int end = pos + len;
        int at = pos;
        while (at < end) {
            this.putSplitChar(value.charAt(at++));
        }
    }

    private long putStrUtf8AsUtf160(DirectByteCharSequence value) {
        int estimatedLen = value.length() * 2;
        if (this.pageHi - this.appendPointer < (long)(estimatedLen + 4)) {
            this.utf8StrSink.clear();
            CharSequence utf16 = Chars.utf8ToUtf16(value, this.utf8StrSink, true);
            this.putInt(utf16.length());
            this.putStrSplit(this.utf8StrSink, 0, utf16.length());
        } else {
            this.utf8FloatingSink.of(this.appendPointer + 4L, this.appendPointer + (long)estimatedLen + 4L);
            CharSequence utf16 = Chars.utf8ToUtf16(value, this.utf8FloatingSink, true);
            this.putInt(utf16.length());
            this.appendPointer = this.utf8FloatingSink.getLo();
        }
        return this.getAppendOffset();
    }

    private void skip0(long bytes) {
        this.jumpTo(this.getAppendOffset() + bytes);
    }

    protected long allocateNextPage(int page) {
        LOG.debug().$("new page [size=").$(this.getExtendSegmentSize()).I$();
        if (page >= this.maxPages) {
            throw LimitOverflowException.instance().put("Maximum number of pages (").put(this.maxPages).put(") breached in VirtualMemory");
        }
        return Unsafe.malloc(this.getExtendSegmentSize(), this.memoryTag);
    }

    protected long cachePageAddress(int index, long address) {
        this.pages.extendAndSet(index, address);
        return address;
    }

    char getCharBytes(int page, long pageOffset, long pageSize) {
        char value = '\u0000';
        long pageAddress = this.getPageAddress(page);
        for (int i = 0; i < 2; ++i) {
            if (pageOffset == pageSize) {
                pageAddress = this.getPageAddress(++page);
                pageOffset = 0L;
            }
            char b = (char)Unsafe.getUnsafe().getByte(pageAddress + pageOffset++);
            value = (char)(b << 8 * i | value);
        }
        return value;
    }

    double getDoubleBytes(int page, long pageOffset, long pageSize) {
        return Double.longBitsToDouble(this.getLongBytes(page, pageOffset, pageSize));
    }

    float getFloatBytes(int page, long pageOffset) {
        return Float.intBitsToFloat(this.getIntBytes(page, pageOffset));
    }

    int getIntBytes(int page, long pageOffset) {
        int value = 0;
        long pageAddress = this.getPageAddress(page);
        long pageSize = this.getPageSize();
        for (int i = 0; i < 4; ++i) {
            if (pageOffset == pageSize) {
                pageAddress = this.getPageAddress(++page);
                pageOffset = 0L;
            }
            int b = Unsafe.getUnsafe().getByte(pageAddress + pageOffset++) & 0xFF;
            value = b << 8 * i | value;
        }
        return value;
    }

    long getLongBytes(int page, long pageOffset, long pageSize) {
        long value = 0L;
        long pageAddress = this.getPageAddress(page);
        for (int i = 0; i < 8; ++i) {
            if (pageOffset == pageSize) {
                pageAddress = this.getPageAddress(++page);
                pageOffset = 0L;
            }
            long b = Unsafe.getUnsafe().getByte(pageAddress + pageOffset++) & 0xFF;
            value = b << 8 * i | value;
        }
        return value;
    }

    short getShortBytes(int page, long pageOffset, long pageSize) {
        short value = 0;
        long pageAddress = this.getPageAddress(page);
        for (int i = 0; i < 2; ++i) {
            if (pageOffset == pageSize) {
                pageAddress = this.getPageAddress(++page);
                assert (pageAddress != 0L);
                pageOffset = 0L;
            }
            short b = (short)(Unsafe.getUnsafe().getByte(pageAddress + pageOffset++) & 0xFF);
            value = (short)(b << 8 * i | value);
        }
        return value;
    }

    protected long mapWritePage(int page, long offset) {
        long address;
        if (page < this.pages.size() && (address = this.pages.getQuick(page)) != 0L) {
            return address;
        }
        return this.cachePageAddress(page, this.allocateNextPage(page));
    }

    protected final long pageOffset(int page) {
        return (long)page << this.extendSegmentMsb;
    }

    void putCharBytes(char value) {
        this.putByte((byte)(value & 0xFF));
        this.putByte((byte)(value >> 8 & 0xFF));
    }

    void putCharBytes(long offset, char value) {
        this.putByte(offset, (byte)(value & 0xFF));
        this.putByte(offset + 1L, (byte)(value >> 8 & 0xFF));
    }

    void putDoubleBytes(double value) {
        this.putLongBytes(Double.doubleToLongBits(value));
    }

    void putDoubleBytes(long offset, double value) {
        this.putLongBytes(offset, Double.doubleToLongBits(value));
    }

    void putFloatBytes(float value) {
        this.putIntBytes(Float.floatToIntBits(value));
    }

    void putFloatBytes(long offset, float value) {
        this.putIntBytes(offset, Float.floatToIntBits(value));
    }

    void putIntBytes(int value) {
        this.putByte((byte)(value & 0xFF));
        this.putByte((byte)(value >> 8 & 0xFF));
        this.putByte((byte)(value >> 16 & 0xFF));
        this.putByte((byte)(value >> 24 & 0xFF));
    }

    void putIntBytes(long offset, int value) {
        this.putByte(offset, (byte)(value & 0xFF));
        this.putByte(offset + 1L, (byte)(value >> 8 & 0xFF));
        this.putByte(offset + 2L, (byte)(value >> 16 & 0xFF));
        this.putByte(offset + 3L, (byte)(value >> 24 & 0xFF));
    }

    void putLongBytes(long value) {
        this.putByte((byte)(value & 0xFFL));
        this.putByte((byte)(value >> 8 & 0xFFL));
        this.putByte((byte)(value >> 16 & 0xFFL));
        this.putByte((byte)(value >> 24 & 0xFFL));
        this.putByte((byte)(value >> 32 & 0xFFL));
        this.putByte((byte)(value >> 40 & 0xFFL));
        this.putByte((byte)(value >> 48 & 0xFFL));
        this.putByte((byte)(value >> 56 & 0xFFL));
    }

    void putLongBytes(long offset, long value) {
        this.putByte(offset, (byte)(value & 0xFFL));
        this.putByte(offset + 1L, (byte)(value >> 8 & 0xFFL));
        this.putByte(offset + 2L, (byte)(value >> 16 & 0xFFL));
        this.putByte(offset + 3L, (byte)(value >> 24 & 0xFFL));
        this.putByte(offset + 4L, (byte)(value >> 32 & 0xFFL));
        this.putByte(offset + 5L, (byte)(value >> 40 & 0xFFL));
        this.putByte(offset + 6L, (byte)(value >> 48 & 0xFFL));
        this.putByte(offset + 7L, (byte)(value >> 56 & 0xFFL));
    }

    void putShortBytes(short value) {
        this.putByte((byte)(value & 0xFF));
        this.putByte((byte)(value >> 8 & 0xFF));
    }

    void putShortBytes(long offset, short value) {
        this.putByte(offset, (byte)(value & 0xFF));
        this.putByte(offset + 1L, (byte)(value >> 8 & 0xFF));
    }

    protected void release(long address) {
        if (address != 0L) {
            Unsafe.free(address, this.getPageSize(), this.memoryTag);
        }
    }

    protected void releaseAllPagesButFirst() {
        int n = this.pages.size();
        for (int i = 1; i < n; ++i) {
            this.release(this.pages.getQuick(i));
            this.pages.setQuick(i, 0L);
        }
        if (n > 0) {
            this.pages.setPos(1);
        }
    }

    protected final void setExtendSegmentSize(long extendSegmentSize) {
        this.clear();
        this.extendSegmentSize = Numbers.ceilPow2(extendSegmentSize);
        this.extendSegmentMsb = Numbers.msb(this.extendSegmentSize);
        this.extendSegmentMod = this.extendSegmentSize - 1L;
    }

    protected final void updateLimits(int page, long pageAddress) {
        this.pageLo = pageAddress - 1L;
        this.pageHi = pageAddress + this.getPageSize();
        this.baseOffset = this.pageOffset(page + 1) - this.pageHi;
        this.appendPointer = pageAddress;
    }

    private class StraddlingPageLong256FromCharSequenceDecoder
    extends Long256FromCharSequenceDecoder {
        private StraddlingPageLong256FromCharSequenceDecoder() {
        }

        @Override
        public void setAll(long l0, long l1, long l2, long l3) {
            MemoryPARWImpl.this.putLong(l0);
            MemoryPARWImpl.this.putLong(l1);
            MemoryPARWImpl.this.putLong(l2);
            MemoryPARWImpl.this.putLong(l3);
        }

        private void putLong256(CharSequence hexString) {
            int len;
            if (hexString == null || (len = hexString.length()) == 0) {
                MemoryPARWImpl.this.putLong(Long256Impl.NULL_LONG256.getLong0());
                MemoryPARWImpl.this.putLong(Long256Impl.NULL_LONG256.getLong1());
                MemoryPARWImpl.this.putLong(Long256Impl.NULL_LONG256.getLong2());
                MemoryPARWImpl.this.putLong(Long256Impl.NULL_LONG256.getLong3());
            } else {
                this.putLong256(hexString, 2, len);
            }
        }

        private void putLong256(CharSequence hexString, int start, int end) {
            StraddlingPageLong256FromCharSequenceDecoder.decode(hexString, start, end, this);
        }
    }

    private class InPageLong256FromCharSequenceDecoder
    extends Long256FromCharSequenceDecoder {
        private InPageLong256FromCharSequenceDecoder() {
        }

        @Override
        public void setAll(long l0, long l1, long l2, long l3) {
            Unsafe.getUnsafe().putLong(MemoryPARWImpl.this.appendPointer, l0);
            Unsafe.getUnsafe().putLong(MemoryPARWImpl.this.appendPointer + 8L, l1);
            Unsafe.getUnsafe().putLong(MemoryPARWImpl.this.appendPointer + 16L, l2);
            Unsafe.getUnsafe().putLong(MemoryPARWImpl.this.appendPointer + 24L, l3);
        }

        private void putLong256(CharSequence hexString) {
            int len;
            if (hexString == null || (len = hexString.length()) == 0) {
                MemoryPARWImpl.this.putLong256Null();
                MemoryPARWImpl.this.appendPointer = MemoryPARWImpl.this.appendPointer + 32L;
            } else {
                this.putLong256(hexString, 2, len);
            }
        }

        private void putLong256(CharSequence hexString, int start, int end) {
            InPageLong256FromCharSequenceDecoder.decode(hexString, start, end, MemoryPARWImpl.this.inPageLong256Decoder);
            MemoryPARWImpl.this.appendPointer = MemoryPARWImpl.this.appendPointer + 32L;
        }
    }

    public class CharSequenceView
    extends AbstractCharSequence {
        private int len;
        private long offset;

        @Override
        public char charAt(int index) {
            return MemoryPARWImpl.this.getChar(this.offset + (long)index * 2L);
        }

        @Override
        public int length() {
            return this.len;
        }

        CharSequenceView of(long offset, int len) {
            this.offset = offset;
            this.len = len;
            return this;
        }
    }

    private class ByteSequenceView
    implements BinarySequence {
        private long lastIndex = -1L;
        private long len = -1L;
        private long offset;
        private long readAddress;
        private long readLimit;

        private ByteSequenceView() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte byteAt(long index) {
            try {
                if (index == this.lastIndex + 1L && this.readAddress < this.readLimit) {
                    byte by = Unsafe.getUnsafe().getByte(this.readAddress++);
                    return by;
                }
                byte by = this.updatePosAndGet(index);
                return by;
            }
            finally {
                this.lastIndex = index;
            }
        }

        @Override
        public void copyTo(long address, long start, long length) {
            MemoryPARWImpl.this.copyTo(address, this.offset + start, Math.min(length, this.len - start));
        }

        @Override
        public long length() {
            return this.len;
        }

        private void calculateBlobAddress(long offset) {
            int page = MemoryPARWImpl.this.pageIndex(offset);
            long pa = MemoryPARWImpl.this.getPageAddress(page);
            this.readAddress = pa + MemoryPARWImpl.this.offsetInPage(offset);
            this.readLimit = pa + MemoryPARWImpl.this.getPageSize();
        }

        private byte updatePosAndGet(long index) {
            this.calculateBlobAddress(this.offset + index);
            return Unsafe.getUnsafe().getByte(this.readAddress++);
        }

        ByteSequenceView of(long offset, long len) {
            this.offset = offset;
            this.len = len;
            this.lastIndex = -1L;
            this.calculateBlobAddress(offset);
            return this;
        }
    }
}

