/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.skin.SkinMetadata;
import org.apache.myfaces.trinidadinternal.renderkit.core.skin.CasablancaDesktopSkin;
import org.apache.myfaces.trinidadinternal.renderkit.core.skin.CasablancaPdaSkin;
import org.apache.myfaces.trinidadinternal.renderkit.core.skin.CasablancaPortletSkin;
import org.apache.myfaces.trinidadinternal.renderkit.core.skin.MinimalDesktopSkinExtension;
import org.apache.myfaces.trinidadinternal.renderkit.core.skin.MinimalPdaSkinExtension;
import org.apache.myfaces.trinidadinternal.renderkit.core.skin.MinimalPortletSkinExtension;
import org.apache.myfaces.trinidadinternal.renderkit.core.skin.SimpleDesktopSkin;
import org.apache.myfaces.trinidadinternal.renderkit.core.skin.SimplePdaSkin;
import org.apache.myfaces.trinidadinternal.renderkit.core.skin.SimplePortletSkin;
import org.apache.myfaces.trinidadinternal.skin.SkinImpl;
import org.apache.myfaces.trinidadinternal.skin.provider.BaseSkinProvider;

public class TrinidadBaseSkinProvider
extends BaseSkinProvider {
    private static final Collection<SkinMetadata> _METADATA;
    private static final SkinMetadata _SIMPLE_DESKTOP_METADATA;
    private static final SkinMetadata _SIMPLE_PDA_METADATA;
    private static final SkinMetadata _SIMPLE_PORTLET_METADATA;
    private static final SkinMetadata _MINIMAL_DESKTOP_METADATA;
    private static final SkinMetadata _MINIMAL_PORTLET_METADATA;
    private static final SkinMetadata _MINIMAL_PDA_METADATA;
    private static final SkinMetadata _CASABLANCA_DESKTOP_METADATA;
    private static final SkinMetadata _CASABLANCA_PDA_METADATA;
    private static final SkinMetadata _CASABLANCA_PORTLET_METADATA;

    @Override
    public Collection<SkinMetadata> getSkinMetadata(ExternalContext context) {
        return Collections.unmodifiableCollection(_METADATA);
    }

    @Override
    protected Skin loadAvailableSkin(ExternalContext context, SkinMetadata search) {
        Skin skin = this.getSkins().get(search);
        if (skin != null) {
            return skin;
        }
        SkinImpl loadedSkin = null;
        Skin parentSkin = null;
        if (search == _CASABLANCA_DESKTOP_METADATA) {
            parentSkin = this._loadBaseSkinAndRegisterIfRequired(context, _SIMPLE_DESKTOP_METADATA);
            loadedSkin = new CasablancaDesktopSkin(parentSkin);
        } else if (search == _CASABLANCA_PDA_METADATA) {
            parentSkin = this._loadBaseSkinAndRegisterIfRequired(context, _SIMPLE_PDA_METADATA);
            loadedSkin = new CasablancaPdaSkin(parentSkin);
        } else if (search == _CASABLANCA_PORTLET_METADATA) {
            parentSkin = this._loadBaseSkinAndRegisterIfRequired(context, _SIMPLE_PORTLET_METADATA);
            loadedSkin = new CasablancaPortletSkin(parentSkin);
        } else if (search == _MINIMAL_DESKTOP_METADATA) {
            parentSkin = this._loadBaseSkinAndRegisterIfRequired(context, _SIMPLE_DESKTOP_METADATA);
            loadedSkin = new MinimalDesktopSkinExtension(parentSkin);
        } else if (search == _MINIMAL_PDA_METADATA) {
            parentSkin = this._loadBaseSkinAndRegisterIfRequired(context, _SIMPLE_PDA_METADATA);
            loadedSkin = new MinimalPdaSkinExtension(parentSkin);
        } else if (search == _MINIMAL_PORTLET_METADATA) {
            parentSkin = this._loadBaseSkinAndRegisterIfRequired(context, _SIMPLE_PORTLET_METADATA);
            loadedSkin = new MinimalPortletSkinExtension(parentSkin);
        } else if (search == _SIMPLE_DESKTOP_METADATA) {
            loadedSkin = new SimpleDesktopSkin();
        } else if (search == _SIMPLE_PDA_METADATA) {
            loadedSkin = new SimplePdaSkin();
        } else if (search == _SIMPLE_PORTLET_METADATA) {
            loadedSkin = new SimplePortletSkin();
        }
        return loadedSkin;
    }

    private Skin _loadBaseSkinAndRegisterIfRequired(ExternalContext context, SkinMetadata metadata) {
        Skin skin = this.getSkins().get(metadata);
        if (skin == null) {
            skin = this.loadAvailableSkin(context, metadata);
            this.addSkin(metadata, skin);
        }
        return skin;
    }

    static {
        _SIMPLE_DESKTOP_METADATA = new SkinMetadata.Builder().id("simple.desktop").family("simple").renderKitId(SkinMetadata.RenderKitId.DESKTOP).styleSheetName("META-INF/adf/styles/simple-desktop.css").build();
        _SIMPLE_PDA_METADATA = new SkinMetadata.Builder().id("simple.pda").family("simple").renderKitId(SkinMetadata.RenderKitId.PDA).styleSheetName("META-INF/adf/styles/simple-pda.css").build();
        _SIMPLE_PORTLET_METADATA = new SkinMetadata.Builder().id("simple.portlet").family("simple").renderKitId(SkinMetadata.RenderKitId.PORTLET).styleSheetName("META-INF/adf/styles/simple-portlet.css").build();
        _MINIMAL_DESKTOP_METADATA = new SkinMetadata.Builder().id("minimal.desktop").family("minimal").renderKitId(SkinMetadata.RenderKitId.DESKTOP).baseSkinId("simple.desktop").styleSheetName("META-INF/adf/styles/minimal-desktop.css").build();
        _MINIMAL_PDA_METADATA = new SkinMetadata.Builder().id("minimal.pda").family("minimal").renderKitId(SkinMetadata.RenderKitId.PDA).baseSkinId("simple.pda").styleSheetName("META-INF/adf/styles/minimal-pda.css").build();
        _MINIMAL_PORTLET_METADATA = new SkinMetadata.Builder().id("minimal.portlet").family("minimal").renderKitId(SkinMetadata.RenderKitId.PORTLET).baseSkinId("simple.portlet").styleSheetName("META-INF/adf/styles/simple-portlet.css").build();
        _CASABLANCA_DESKTOP_METADATA = new SkinMetadata.Builder().id("casablanca.desktop").family("casablanca").renderKitId(SkinMetadata.RenderKitId.DESKTOP).baseSkinId("simple.desktop").styleSheetName("META-INF/adf/styles/casablancaSkin.css").build();
        _CASABLANCA_PDA_METADATA = new SkinMetadata.Builder().id("casablanca.pda").family("casablanca").renderKitId(SkinMetadata.RenderKitId.PDA).baseSkinId("simple.pda").styleSheetName("META-INF/adf/styles/casablancaSkin.css").build();
        _CASABLANCA_PORTLET_METADATA = new SkinMetadata.Builder().id("casablanca.portlet").family("casablanca").renderKitId(SkinMetadata.RenderKitId.PORTLET).baseSkinId("simple.portlet").build();
        _METADATA = new ArrayList<SkinMetadata>(9);
        _METADATA.add(_SIMPLE_DESKTOP_METADATA);
        _METADATA.add(_SIMPLE_PDA_METADATA);
        _METADATA.add(_SIMPLE_PORTLET_METADATA);
        _METADATA.add(_MINIMAL_DESKTOP_METADATA);
        _METADATA.add(_MINIMAL_PDA_METADATA);
        _METADATA.add(_MINIMAL_PORTLET_METADATA);
        _METADATA.add(_CASABLANCA_DESKTOP_METADATA);
        _METADATA.add(_CASABLANCA_PDA_METADATA);
        _METADATA.add(_CASABLANCA_PORTLET_METADATA);
    }
}

