/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import javax.faces.component.ActionSource;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXComponentBase;
import org.apache.myfaces.trinidad.util.ComponentUtils;

public class UIXProgress
extends UIXComponentBase
implements ActionSource {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXComponentBase.TYPE);
    public static final PropertyKey VALUE_KEY = TYPE.registerKey("value", Object.class, null, 0, PropertyKey.Mutable.SOMETIMES);
    public static final PropertyKey ACTION_KEY = TYPE.registerKey("action", MethodBinding.class, 9);
    public static final PropertyKey ACTION_LISTENER_KEY = TYPE.registerKey("actionListener", MethodBinding.class, 9);
    public static final PropertyKey IMMEDIATE_KEY = TYPE.registerKey("immediate", Boolean.class, Boolean.FALSE);
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.Progress";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.Progress";

    public UIXProgress() {
        super("org.apache.myfaces.trinidad.Indicator");
    }

    @Override
    public void queueEvent(FacesEvent e) {
        if (e.getSource() == this && e instanceof ActionEvent) {
            if (this.isImmediate()) {
                e.setPhaseId(PhaseId.ANY_PHASE);
            } else {
                e.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(e);
    }

    @Override
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof ActionEvent) {
            ActionListener defaultActionListener;
            FacesContext context = this.getFacesContext();
            MethodBinding mb = this.getActionListener();
            if (mb != null) {
                mb.invoke(context, new Object[]{event});
            }
            if ((defaultActionListener = context.getApplication().getActionListener()) != null) {
                defaultActionListener.processAction((ActionEvent)event);
            }
        }
    }

    public final Object getValue() {
        return this.getProperty(VALUE_KEY);
    }

    public final void setValue(Object value) {
        this.setProperty(VALUE_KEY, value);
    }

    public final MethodBinding getAction() {
        return (MethodBinding)this.getProperty(ACTION_KEY);
    }

    public final void setAction(MethodBinding action) {
        this.setProperty(ACTION_KEY, action);
    }

    public final MethodBinding getActionListener() {
        return (MethodBinding)this.getProperty(ACTION_LISTENER_KEY);
    }

    public final void setActionListener(MethodBinding actionListener) {
        this.setProperty(ACTION_LISTENER_KEY, actionListener);
    }

    public final boolean isImmediate() {
        return ComponentUtils.resolveBoolean(this.getProperty(IMMEDIATE_KEY), false);
    }

    public final void setImmediate(boolean immediate) {
        this.setProperty(IMMEDIATE_KEY, immediate ? Boolean.TRUE : Boolean.FALSE);
    }

    public final void addActionListener(ActionListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public final void removeActionListener(ActionListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public final ActionListener[] getActionListeners() {
        return (ActionListener[])this.getFacesListeners(ActionListener.class);
    }

    @Override
    public String getFamily() {
        return "org.apache.myfaces.trinidad.Progress";
    }

    @Override
    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXProgress(String rendererType) {
        super(rendererType);
    }

    static {
        TYPE.lockAndRegister("org.apache.myfaces.trinidad.Progress", "org.apache.myfaces.trinidad.Indicator");
    }
}

