/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.layout.CoreShowDetailHeader;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PanelHeaderRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.ShowDetailRenderer;

public class ShowDetailHeaderRenderer
extends PanelHeaderRenderer {
    private CoreRenderer _detailRenderer;
    private PropertyKey _disclosedKey;
    private static final Map<String, String> _RESOURCE_KEY_MAP = new HashMap<String, String>();

    public ShowDetailHeaderRenderer() {
        super(CoreShowDetailHeader.TYPE);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._detailRenderer = new DetailRenderer(type);
        this._disclosedKey = type.findKey("disclosed");
    }

    protected void decode(FacesContext facesContext, UIComponent component, FacesBean facesBean, String clientId) {
        this._detailRenderer.decode(facesContext, component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        Map originalResourceKeyMap = rc.getSkinResourceKeyMap();
        try {
            rc.setSkinResourceKeyMap(_RESOURCE_KEY_MAP);
            super.encodeAll(context, rc, component, bean);
        }
        finally {
            rc.setSkinResourceKeyMap(originalResourceKeyMap);
        }
    }

    @Override
    protected void renderIcon(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, String messageType) throws IOException {
        this.delegateRenderer(context, rc, component, bean, this._detailRenderer);
        super.renderIcon(context, rc, component, bean, messageType);
    }

    @Override
    protected String getMessageType(UIComponent component, FacesBean bean) {
        return null;
    }

    protected boolean getDisclosed(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._disclosedKey);
        if (o == null) {
            o = this._disclosedKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    @Override
    protected boolean shouldRenderChildren(UIComponent component, FacesBean bean) {
        return this.getDisclosed(component, bean);
    }

    static {
        _RESOURCE_KEY_MAP.put("af_showDetail.DISCLOSED", "af_showDetailHeader.DISCLOSED");
        _RESOURCE_KEY_MAP.put("af_showDetail.UNDISCLOSED", "af_showDetailHeader.UNDISCLOSED");
        _RESOURCE_KEY_MAP.put("af_showDetail.DISCLOSED_TIP", "af_showDetailHeader.DISCLOSED_TIP");
        _RESOURCE_KEY_MAP.put("af_showDetail.UNDISCLOSED_TIP", "af_showDetailHeader.UNDISCLOSED_TIP");
        _RESOURCE_KEY_MAP.put("af|panelHeader", "af|showDetailHeader");
        _RESOURCE_KEY_MAP.put("af|showDetail::disclosed-icon", "af|showDetailHeader::disclosed-icon");
        _RESOURCE_KEY_MAP.put("af|showDetail::undisclosed-icon", "af|showDetailHeader::undisclosed-icon");
    }

    private static class DetailRenderer
    extends ShowDetailRenderer {
        public DetailRenderer(FacesBean.Type type) {
            super(type);
        }

        protected void renderId(FacesContext context, UIComponent component) throws IOException {
        }

        @Override
        protected void renderAllAttributes(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        }

        @Override
        protected boolean renderAsInline() {
            return true;
        }

        @Override
        protected String getDisclosureText(RenderingContext rc, UIComponent component, FacesBean bean, boolean disclosed) {
            return null;
        }
    }
}

