/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.input.CoreInputListOfValues;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.ReturnEvent;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.agent.AgentUtil;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AutoSubmitUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PartialPageUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleInputTextRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class SimpleInputListOfValuesRenderer
extends SimpleInputTextRenderer {
    private PropertyKey _actionExpressionKey;
    private PropertyKey _iconKey;
    private PropertyKey _searchDescKey;
    private static final String _BUTTON_PART = "b";
    private static final String _PART_PARAMETER = "part";
    private static final String _BUTTON_AND_PART_PARAMETER = "part:'b'";

    public SimpleInputListOfValuesRenderer() {
        this(CoreInputListOfValues.TYPE);
    }

    public SimpleInputListOfValuesRenderer(FacesBean.Type type) {
        super(type);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._searchDescKey = type.findKey("searchDesc");
        this._iconKey = type.findKey("icon");
        this._actionExpressionKey = type.findKey("actionExpression");
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        RequestContext afContext = RequestContext.getCurrentInstance();
        ReturnEvent returnEvent = afContext.getDialogService().getReturnEvent(component);
        if (returnEvent != null) {
            afContext.addPartialTarget(component);
            this.queueReturnEvent(context, component, returnEvent);
        } else {
            Object part;
            Map parameterMap = context.getExternalContext().getRequestParameterMap();
            Object source = parameterMap.get("source");
            String clientId = component.getClientId(context);
            if (source != null && source.equals(clientId) && _BUTTON_PART.equals(part = parameterMap.get(_PART_PARAMETER))) {
                TrinidadAgent agent = AgentUtil.getAgent(context);
                if (XhtmlUtils.supportsSeparateWindow(agent)) {
                    PartialPageUtils.forcePartialRendering(context);
                }
                this.queueActionEvent(context, component);
            }
        }
    }

    protected void queueReturnEvent(FacesContext context, UIComponent component, ReturnEvent event) {
        event.queue();
    }

    protected void queueActionEvent(FacesContext context, UIComponent component) {
        new ActionEvent(component).queue();
    }

    protected void encodeAllAsElement(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        boolean simple = this.getSimple(bean);
        if (simple) {
            rw.startElement("span", component);
            this.renderRootDomElementStyles(context, arc, component, bean);
        }
        this.renderTextField(context, arc, component, bean);
        this.renderAfterTextField(context, arc, component, bean);
        if (simple) {
            rw.endElement("span");
        }
    }

    protected void encodeAllAsNonElement(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        boolean simple = this.getSimple(bean);
        if (simple) {
            rw.startElement("span", component);
            this.renderRootDomElementStyles(context, arc, component, bean);
        }
        super.encodeAllAsNonElement(context, arc, component, bean);
        if (simple) {
            rw.endElement("span");
        }
    }

    protected boolean isSimpleInputText(FacesBean bean) {
        return false;
    }

    protected void renderTextField(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        super.encodeAllAsElement(context, arc, component, bean);
    }

    protected void renderAfterTextField(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        if (!this.getDisabled(bean)) {
            this.renderSpacer(context, arc, "8", "1");
            this.renderIcon(context, arc, component, bean);
        }
    }

    protected void renderIcon(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        Icon icon;
        String iconUri = this.getIcon(bean);
        if (iconUri == null) {
            icon = arc.getIcon(this.getButtonIconName());
            if (icon == null || icon.isNull()) {
                return;
            }
        } else {
            icon = null;
        }
        String onclick = this.getLaunchOnclick(context, arc, component, bean);
        String buttonOnclick = this.getButtonOnclick(bean);
        if (buttonOnclick != null) {
            onclick = XhtmlUtils.getChainedJS(buttonOnclick, onclick, true);
        }
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("a", component);
        rw.writeURIAttribute("href", (Object)"#", null);
        rw.writeAttribute("onclick", (Object)onclick, null);
        String align = OutputUtils.getMiddleIconAlignment(arc);
        String title = this.getSearchDesc(bean);
        if (iconUri != null) {
            rw.startElement("img", null);
            rw.writeAttribute("border", (Object)"0", null);
            this.renderEncodedResourceURI(context, "src", iconUri);
            OutputUtils.renderAltAndTooltipForImage(context, arc, title);
            rw.writeAttribute("align", (Object)align, null);
            rw.endElement("img");
        } else {
            OutputUtils.renderIcon(context, arc, icon, title, align);
        }
        rw.endElement("a");
    }

    protected String getButtonIconName() {
        return "af|inputListOfValues::button-icon";
    }

    protected String getButtonOnclick(FacesBean bean) {
        return super.getOnclick(bean);
    }

    protected String getLaunchOnclick(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        FormData fd = arc.getFormData();
        if (fd == null) {
            return null;
        }
        fd.addNeededValue(_PART_PARAMETER);
        fd.addNeededValue("source");
        if (SimpleInputListOfValuesRenderer.supportsSeparateWindow(arc)) {
            AutoSubmitUtils.writeDependencies(context, arc);
            return AutoSubmitUtils.getSubmitScript(arc, this.getClientId(context, component), true, false, null, _BUTTON_AND_PART_PARAMETER, false);
        }
        return AutoSubmitUtils.getFullPageSubmitScript(arc, this.getClientId(context, component), true, null, _BUTTON_AND_PART_PARAMETER, false);
    }

    public boolean isTextArea(FacesBean bean) {
        return false;
    }

    protected boolean getSecret(FacesBean bean) {
        return false;
    }

    protected String getOnclick(FacesBean bean) {
        if (this.shouldRenderInputOnclick()) {
            return null;
        }
        return super.getOnclick(bean);
    }

    protected boolean shouldRenderInputOnclick() {
        return true;
    }

    protected Object getActionExpression(FacesBean bean) {
        return bean.getProperty(this._actionExpressionKey);
    }

    protected String getSearchDesc(FacesBean bean) {
        return SimpleInputListOfValuesRenderer.toString((Object)bean.getProperty(this._searchDescKey));
    }

    protected String getIcon(FacesBean bean) {
        if (this._iconKey == null) {
            return null;
        }
        return SimpleInputListOfValuesRenderer.toResourceUri((FacesContext)FacesContext.getCurrentInstance(), (Object)bean.getProperty(this._iconKey));
    }

    protected String getRootStyleClass(FacesBean bean) {
        return "af|inputListOfValues";
    }

    protected String getContentStyleClass(FacesBean bean) {
        return "af|inputListOfValues::content";
    }
}

