/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.io;

import java.io.IOException;
import java.io.Writer;
import org.apache.myfaces.trinidadinternal.io.XMLEscapes;

public class HTMLEscapes {
    private static final String[] _ATTRIBUTE_ENTITIES = (String[])XMLEscapes.__BASE_ENTITIES.clone();
    private static String[] _sISO8859_1_Entities;
    private static final char _UNICODE_LINE_BREAK = '\u2028';
    private static final char _UNICODE_HYPHENATION_POINT = '\u2027';

    public static void writeText(Writer out, char[] buff, char[] text, int start, int length) throws IOException {
        HTMLEscapes._writeText(out, XMLEscapes.__BODY_ENTITIES, buff, text, start, length, true);
    }

    public static void writeText(Writer out, char[] buff, String text) throws IOException {
        HTMLEscapes._writeText(out, XMLEscapes.__BODY_ENTITIES, buff, text, true);
    }

    public static void writeAttribute(Writer out, char[] buff, String attributeValue) throws IOException {
        HTMLEscapes._writeText(out, _ATTRIBUTE_ENTITIES, buff, attributeValue, false);
    }

    private static void _writeText(Writer out, String[] entities, char[] buff, char[] text, int start, int length, boolean isBodyText) throws IOException {
        int buffIndex = 0;
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char ch = text[i];
            if (ch < '\u00a0') {
                String entity;
                if (ch >= '?') {
                    buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, ch);
                    continue;
                }
                if (ch > '\r') {
                    entity = entities[ch];
                    if (entity == null) {
                        buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, ch);
                        continue;
                    }
                    if (ch == '&' && !isBodyText && i + 1 < length && text[i + 1] == '{') {
                        buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, ch);
                        continue;
                    }
                    buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, entity);
                    continue;
                }
                entity = entities[ch];
                if (entity != null) {
                    buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, entity);
                    continue;
                }
                buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                HTMLEscapes._println(out);
                char checkChar = (char)(ch == '\r' ? 10 : 13);
                if (i + 1 >= length || text[i + 1] != checkChar) continue;
                ++i;
                continue;
            }
            if (ch <= '\u00ff') {
                buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, _sISO8859_1_Entities[ch - 160]);
                continue;
            }
            if (ch >= '\ufffe') continue;
            if (isBodyText) {
                if (ch == '\u2028') {
                    buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, "<br>");
                    continue;
                }
                if (ch == '\u2027') {
                    buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, "<wbr>");
                    continue;
                }
                buffIndex = HTMLEscapes._writeDecRef(out, buff, buffIndex, ch);
                continue;
            }
            buffIndex = HTMLEscapes._writeDecRef(out, buff, buffIndex, ch);
        }
        HTMLEscapes._flushBuffer(out, buff, buffIndex);
    }

    private static void _writeText(Writer out, String[] entities, char[] buff, String text, boolean isBodyText) throws IOException {
        int buffIndex = 0;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch < '\u00a0') {
                String entity;
                if (ch >= '?') {
                    buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, ch);
                    continue;
                }
                if (ch > '\r') {
                    entity = entities[ch];
                    if (entity == null) {
                        buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, ch);
                        continue;
                    }
                    if (ch == '&' && !isBodyText && i + 1 < length && text.charAt(i + 1) == '{') {
                        buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, ch);
                        continue;
                    }
                    buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, entity);
                    continue;
                }
                entity = entities[ch];
                if (entity != null) {
                    buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, entity);
                    continue;
                }
                buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                HTMLEscapes._println(out);
                char checkChar = (char)(ch == '\r' ? 10 : 13);
                if (i + 1 >= length || text.charAt(i + 1) != checkChar) continue;
                ++i;
                continue;
            }
            if (ch <= '\u00ff') {
                buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, _sISO8859_1_Entities[ch - 160]);
                continue;
            }
            if (ch >= '\ufffe') continue;
            if (isBodyText) {
                if (ch == '\u2028') {
                    buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, "<br>");
                    continue;
                }
                if (ch == '\u2027') {
                    buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, "<wbr>");
                    continue;
                }
                buffIndex = HTMLEscapes._writeDecRef(out, buff, buffIndex, ch);
                continue;
            }
            buffIndex = HTMLEscapes._writeDecRef(out, buff, buffIndex, ch);
        }
        HTMLEscapes._flushBuffer(out, buff, buffIndex);
    }

    private static int _writeDecRef(Writer out, char[] buff, int buffIndex, char ch) throws IOException {
        if (buffIndex + 8 > buff.length) {
            buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
            XMLEscapes.__writeDecRef(out, (char)ch);
        } else {
            int i = ch;
            buff[buffIndex++] = 38;
            buff[buffIndex++] = 35;
            if (i > 10000) {
                buff[buffIndex++] = (char)(48 + i / 10000);
                buff[buffIndex++] = (char)(48 + (i %= 10000) / 1000);
                buff[buffIndex++] = (char)(48 + (i %= 1000) / 100);
                buff[buffIndex++] = (char)(48 + (i %= 100) / 10);
                buff[buffIndex++] = (char)(48 + (i %= 10));
            } else if (i > 1000) {
                buff[buffIndex++] = (char)(48 + i / 1000);
                buff[buffIndex++] = (char)(48 + (i %= 1000) / 100);
                buff[buffIndex++] = (char)(48 + (i %= 100) / 10);
                buff[buffIndex++] = (char)(48 + (i %= 10));
            } else {
                buff[buffIndex++] = (char)(48 + i / 100);
                buff[buffIndex++] = (char)(48 + (i %= 100) / 10);
                buff[buffIndex++] = (char)(48 + (i %= 10));
            }
            buff[buffIndex++] = 59;
        }
        return buffIndex;
    }

    private static int _addToBuffer(Writer out, char[] buffer, int bufferIndex, char ch) throws IOException {
        if (bufferIndex >= buffer.length) {
            out.write(buffer, 0, bufferIndex);
            bufferIndex = 0;
        }
        buffer[bufferIndex] = ch;
        return bufferIndex + 1;
    }

    private static int _addToBuffer(Writer out, char[] buffer, int bufferIndex, String outString) throws IOException {
        int writeSize = outString.length();
        int outSize = bufferIndex + writeSize;
        if (outSize >= buffer.length) {
            out.write(buffer, 0, bufferIndex);
            bufferIndex = 0;
            outSize = writeSize;
        }
        outString.getChars(0, writeSize, buffer, bufferIndex);
        return outSize;
    }

    private static int _flushBuffer(Writer out, char[] buffer, int bufferIndex) throws IOException {
        if (bufferIndex > 0) {
            out.write(buffer, 0, bufferIndex);
        }
        return 0;
    }

    private static void _println(Writer out) throws IOException {
        out.write(10);
    }

    private HTMLEscapes() {
    }

    static {
        HTMLEscapes._ATTRIBUTE_ENTITIES[34] = "&quot;";
        _sISO8859_1_Entities = new String[]{"&nbsp;", "&iexcl;", "&cent;", "&pound;", "&curren;", "&yen;", "&brvbar;", "&sect;", "&uml;", "&copy;", "&ordf;", "&laquo;", "&not;", "&shy;", "&reg;", "&macr;", "&deg;", "&plusmn;", "&sup2;", "&sup3;", "&acute;", "&micro;", "&para;", "&middot;", "&cedil;", "&sup1;", "&ordm;", "&raquo;", "&frac14;", "&frac12;", "&frac34;", "&iquest;", "&Agrave;", "&Aacute;", "&Acirc;", "&Atilde;", "&Auml;", "&Aring;", "&AElig;", "&Ccedil;", "&Egrave;", "&Eacute;", "&Ecirc;", "&Euml;", "&Igrave;", "&Iacute;", "&Icirc;", "&Iuml;", "&ETH;", "&Ntilde;", "&Ograve;", "&Oacute;", "&Ocirc;", "&Otilde;", "&Ouml;", "&times;", "&Oslash;", "&Ugrave;", "&Uacute;", "&Ucirc;", "&Uuml;", "&Yacute;", "&THORN;", "&szlig;", "&agrave;", "&aacute;", "&acirc;", "&atilde;", "&auml;", "&aring;", "&aelig;", "&ccedil;", "&egrave;", "&eacute;", "&ecirc;", "&euml;", "&igrave;", "&iacute;", "&icirc;", "&iuml;", "&eth;", "&ntilde;", "&ograve;", "&oacute;", "&ocirc;", "&otilde;", "&ouml;", "&divide;", "&oslash;", "&ugrave;", "&uacute;", "&ucirc;", "&uuml;", "&yacute;", "&thorn;", "&yuml;"};
    }
}

