/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.core.CoreDocument;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.BodyRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.HeadRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.HtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class DocumentRenderer
extends XhtmlRenderer {
    private static final String _HEAD_ID_SUFFIX = "h";
    private CoreRenderer _html;
    private CoreRenderer _head;
    private CoreRenderer _body;

    public DocumentRenderer() {
        this(CoreDocument.TYPE);
    }

    protected DocumentRenderer(FacesBean.Type type) {
        super(type);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._html = new HtmlRenderer(type);
        this._head = new Head(type);
        this._body = new BodyRenderer(type);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        this.delegateRendererBegin(context, arc, component, bean, this._html);
        this.delegateRendererBegin(context, arc, component, bean, this._head);
        UIComponent meta = DocumentRenderer.getFacet((UIComponent)component, (String)"metaContainer");
        if (meta != null) {
            this.encodeChild(context, meta);
        }
        this.delegateRendererEnd(context, arc, component, bean, this._head);
        this.delegateRenderer(context, arc, component, bean, this._body);
        this.delegateRendererEnd(context, arc, component, bean, this._html);
    }

    private static class Head
    extends HeadRenderer {
        public Head(FacesBean.Type type) {
            super(type);
        }

        protected String getClientId(FacesContext context, UIComponent component) {
            String base = super.getClientId(context, component);
            return XhtmlUtils.getCompositeId(base, DocumentRenderer._HEAD_ID_SUFFIX);
        }
    }
}

